/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.detached;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedElement;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class DetachedVertex
extends DetachedElement<Vertex>
implements Vertex {
    private static final String ID = "id";
    private static final String VALUE = "value";
    private static final String PROPERTIES = "properties";

    private DetachedVertex() {
    }

    protected DetachedVertex(Vertex vertex, boolean withProperties) {
        super(vertex);
        Iterator propertyIterator;
        if (withProperties && (propertyIterator = vertex.properties(new String[0])).hasNext()) {
            this.properties = new HashMap();
            propertyIterator.forEachRemaining(property -> {
                List list = this.properties.getOrDefault(property.key(), new ArrayList());
                list.add(DetachedFactory.detach(property, true));
                this.properties.put(property.key(), list);
            });
        }
    }

    public DetachedVertex(Object id, String label, Map<String, Object> properties) {
        super(id, label);
        if (properties != null && !properties.isEmpty()) {
            this.properties = new HashMap();
            properties.entrySet().iterator().forEachRemaining(entry -> this.properties.put((String)entry.getKey(), IteratorUtils.list(IteratorUtils.map(((List)entry.getValue()).iterator(), m -> VertexProperty.class.isAssignableFrom(m.getClass()) ? (VertexProperty)m : new DetachedVertexProperty(((Map)m).get(ID), (String)entry.getKey(), ((Map)m).get(VALUE), ((Map)m).getOrDefault(PROPERTIES, new HashMap()), this)))));
        }
    }

    @Override
    public <V> VertexProperty<V> property(String key, V value) {
        throw Element.Exceptions.propertyAdditionNotSupported();
    }

    @Override
    public <V> VertexProperty<V> property(String key, V value, Object ... keyValues) {
        throw Element.Exceptions.propertyAdditionNotSupported();
    }

    @Override
    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        throw Element.Exceptions.propertyAdditionNotSupported();
    }

    @Override
    public <V> VertexProperty<V> property(String key) {
        if (null != this.properties && this.properties.containsKey(key)) {
            List list = (List)this.properties.get(key);
            if (list.size() > 1) {
                throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key);
            }
            return (VertexProperty)list.get(0);
        }
        return VertexProperty.empty();
    }

    @Override
    public Edge addEdge(String label, Vertex inVertex, Object ... keyValues) {
        throw Vertex.Exceptions.edgeAdditionsNotSupported();
    }

    public String toString() {
        return StringFactory.vertexString(this);
    }

    @Override
    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        return super.properties(propertyKeys);
    }

    @Override
    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<Vertex> vertices(Direction direction, String ... labels) {
        return Collections.emptyIterator();
    }

    @Override
    public void remove() {
        throw Vertex.Exceptions.vertexRemovalNotSupported();
    }

    @Override
    void internalAddProperty(Property p) {
        if (null == this.properties) {
            this.properties = new HashMap();
        }
        if (!this.properties.containsKey(p.key())) {
            this.properties.put(p.key(), new ArrayList());
        }
        ((List)this.properties.get(p.key())).add(p);
    }

    public static Builder build() {
        return new Builder(new DetachedVertex());
    }

    public static class Builder {
        private DetachedVertex v;

        private Builder(DetachedVertex v) {
            this.v = v;
        }

        public Builder addProperty(DetachedVertexProperty vp) {
            this.v.internalAddProperty(vp);
            vp.internalSetVertex(this.v);
            return this;
        }

        public Builder setId(Object id) {
            this.v.id = id;
            return this;
        }

        public Builder setLabel(String label) {
            this.v.label = label;
            return this;
        }

        public DetachedVertex create() {
            return this.v;
        }
    }
}

