/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVSymbolRecord;
import com.oracle.objectfile.pecoff.cv.CVSymbolSectionImpl;
import com.oracle.objectfile.pecoff.cv.CVUtil;

final class CVStringTableRecord
extends CVSymbolRecord {
    private final CVSymbolSectionImpl.CVStringTable stringTable;

    CVStringTableRecord(CVDebugInfo cvDebugInfo, CVSymbolSectionImpl.CVStringTable stringTable) {
        super(cvDebugInfo, 243);
        this.stringTable = stringTable;
    }

    @Override
    public int computeSize(int pos) {
        return pos + this.stringTable.getCurrentOffset();
    }

    @Override
    public int computeContents(byte[] buffer, int initialPos) {
        int pos = initialPos;
        for (CVSymbolSectionImpl.CVStringTable.StringTableEntry entry : this.stringTable.values()) {
            pos = CVUtil.putUTF8StringBytes(entry.text, buffer, pos);
        }
        return pos;
    }

    @Override
    public String toString() {
        return String.format("CVStringTableRecord(type=0x%04x pos=0x%06x count=%d)", this.type, this.recordStartPosition, this.stringTable.size());
    }
}

