/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;

final class NullableBinaryMarshaller<T>
implements BinaryMarshaller<T> {
    private static final byte NULL = 0;
    private static final byte NON_NULL = 1;
    private final BinaryMarshaller<T> delegate;

    NullableBinaryMarshaller(BinaryMarshaller<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T read(BinaryInput input) {
        byte nullStatus = input.readByte();
        switch (nullStatus) {
            case 0: {
                return null;
            }
            case 1: {
                return this.delegate.read(input);
            }
        }
        throw new IllegalArgumentException("Unexpected input " + nullStatus);
    }

    @Override
    public void write(BinaryOutput output, T object) {
        if (object != null) {
            output.writeByte(1);
            this.delegate.write(output, object);
        } else {
            output.writeByte(0);
        }
    }

    @Override
    public int inferSize(T object) {
        if (object != null) {
            return 1 + this.delegate.inferSize(object);
        }
        return 1;
    }
}

