/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Objects;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.libgraal.jni.LibGraalJNIMethodScope;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;

public final class LibGraalUtil {
    private LibGraalUtil() {
    }

    public static JNIMethodScope openScope(Class<?> entryPointClass, Enum<?> id, JNI.JNIEnv env) {
        Objects.requireNonNull(id, "Id must be non null.");
        return LibGraalJNIMethodScope.open(entryPointClass.getSimpleName() + "::" + id, env);
    }

    public static JNIMethodScope openScope(String scopeName, JNI.JNIEnv env) {
        return LibGraalJNIMethodScope.open(scopeName, env);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void checkToLibGraalCalls(Class<?> toLibGraalEntryPointsClass, Class<?> toLibGraalCallsClass, Class<? extends Annotation> annotationClass) throws InternalError {
        try {
            Method valueMethod = annotationClass.getDeclaredMethod("value", new Class[0]);
            Type t = valueMethod.getGenericReturnType();
            LibGraalUtil.check(t instanceof Class && ((Class)t).isEnum(), "Annotation value must be enum.", new Object[0]);
            EnumSet<Enum> unimplemented = EnumSet.allOf(((Class)t).asSubclass(Enum.class));
            for (Method libGraalMethod : toLibGraalEntryPointsClass.getDeclaredMethods()) {
                Annotation call = libGraalMethod.getAnnotation(annotationClass);
                if (call == null) continue;
                LibGraalUtil.check(Modifier.isStatic(libGraalMethod.getModifiers()), "Method annotated by %s must be static: %s", annotationClass, libGraalMethod);
                CEntryPoint ep = libGraalMethod.getAnnotation(CEntryPoint.class);
                LibGraalUtil.check(ep != null, "Method annotated by %s must also be annotated by %s: %s", annotationClass, CEntryPoint.class, libGraalMethod);
                String name = ep.name();
                String prefix = "Java_" + toLibGraalCallsClass.getName().replace('.', '_') + "_";
                LibGraalUtil.check(name.startsWith(prefix), "Method must be a JNI entry point for a method in %s: %s", toLibGraalCallsClass, libGraalMethod);
                name = name.substring(prefix.length());
                Method hsMethod = LibGraalUtil.findHSMethod(toLibGraalCallsClass, name, annotationClass);
                Class<?>[] libGraalParameters = libGraalMethod.getParameterTypes();
                Class<?>[] hsParameters = hsMethod.getParameterTypes();
                LibGraalUtil.check(hsParameters.length + 2 == libGraalParameters.length, "%s should have 2 more parameters than %s", libGraalMethod, hsMethod);
                LibGraalUtil.check(libGraalParameters.length >= 3, "Expect at least 3 parameters: %s", libGraalMethod);
                LibGraalUtil.check(libGraalParameters[0] == JNI.JNIEnv.class, "Parameter 0 must be of type %s: %s", JNI.JNIEnv.class, libGraalMethod);
                LibGraalUtil.check(libGraalParameters[1] == JNI.JClass.class, "Parameter 1 must be of type %s: %s", JNI.JClass.class, libGraalMethod);
                LibGraalUtil.check(libGraalParameters[2] == Long.TYPE, "Parameter 2 must be of type long: %s", libGraalMethod);
                LibGraalUtil.check(hsParameters[0] == Long.TYPE, "Parameter 0 must be of type long: %s", hsMethod);
                int i = 3;
                int j = 1;
                while (i < libGraalParameters.length) {
                    Class<Object> hsExpect;
                    Class<?> libgraal = libGraalParameters[i];
                    Class<?> hs = hsParameters[j];
                    if (hs.isPrimitive()) {
                        hsExpect = libgraal;
                    } else if (libgraal == JNI.JString.class) {
                        hsExpect = String.class;
                    } else if (libgraal == JNI.JByteArray.class) {
                        hsExpect = byte[].class;
                    } else if (libgraal == JNI.JLongArray.class) {
                        hsExpect = long[].class;
                    } else if (libgraal == JNI.JObjectArray.class) {
                        hsExpect = Object[].class;
                    } else {
                        LibGraalUtil.check(libgraal == JNI.JObject.class, "must be", new Object[0]);
                        hsExpect = Object.class;
                    }
                    LibGraalUtil.check(hsExpect.isAssignableFrom(hs), "HotSpot parameter %d (%s) incompatible with libgraal parameter %d (%s): %s", j, hs.getName(), i, libgraal.getName(), hsMethod);
                    ++i;
                    ++j;
                }
                unimplemented.remove(valueMethod.invoke((Object)call, new Object[0]));
            }
            LibGraalUtil.check(unimplemented.isEmpty(), "Unimplemented libgraal calls: %s", unimplemented);
        }
        catch (ReflectiveOperationException e) {
            throw new InternalError(e);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void check(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new InternalError(String.format(format, args));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Method findHSMethod(Class<?> hsClass, String name, Class<? extends Annotation> annotationClass) {
        Method res = null;
        for (Method m : hsClass.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            LibGraalUtil.check(res == null, "More than one method named \"%s\" in %s", name, hsClass);
            Annotation call = m.getAnnotation(annotationClass);
            LibGraalUtil.check(call != null, "Method must be annotated by %s: %s", annotationClass, m);
            LibGraalUtil.check(Modifier.isStatic(m.getModifiers()) && Modifier.isNative(m.getModifiers()), "Method must be static and native: %s", m);
            res = m;
        }
        LibGraalUtil.check(res != null, "Could not find method named \"%s\" in %s", name, hsClass);
        return res;
    }
}

