/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.options;

import com.oracle.truffle.api.Option;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptionsOptionDescriptors;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;

@Option.Group(value={"engine"})
public final class PolyglotCompilerOptions {
    static final OptionType<EngineModeEnum> ENGINE_MODE_TYPE = new OptionType("EngineMode", (Function)new Function<String, EngineModeEnum>(){

        @Override
        public EngineModeEnum apply(String s) {
            try {
                return EngineModeEnum.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Mode can be: 'default', 'latency' or 'throughput'.");
            }
        }
    });
    static final OptionType<Set<CompilationTier>> COMPILATION_TIERS_TYPE = new OptionType("Tier", (Function)new Function<String, Set<CompilationTier>>(){

        @Override
        public Set<CompilationTier> apply(String s) {
            if (s.equals("true")) {
                return Collections.singleton(CompilationTier.truffleTier);
            }
            if (s.equals("false")) {
                return Collections.emptySet();
            }
            String[] strings = s.split(",");
            EnumSet<CompilationTier> tiers = EnumSet.noneOf(CompilationTier.class);
            for (int i = 0; i < strings.length; ++i) {
                tiers.add(CompilationTier.parse(strings[i]));
            }
            return Collections.unmodifiableSet(tiers);
        }
    });
    static final OptionType<ExceptionAction> EXCEPTION_ACTION_TYPE = new OptionType("ExceptionAction", (Function)new Function<String, ExceptionAction>(){

        @Override
        public ExceptionAction apply(String s) {
            try {
                return ExceptionAction.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.", new Object[0]));
            }
        }
    });
    static final OptionType<Set<PerformanceWarningKind>> PERFORMANCE_WARNING_TYPE = new OptionType("PerformanceWarningKind", (Function)new Function<String, Set<PerformanceWarningKind>>(){

        @Override
        public Set<PerformanceWarningKind> apply(String value) {
            if ("none".equals(value)) {
                return EnumSet.noneOf(PerformanceWarningKind.class);
            }
            if ("all".equals(value)) {
                EnumSet<PerformanceWarningKind> result = EnumSet.allOf(PerformanceWarningKind.class);
                result.removeIf(PerformanceWarningKind::isOptional);
                return result;
            }
            EnumSet<PerformanceWarningKind> result = EnumSet.noneOf(PerformanceWarningKind.class);
            for (String name : value.split(",")) {
                if ("bailout".equals(name)) continue;
                try {
                    result.add(PerformanceWarningKind.forName(name));
                }
                catch (IllegalArgumentException e) {
                    Object message = String.format("The \"%s\" is not a valid performance warning kind. Valid values are%n", name);
                    for (PerformanceWarningKind kind : PerformanceWarningKind.values()) {
                        message = (String)message + String.format("%s%s%s%n", kind.name, this.indent(kind.name.length()), kind.help);
                    }
                    message = (String)message + String.format("all%sEnables all performance warnings%n", this.indent(3));
                    message = (String)message + String.format("none%sDisables performance warnings%n", this.indent(4));
                    throw new IllegalArgumentException((String)message);
                }
            }
            return result;
        }

        private String indent(int nameLength) {
            int len = Math.max(1, 16 - nameLength);
            return new String(new char[len]).replace('\u0000', ' ');
        }
    });
    private static final String PERFORMANCE_WARNING_SYNTAX = "none|all|<perfWarning>,<perfWarning>,...";
    private static final String PERFORMANCE_WARNING_LIST = "Performance warnings are: call, instanceof, store, frame_merge, trivial.";
    @Option(help="Configures the execution mode of the engine. Available modes are 'latency' and 'throughput'. The default value balances between the two.", usageSyntax="latency|throughput", category=OptionCategory.EXPERT, stability=OptionStability.STABLE)
    public static final OptionKey<EngineModeEnum> Mode = new OptionKey((Object)EngineModeEnum.DEFAULT, ENGINE_MODE_TYPE);
    @Option(help="Enable or disable Truffle compilation.", usageSyntax="true|false", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> Compilation = new OptionKey((Object)true);
    @Option(help="Restrict compilation to ','-separated list of includes (or excludes prefixed with '~'). No restriction by default.", usageSyntax="<name>,<name>,...", category=OptionCategory.INTERNAL)
    public static final OptionKey<String> CompileOnly = new OptionKey(null, OptionType.defaultType(String.class));
    @Option(help="Compile immediately to test Truffle compilation", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> CompileImmediately = new OptionKey((Object)false);
    @Option(help="Compiles created call targets immediately with last tier. Disables background compilation if enabled.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> CompileAOTOnCreate = new OptionKey((Object)false);
    @Option(help="Enable asynchronous truffle compilation in background threads (default: true)", usageSyntax="true|false", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> BackgroundCompilation = new OptionKey((Object)true);
    @Option(help="Manually set the number of compiler threads. By default, the number of compiler threads is scaled with the number of available cores on the CPU.", usageSyntax="[1, inf)", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> CompilerThreads = new OptionKey((Object)-1);
    @Option(help="Set the time in milliseconds an idle Truffle compiler thread will wait for new tasks before terminating. New compiler threads will be started once new compilation tasks are submitted. Select '0' to never terminate the Truffle compiler thread. The option is not supported by all Truffle runtimes. On the runtime which doesn't support it the option has no effect. default: 10000", usageSyntax="<ms>", category=OptionCategory.EXPERT)
    public static final OptionKey<Long> CompilerIdleDelay = new OptionKey((Object)10000L);
    @Option(help="Minimum number of invocations or loop iterations needed to compile a guest language root when not using multi tier (default: 1000).", usageSyntax="[1, inf)", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> SingleTierCompilationThreshold = new OptionKey((Object)1000);
    @Option(help="Minimum number of calls before a call target is compiled (default: 3).", usageSyntax="[1, inf)", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> MinInvokeThreshold = new OptionKey((Object)3);
    @Option(help="Delay compilation after an invalidation to allow for reprofiling. Deprecated: no longer has any effect.", category=OptionCategory.EXPERT, deprecated=true)
    public static final OptionKey<Integer> InvalidationReprofileCount = new OptionKey((Object)3);
    @Option(help="Delay compilation after a node replacement. Deprecated: no longer has any effect.", category=OptionCategory.EXPERT, deprecated=true)
    public static final OptionKey<Integer> ReplaceReprofileCount = new OptionKey((Object)3);
    @Option(help="Speculate on arguments types at call sites (default: true)", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> ArgumentTypeSpeculation = new OptionKey((Object)true);
    @Option(help="Speculate on return types at call sites (default: true)", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> ReturnTypeSpeculation = new OptionKey((Object)true);
    @Option(help="Enable/disable builtin profiles in com.oracle.truffle.api.profiles. (default: true)", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> Profiling = new OptionKey((Object)true);
    @Option(help="Whether to use multiple Truffle compilation tiers by default. (default: true)", usageSyntax="true|false", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> MultiTier = new OptionKey((Object)true);
    @Option(help="Explicitly pick a first tier inlining policy by name (None, TrivialOnly). If empty (default) the lowest priority policy (TrivialOnly) is chosen.", usageSyntax="<policy>", category=OptionCategory.INTERNAL)
    public static final OptionKey<String> FirstTierInliningPolicy = new OptionKey((Object)"");
    @Option(help="Minimum number of invocations or loop iterations needed to compile a guest language root in first tier under normal compilation load (default: 400).", usageSyntax="[1, inf)", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> FirstTierCompilationThreshold = new OptionKey((Object)400);
    @Option(help="Minimum number of invocations or loop iterations needed to compile a guest language root in last tier under normal compilation load (default: 10000).", usageSyntax="[1, inf)", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> LastTierCompilationThreshold = new OptionKey((Object)10000);
    @Option(help="Minimum number of calls before a call target is compiled in the first tier (default: 1)", usageSyntax="[1, inf)", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> FirstTierMinInvokeThreshold = new OptionKey((Object)1);
    @Option(help="Whether to use the economy configuration in the first-tier compilations. (default: true)", usageSyntax="true|false", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> FirstTierUseEconomy = new OptionKey((Object)true);
    @Option(help="Whether to emit look-back-edge counters in the first-tier compilations. (default: true)", usageSyntax="true|false", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> FirstTierBackedgeCounts = new OptionKey((Object)true);
    @Option(help="Prints the exception stack trace for compilation exceptions", category=OptionCategory.INTERNAL, deprecated=true, deprecationMessage="Use 'engine.CompilationFailureAction=Print'")
    public static final OptionKey<Boolean> CompilationExceptionsArePrinted = new OptionKey((Object)false);
    @Option(help="Treat compilation exceptions as thrown runtime exceptions", category=OptionCategory.INTERNAL, deprecated=true, deprecationMessage="Use 'engine.CompilationFailureAction=Throw'")
    public static final OptionKey<Boolean> CompilationExceptionsAreThrown = new OptionKey((Object)false);
    @Option(help="Treat compilation exceptions as fatal exceptions that will exit the application", category=OptionCategory.INTERNAL, deprecated=true, deprecationMessage="Use 'engine.CompilationFailureAction=ExitVM'")
    public static final OptionKey<Boolean> CompilationExceptionsAreFatal = new OptionKey((Object)false);
    @Option(help="Treat performance warnings as fatal occurrences that will exit the applications", category=OptionCategory.INTERNAL, deprecated=true, deprecationMessage="Use 'engine.CompilationFailureAction=ExitVM' 'engine.TreatPerformanceWarningsAsErrors=<PerformanceWarningKinds>'")
    public static final OptionKey<Set<PerformanceWarningKind>> PerformanceWarningsAreFatal = new OptionKey(Collections.emptySet(), PERFORMANCE_WARNING_TYPE);
    @Option(help="Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.", usageSyntax="Silent|Print|Throw|Diagnose|ExitVM", category=OptionCategory.INTERNAL)
    public static final OptionKey<ExceptionAction> CompilationFailureAction = new OptionKey((Object)ExceptionAction.Silent, EXCEPTION_ACTION_TYPE);
    @Option(help="Treat performance warnings as error. Handling of the error depends on the CompilationFailureAction option value. Performance warnings are: call, instanceof, store, frame_merge, trivial.", usageSyntax="none|all|<perfWarning>,<perfWarning>,...", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<PerformanceWarningKind>> TreatPerformanceWarningsAsErrors = new OptionKey(Collections.emptySet(), PERFORMANCE_WARNING_TYPE);
    @Option(help="Print information for compilation results.", category=OptionCategory.EXPERT, stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> TraceCompilation = new OptionKey((Object)false);
    @Option(help="Print information for compilation queuing.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceCompilationDetails = new OptionKey((Object)false);
    @Option(help="Print all polymorphic and generic nodes after each compilation", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceCompilationPolymorphism = new OptionKey((Object)false);
    @Option(help="Print the entire AST after each compilation", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceCompilationAST = new OptionKey((Object)false);
    @Option(help="Print information for inlining decisions.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceInlining = new OptionKey((Object)false);
    @Option(help="Print information for splitting decisions.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceSplitting = new OptionKey((Object)false);
    @Option(help="Print Truffle compilation statistics at the end of a run.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> CompilationStatistics = new OptionKey((Object)false);
    @Option(help="Print additional more verbose Truffle compilation statistics at the end of a run.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> CompilationStatisticDetails = new OptionKey((Object)false);
    @Option(help="Number of stack trace elements printed by TraceTruffleTransferToInterpreter, TraceTruffleAssumptions and TraceDeoptimizeFrame (default: 20).", usageSyntax="[1, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> TraceStackTraceLimit = new OptionKey((Object)20);
    @Option(help="Print stack trace on transfer to interpreter.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceTransferToInterpreter = new OptionKey((Object)false);
    @Option(help="Print stack trace on assumption invalidation", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceAssumptions = new OptionKey((Object)false);
    @Option(help="Print stack trace when deoptimizing a frame from the stack with `FrameInstance#getFrame(READ_WRITE|MATERIALIZE)`.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceDeoptimizeFrame = new OptionKey((Object)false);
    private static final String EXPANSION_VALUES = "Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.";
    private static final String EXPANSION_SYNTAX = "true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...";
    @Option(help="Print a tree of all expanded Java methods with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.", usageSyntax="true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<CompilationTier>> TraceMethodExpansion = new OptionKey(Collections.emptySet(), COMPILATION_TIERS_TYPE);
    @Option(help="Print a tree of all expanded Truffle nodes with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.", usageSyntax="true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<CompilationTier>> TraceNodeExpansion = new OptionKey(Collections.emptySet(), COMPILATION_TIERS_TYPE);
    @Option(help="Print statistics on expanded Java methods during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.", usageSyntax="true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<CompilationTier>> MethodExpansionStatistics = new OptionKey(Collections.emptySet(), COMPILATION_TIERS_TYPE);
    @Option(help="Print statistics on expanded Truffle nodes during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.", usageSyntax="true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<CompilationTier>> NodeExpansionStatistics = new OptionKey(Collections.emptySet(), COMPILATION_TIERS_TYPE);
    @Option(help="Prints a histogram of all expanded Java methods.", category=OptionCategory.INTERNAL, deprecated=true, deprecationMessage="The expansion histogram was superseeded by engine.TraceMethodExpansion, engine.TraceNodeExpansion, engine.MethodExpansionHistogram and engine.NodeExpansionHistogram.")
    public static final OptionKey<Boolean> PrintExpansionHistogram = new OptionKey((Object)false);
    @Option(help="Restrict inlined methods to ','-separated list of includes (or excludes prefixed with '~'). No restriction by default.", usageSyntax="<name>,<name>,...", category=OptionCategory.INTERNAL)
    public static final OptionKey<String> InlineOnly = new OptionKey(null, OptionType.defaultType(String.class));
    @Option(help="Enable automatic inlining of guest language call targets (default: true).", usageSyntax="true|false", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> Inlining = new OptionKey((Object)true);
    @Option(help="Maximum depth for recursive inlining (default: 2).", usageSyntax="[0, inf)", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> InliningRecursionDepth = new OptionKey((Object)2);
    @Option(help="Enable automatic duplication of compilation profiles (splitting) (default: true).", usageSyntax="true|false", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> Splitting = new OptionKey((Object)true);
    @Option(help="Disable call target splitting if tree size exceeds this limit (default: 100)", usageSyntax="[1, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> SplittingMaxCalleeSize = new OptionKey((Object)100);
    @Option(help="Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count (default: 1.5).", usageSyntax="[0.0, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Double> SplittingGrowthLimit = new OptionKey((Object)1.5);
    @Option(help="Propagate info about a polymorphic specialize through maximum this many call targets (default: 5)", usageSyntax="[1, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> SplittingMaxPropagationDepth = new OptionKey((Object)5);
    @Option(help="Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceSplittingSummary = new OptionKey((Object)false);
    @Option(help="Trace details of splitting events and decisions.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> SplittingTraceEvents = new OptionKey((Object)false);
    @Option(help="Dumps to IGV information on polymorphic events", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> SplittingDumpDecisions = new OptionKey((Object)false);
    @Option(help="Should forced splits be allowed (default: true)", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> SplittingAllowForcedSplits = new OptionKey((Object)true);
    @Option(help="Enable automatic on-stack-replacement of loops (default: true).", usageSyntax="true|false", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> OSR = new OptionKey((Object)true);
    @Option(help="Number of loop iterations until on-stack-replacement compilation is triggered (default 100352).", usageSyntax="[1, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> OSRCompilationThreshold = new OptionKey((Object)100352);
    @Option(help="Number of compilation re-attempts before bailing out of OSR compilation for a given method (default 30). This number is an approximation of the acceptable number of deopts.", usageSyntax="[0, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> OSRMaxCompilationReAttempts = new OptionKey((Object)30);
    @Option(help="Whether an AssertionError is thrown when the maximum number of OSR compilation attempts is reached for a given method (default 'false'). This should only be set to 'true' in testing environments.", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> ThrowOnMaxOSRCompilationReAttemptsReached = new OptionKey((Object)false);
    @Option(help="Enable partial compilation for BlockNode (default: true).", usageSyntax="true|false", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> PartialBlockCompilation = new OptionKey((Object)true);
    @Option(help="Sets the target non-trivial Truffle node size for partial compilation of BlockNode nodes (default: 3000).", usageSyntax="[1, inf)", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> PartialBlockCompilationSize = new OptionKey((Object)3000);
    @Option(help="Sets the maximum non-trivial Truffle node size for partial compilation of BlockNode nodes (default: 10000).", usageSyntax="[1, inf)", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> PartialBlockMaximumSize = new OptionKey((Object)10000);
    @Option(help="Enable inlining across Truffle boundary", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InlineAcrossTruffleBoundary = new OptionKey((Object)false);
    @Option(help="Print potential performance problems, Performance warnings are: call, instanceof, store, frame_merge, trivial.", usageSyntax="none|all|<perfWarning>,<perfWarning>,...", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<PerformanceWarningKind>> TracePerformanceWarnings = new OptionKey(Collections.emptySet(), PERFORMANCE_WARNING_TYPE);
    @Option(help="Run the partial escape analysis iteratively in Truffle compilation.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> IterativePartialEscape = new OptionKey((Object)false);
    @Option(help="Method filter for host methods in which to add instrumentation.", usageSyntax="<method>,<method>,...", category=OptionCategory.INTERNAL)
    public static final OptionKey<String> InstrumentFilter = new OptionKey((Object)"*.*.*");
    @Option(help="Maximum number of instrumentation counters available (default: 10000).", usageSyntax="[1, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> InstrumentationTableSize = new OptionKey((Object)10000);
    @Option(help="Stop partial evaluation when the graph exceeded this many nodes (default: 40000).", usageSyntax="[1, inf)", category=OptionCategory.INTERNAL, deprecated=true, deprecationMessage="Use MaximumGraalGraphSize.")
    public static final OptionKey<Integer> MaximumGraalNodeCount = new OptionKey((Object)400000);
    @Option(help="Stop partial evaluation when the graph exceeded this size (default: 150000).", usageSyntax="[1, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> MaximumGraalGraphSize = new OptionKey((Object)150000);
    @Option(help="Ignore further truffle inlining decisions when the graph exceeded this many nodes (default: 150000).", usageSyntax="[1, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> MaximumInlineNodeCount = new OptionKey((Object)150000);
    @Option(help="Exclude assertion code from Truffle compilations (default: true)", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> ExcludeAssertions = new OptionKey((Object)true);
    @Option(help="Enable node source positions in truffle partial evaluations.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> NodeSourcePositions = new OptionKey((Object)false);
    @Option(help="Instrument Truffle boundaries and output profiling information to the standard output.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InstrumentBoundaries = new OptionKey((Object)false);
    @Option(help="Instrument Truffle boundaries by considering different inlining sites as different branches.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InstrumentBoundariesPerInlineSite = new OptionKey((Object)false);
    @Option(help="Instrument branches and output profiling information to the standard output.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InstrumentBranches = new OptionKey((Object)false);
    @Option(help="Instrument branches by considering different inlining sites as different branches.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InstrumentBranchesPerInlineSite = new OptionKey((Object)false);
    @Option(help="Cache encoded graphs across Truffle compilations to speed up partial evaluation. (default: true).", usageSyntax="true|false", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> EncodedGraphCache = new OptionKey((Object)true);
    @Option(help="Allow assumptions during parsing of seed graphs for partial evaluation. Disables the persistent encoded graph cache 'engine.EncodedGraphCache'. (default: false).", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> ParsePEGraphsWithAssumptions = new OptionKey((Object)false);
    @Option(help="Delay, in milliseconds, after which the encoded graph cache is dropped when a Truffle compiler thread becomes idle (default: 10000).", usageSyntax="<ms>", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> EncodedGraphCachePurgeDelay = new OptionKey((Object)10000);
    @Option(help="Forces the frame clearing mechanism to be executed, even if Frame.clear() is not used.", category=OptionCategory.EXPERT, deprecated=true, deprecationMessage="The analysis is now always executed, irrespective of this option")
    public static final OptionKey<Boolean> ForceFrameLivenessAnalysis = new OptionKey((Object)false);
    @Option(help="Use the priority of compilation jobs in the compilation queue (default: true).", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> PriorityQueue = new OptionKey((Object)true);
    @Option(help="Use a traversing compilation queue. (default: true)", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraversingCompilationQueue = new OptionKey((Object)true);
    @Option(help="Traversing queue uses rate as priority for both tier. (default: true)", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraversingQueueWeightingBothTiers = new OptionKey((Object)true);
    @Option(help="Traversing queue gives first tier compilations priority.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraversingQueueFirstTierPriority = new OptionKey((Object)false);
    @Option(help="Controls how much of a priority should be given to first tier compilations (default 15.0).", usageSyntax="[0.0, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Double> TraversingQueueFirstTierBonus = new OptionKey((Object)15.0);
    @Option(help="Reduce or increase the compilation threshold depending on the size of the compilation queue (default: true).", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> DynamicCompilationThresholds = new OptionKey((Object)true);
    @Option(help="Enables hotness propagation to lexical parent to lexically parent single callers.", usageSyntax="true|false", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> PropagateLoopCountToLexicalSingleCaller = new OptionKey((Object)true);
    @Option(help="How high to propagate call and loop count (hotness proxy) up a single caller chain to lexical scope parent.", usageSyntax="[0, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> PropagateLoopCountToLexicalSingleCallerMaxDepth = new OptionKey((Object)10);
    @Option(help="The minimal scale the compilation thresholds can be reduced to (default: 0.1).", usageSyntax="[0.0, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Double> DynamicCompilationThresholdsMinScale = new OptionKey((Object)0.1);
    @Option(help="The desired minimum compilation queue load. When the load falls bellow this value, the compilation thresholds are decreased. The load is scaled by the number of compiler threads (default: 10).", usageSyntax="[1, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> DynamicCompilationThresholdsMinNormalLoad = new OptionKey((Object)10);
    @Option(help="The desired maximum compilation queue load. When the load rises above this value, the compilation thresholds are increased. The load is scaled by the number of compiler threads.  (default: 10)", usageSyntax="[1, inf)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> DynamicCompilationThresholdsMaxNormalLoad = new OptionKey((Object)90);
    @Option(help="Print detailed information for inlining (i.e. the entire explored call tree).", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceInliningDetails = new OptionKey((Object)false);
    @Option(help="Explicitly pick a inlining policy by name. If empty (default) the highest priority chosen by default.", usageSyntax="<policy>", category=OptionCategory.INTERNAL)
    public static final OptionKey<String> InliningPolicy = new OptionKey((Object)"");
    @Option(help="The base expansion budget for language-agnostic inlining (default: 12000).", usageSyntax="[1, inf)", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> InliningExpansionBudget = new OptionKey((Object)12000);
    @Option(help="The base inlining budget for language-agnostic inlining (default: 12000)", usageSyntax="[1, inf)", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> InliningInliningBudget = new OptionKey((Object)12000);
    @Option(help="Use the graph size as a cost model during inlining (default: false).", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InliningUseSize = new OptionKey((Object)false);

    public static OptionDescriptors getDescriptors() {
        return new PolyglotCompilerOptionsOptionDescriptors();
    }

    public static enum ExceptionAction {
        Silent,
        Print,
        Throw,
        Diagnose,
        ExitVM;

        private static final String HELP = "Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.";
    }

    public static enum CompilationTier {
        peTier,
        truffleTier,
        lowTier;


        static CompilationTier parse(String name) {
            try {
                return CompilationTier.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Unknown tier option value '%s'. %s", name, PolyglotCompilerOptions.EXPANSION_VALUES));
            }
        }
    }

    public static enum PerformanceWarningKind {
        VIRTUAL_RUNTIME_CALL("call", "Enables virtual call warnings"),
        VIRTUAL_INSTANCEOF("instanceof", "Enables virtual instanceof warnings"),
        VIRTUAL_STORE("store", "Enables virtual store warnings"),
        FRAME_INCOMPATIBLE_MERGE("frame_merge", "Enables warnings about deopts inserted for incompatible frame slot merges"),
        TRIVIAL_FAIL("trivial", "Enables trivial fail warnings"),
        MISSING_LOOP_FREQUENCY_INFO("loop", "Enables missing loop frequency warnings", true);

        private static final EconomicMap<String, PerformanceWarningKind> kindByName;
        final String name;
        final String help;
        final boolean isOptional;

        private PerformanceWarningKind(String name, String help) {
            this(name, help, false);
        }

        private PerformanceWarningKind(String name, String help, boolean isOptional) {
            this.name = name;
            this.help = help;
            this.isOptional = isOptional;
        }

        boolean isOptional() {
            return this.isOptional;
        }

        public static PerformanceWarningKind forName(String name) {
            PerformanceWarningKind kind = (PerformanceWarningKind)((Object)kindByName.get((Object)name));
            if (kind == null) {
                throw new IllegalArgumentException("Unknown PerformanceWarningKind name " + name);
            }
            return kind;
        }

        static {
            kindByName = EconomicMap.create();
            for (PerformanceWarningKind kind : PerformanceWarningKind.values()) {
                kindByName.put((Object)kind.name, (Object)kind);
            }
        }
    }

    public static enum EngineModeEnum {
        DEFAULT,
        THROUGHPUT,
        LATENCY;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

