/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectState;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;
import org.graalvm.compiler.truffle.compiler.nodes.AnyExtendNode;

public final class PhiTransformPhase
extends BasePhase<CoreProviders> {
    private static final int MAX_ITERATIONS = 3;
    private final CanonicalizerPhase canonicalizer;

    public PhiTransformPhase(CanonicalizerPhase canonicalizer) {
        this.canonicalizer = canonicalizer;
    }

    private static ValidTransformation collectNodes(ValueNode node, EconomicSet<ValueNode> nodes, UnaryNode transformation, ResolvedJavaType longClass) {
        ValidTransformation valid = ValidTransformation.Valid;
        nodes.add((Object)node);
        for (Node usage : node.usages()) {
            if (usage instanceof VirtualObjectState) {
                if (!PhiTransformPhase.isValidStateUsage(usage, longClass)) {
                    return ValidTransformation.Invalid;
                }
                valid = ValidTransformation.WithState;
                continue;
            }
            if (usage instanceof NarrowNode) {
                if (!(transformation instanceof NarrowNode)) {
                    return ValidTransformation.Invalid;
                }
                NarrowNode n1 = (NarrowNode)usage;
                NarrowNode n2 = (NarrowNode)transformation;
                if (n1.getInputBits() == n2.getInputBits() && n1.getResultBits() == n2.getResultBits()) continue;
                return ValidTransformation.Invalid;
            }
            if (usage instanceof ReinterpretNode) {
                if (transformation instanceof ReinterpretNode) continue;
                return ValidTransformation.Invalid;
            }
            if (usage.getClass() == ValuePhiNode.class || usage.getClass() == ValueProxyNode.class) {
                if (!nodes.add((Object)((ValueNode)usage))) continue;
                ValidTransformation result = PhiTransformPhase.collectNodes((ValueNode)usage, nodes, transformation, longClass);
                if (result == ValidTransformation.Invalid) {
                    return ValidTransformation.Invalid;
                }
                if (result != ValidTransformation.WithState) continue;
                valid = result;
                continue;
            }
            return ValidTransformation.Invalid;
        }
        return valid;
    }

    private static boolean isValidStateUsage(Node usage, ResolvedJavaType longClass) {
        VirtualObjectNode object;
        if (usage instanceof VirtualObjectState && (object = ((VirtualObjectState)usage).object()) instanceof VirtualArrayNode) {
            return longClass.equals(((VirtualArrayNode)object).componentType());
        }
        return false;
    }

    private static boolean isValidInput(ValueNode value, UnaryNode transformation, boolean usedInState, EconomicSet<ValueNode> nodes) {
        if (nodes.contains((Object)value)) {
            return true;
        }
        if (value.isJavaConstant()) {
            return true;
        }
        if (transformation instanceof NarrowNode) {
            NarrowNode narrow = (NarrowNode)transformation;
            if (value instanceof IntegerConvertNode) {
                IntegerConvertNode convert = (IntegerConvertNode)value;
                if (convert.getInputBits() != narrow.getResultBits() || convert.getResultBits() != narrow.getInputBits()) {
                    return false;
                }
                return !usedInState;
            }
            if (value instanceof AnyExtendNode) {
                return narrow.getResultBits() == 32 && narrow.getInputBits() == 64;
            }
        } else {
            assert (transformation instanceof ReinterpretNode);
            return value instanceof ReinterpretNode;
        }
        return false;
    }

    private static ValueNode transformInputValue(StructuredGraph graph, ValueNode value, UnaryNode transformation, EconomicSet<ValueNode> nodes, EconomicSetNodeEventListener ec) {
        ValueNode newValue;
        if (nodes.contains((Object)value)) {
            newValue = value;
        } else {
            if (transformation instanceof NarrowNode) {
                NarrowNode narrow = (NarrowNode)transformation;
                if (value instanceof AnyExtendNode && narrow.getInputBits() == 64 && narrow.getResultBits() == 32) {
                    return ((AnyExtendNode)value).getValue();
                }
                newValue = graph.unique(new NarrowNode(value, narrow.getInputBits(), narrow.getResultBits()));
            } else {
                assert (transformation instanceof ReinterpretNode);
                newValue = graph.addOrUnique(ReinterpretNode.create(transformation.stamp(NodeView.DEFAULT), value, NodeView.DEFAULT));
            }
            ec.changed(Graph.NodeEvent.INPUT_CHANGED, newValue);
        }
        return newValue;
    }

    private static boolean checkTransformedNode(StructuredGraph graph, EconomicSetNodeEventListener ec, ResolvedJavaType longClass, Node node) {
        if (node.getClass() == ValuePhiNode.class || node.getClass() == ValueProxyNode.class) {
            UnaryNode transformation = null;
            for (Node usage : node.usages()) {
                if (usage instanceof NarrowNode || usage instanceof ReinterpretNode) {
                    if (transformation == null) {
                        transformation = (UnaryNode)usage;
                        continue;
                    }
                    return false;
                }
                if (usage.getClass() == ValuePhiNode.class || usage.getClass() == ValueProxyNode.class || usage.getClass() == VirtualObjectState.class) continue;
                return false;
            }
            if (transformation == null) {
                if (node.getClass() == ValuePhiNode.class) {
                    ReinterpretNode reinterpret = ((ValuePhiNode)node).values().filter(ReinterpretNode.class).first();
                    AnyExtendNode convert = ((ValuePhiNode)node).values().filter(AnyExtendNode.class).first();
                    if (reinterpret != null && convert == null) {
                        transformation = new ReinterpretNode(reinterpret.getValue().getStackKind(), (ValueNode)node);
                    } else if (reinterpret == null && convert != null) {
                        transformation = new NarrowNode((ValueNode)node, 64, 32);
                    }
                }
                if (transformation == null) {
                    return false;
                }
            }
            assert (transformation instanceof NarrowNode || transformation instanceof ReinterpretNode);
            EconomicSet nodes = EconomicSet.create();
            ValidTransformation valid = PhiTransformPhase.collectNodes((ValueNode)node, (EconomicSet<ValueNode>)nodes, transformation, longClass);
            if (valid == ValidTransformation.Invalid) {
                return false;
            }
            for (ValueNode target : nodes) {
                if (target.getClass() == ValuePhiNode.class) {
                    for (ValueNode value : ((ValuePhiNode)target).values()) {
                        if (PhiTransformPhase.isValidInput(value, transformation, valid == ValidTransformation.WithState, (EconomicSet<ValueNode>)nodes)) continue;
                        return false;
                    }
                    continue;
                }
                if (PhiTransformPhase.isValidInput(((ValueProxyNode)target).value(), transformation, valid == ValidTransformation.WithState, (EconomicSet<ValueNode>)nodes)) continue;
                return false;
            }
            Stamp stamp = transformation.stamp(NodeView.DEFAULT).unrestricted();
            for (ValueNode target : EconomicSet.create((UnmodifiableEconomicSet)nodes)) {
                ValueNode duplicate;
                if (target.getClass() == ValuePhiNode.class) {
                    ValuePhiNode phi = (ValuePhiNode)target;
                    NodeInputList<ValueNode> phiValues = phi.values();
                    ValueNode[] values = new ValueNode[phiValues.count()];
                    for (int i = 0; i < phiValues.count(); ++i) {
                        values[i] = PhiTransformPhase.transformInputValue(graph, (ValueNode)phiValues.get(i), transformation, (EconomicSet<ValueNode>)nodes, ec);
                    }
                    ValuePhiNode duplicatePhi = graph.addWithoutUnique(new ValuePhiNode(stamp, phi.merge(), values));
                    nodes.add((Object)duplicatePhi);
                    duplicate = duplicatePhi;
                } else {
                    ValueProxyNode proxy = (ValueProxyNode)target;
                    duplicate = graph.addWithoutUnique(new ValueProxyNode(stamp, PhiTransformPhase.transformInputValue(graph, proxy.value(), transformation, (EconomicSet<ValueNode>)nodes, ec), proxy.proxyPoint()));
                }
                nodes.add((Object)duplicate);
                for (Node usage : target.usages()) {
                    if (!(usage instanceof NarrowNode) && !(usage instanceof ReinterpretNode)) continue;
                    usage.replaceAtUsagesAndDelete(duplicate);
                    break;
                }
                target.replaceAndDelete(duplicate);
            }
            return true;
        }
        if (node.getClass() == AnyExtendNode.class) {
            AnyExtendNode extend = (AnyExtendNode)node;
            if (node.hasExactlyOneUsage() && PhiTransformPhase.isValidStateUsage(node.singleUsage(), longClass)) {
                node.replaceAtUsagesAndDelete(extend.getValue());
                return true;
            }
        } else if (node.getClass() == ReinterpretNode.class && node.hasExactlyOneUsage() && PhiTransformPhase.isValidStateUsage(node.singleUsage(), longClass)) {
            node.replaceAtUsagesAndDelete(((ReinterpretNode)node).getValue());
            return true;
        }
        return false;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        GraalError.guarantee(graph.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL), "not intended to run without loop proxies");
        ResolvedJavaType longClass = context.getMetaAccess().lookupJavaType(Long.TYPE);
        EconomicSetNodeEventListener ec = new EconomicSetNodeEventListener();
        try (Graph.NodeEventScope nes = graph.trackNodeEvents(ec);){
            boolean progress = false;
            int iteration = 0;
            do {
                if (!ec.getNodes().isEmpty()) {
                    this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)ec.getNodes());
                }
                ec.getNodes().clear();
                progress = false;
                for (Node node : graph.getNodes()) {
                    progress |= PhiTransformPhase.checkTransformedNode(graph, ec, longClass, node);
                }
            } while (progress && iteration++ < 3);
        }
        this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)ec.getNodes());
    }

    private static enum ValidTransformation {
        Valid,
        Invalid,
        WithState;

    }
}

