/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerConfiguration;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotKnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotTruffleGraphBuilderPlugins;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.options.OptionValues;

public final class HotSpotPartialEvaluator
extends PartialEvaluator {
    private final AtomicReference<EconomicMap<ResolvedJavaMethod, EncodedGraph>> graphCacheRef = new AtomicReference();
    private int jvmciReservedReference0Offset = -1;
    private boolean disableEncodedGraphCachePurges = false;

    public HotSpotPartialEvaluator(TruffleCompilerConfiguration config, GraphBuilderConfiguration configForRoot, KnownTruffleTypes knownTruffleTypes) {
        super(config, configForRoot, knownTruffleTypes);
    }

    void setJvmciReservedReference0Offset(int jvmciReservedReference0Offset) {
        this.jvmciReservedReference0Offset = jvmciReservedReference0Offset;
    }

    public int getJvmciReservedReference0Offset() {
        return this.jvmciReservedReference0Offset;
    }

    @Override
    protected void initialize(OptionValues options) {
        super.initialize(options);
    }

    @Override
    protected void registerGraphBuilderInvocationPlugins(InvocationPlugins invocationPlugins, boolean canDelayIntrinsification) {
        super.registerGraphBuilderInvocationPlugins(invocationPlugins, canDelayIntrinsification);
        HotSpotTruffleGraphBuilderPlugins.registerCompilationFinalReferencePlugins(invocationPlugins, canDelayIntrinsification, (HotSpotKnownTruffleTypes)this.getKnownTruffleTypes());
    }

    @Override
    public EconomicMap<ResolvedJavaMethod, EncodedGraph> getOrCreateEncodedGraphCache() {
        EconomicMap cache;
        if (!this.persistentEncodedGraphCache) {
            return super.getOrCreateEncodedGraphCache();
        }
        while ((cache = this.graphCacheRef.get()) == null && !this.graphCacheRef.compareAndSet(null, (EconomicMap<ResolvedJavaMethod, EncodedGraph>)(cache = EconomicMap.wrapMap(new ConcurrentHashMap())))) {
        }
        assert (cache != null);
        return cache;
    }

    public void purgeEncodedGraphCache() {
        if (!this.disableEncodedGraphCachePurges) {
            this.graphCacheRef.set(null);
        }
    }

    public boolean disableEncodedGraphCachePurges(boolean value) {
        boolean oldValue = this.disableEncodedGraphCachePurges;
        this.disableEncodedGraphCachePurges = value;
        return oldValue;
    }

    public boolean persistentEncodedGraphCache(boolean value) {
        boolean oldValue = this.persistentEncodedGraphCache;
        this.persistentEncodedGraphCache = value;
        return oldValue;
    }

    @Override
    protected Supplier<AutoCloseable> getCreateCachedGraphScope() {
        if (this.persistentEncodedGraphCache) {
            return HotSpotGraalServices::enterGlobalCompilationContext;
        }
        return super.getCreateCachedGraphScope();
    }
}

