/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import com.oracle.truffle.api.TruffleOptions;
import java.net.URI;
import java.util.Set;
import java.util.function.Supplier;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.SourceLanguagePosition;
import org.graalvm.compiler.graph.SourceLanguagePositionProvider;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.phases.contract.NodeCostUtil;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.CachingPEGraphDecoder;
import org.graalvm.compiler.replacements.InlineDuringParsingPlugin;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleInliningData;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.compiler.truffle.compiler.GraphTooBigBailoutException;
import org.graalvm.compiler.truffle.compiler.ParsingInlineInvokePlugin;
import org.graalvm.compiler.truffle.compiler.PartialEvaluatorConfiguration;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerConfiguration;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.TruffleConstantFieldProvider;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;
import org.graalvm.compiler.truffle.compiler.phases.DeoptimizeOnExceptionPhase;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentPhase;
import org.graalvm.compiler.truffle.compiler.substitutions.GraphBuilderInvocationPluginProvider;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.substitutions.TruffleGraphBuilderPlugins;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.options.OptionValues;

public abstract class PartialEvaluator {
    protected final TruffleCompilerConfiguration config;
    volatile GraphBuilderConfiguration configForParsing;
    final ResolvedJavaMethod callDirectMethod;
    protected final ResolvedJavaMethod callInlined;
    final ResolvedJavaMethod callIndirectMethod;
    private final ResolvedJavaMethod profiledPERoot;
    final ResolvedJavaMethod callBoundary;
    private final GraphBuilderConfiguration configPrototype;
    private final InvocationPlugins firstTierDecodingPlugins;
    private final InvocationPlugins lastTierDecodingPlugins;
    protected final PELoopExplosionPlugin loopExplosionPlugin = new PELoopExplosionPlugin();
    private final NodePlugin[] nodePlugins;
    final KnownTruffleTypes knownTruffleTypes;
    public volatile InstrumentPhase.InstrumentationConfiguration instrumentationCfg;
    protected volatile InstrumentPhase.Instrumentation instrumentation;
    protected final TruffleConstantFieldProvider compilationLocalConstantProvider;
    protected boolean allowAssumptionsDuringParsing;
    protected boolean persistentEncodedGraphCache;
    private static final SpeculationReasonGroup TRUFFLE_BOUNDARY_EXCEPTION_SPECULATIONS = new SpeculationReasonGroup("TruffleBoundaryWithoutException", ResolvedJavaMethod.class);

    public PartialEvaluator(TruffleCompilerConfiguration config, GraphBuilderConfiguration configForRoot, KnownTruffleTypes knownFields) {
        this.config = config;
        this.knownTruffleTypes = knownFields;
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
        MetaAccessProvider metaAccess = this.config.lastTier().providers().getMetaAccess();
        ResolvedJavaType type = runtime.resolveType(metaAccess, "org.graalvm.compiler.truffle.runtime.OptimizedCallTarget");
        ResolvedJavaMethod[] methods = type.getDeclaredMethods();
        this.callDirectMethod = PartialEvaluator.findRequiredMethod(type, methods, "callDirect", "(Lcom/oracle/truffle/api/nodes/Node;[Ljava/lang/Object;)Ljava/lang/Object;");
        this.callInlined = PartialEvaluator.findRequiredMethod(type, methods, "callInlined", "(Lcom/oracle/truffle/api/nodes/Node;[Ljava/lang/Object;)Ljava/lang/Object;");
        this.callIndirectMethod = PartialEvaluator.findRequiredMethod(type, methods, "callIndirect", "(Lcom/oracle/truffle/api/nodes/Node;[Ljava/lang/Object;)Ljava/lang/Object;");
        this.profiledPERoot = PartialEvaluator.findRequiredMethod(type, methods, "profiledPERoot", "([Ljava/lang/Object;)Ljava/lang/Object;");
        this.callBoundary = PartialEvaluator.findRequiredMethod(type, methods, "callBoundary", "([Ljava/lang/Object;)Ljava/lang/Object;");
        this.configPrototype = this.createGraphBuilderConfig(configForRoot, true);
        this.firstTierDecodingPlugins = this.createDecodingInvocationPlugins(config.firstTier().partialEvaluator(), configForRoot.getPlugins(), config.firstTier().providers());
        this.lastTierDecodingPlugins = this.createDecodingInvocationPlugins(config.lastTier().partialEvaluator(), configForRoot.getPlugins(), config.lastTier().providers());
        this.nodePlugins = this.createNodePlugins(configForRoot.getPlugins());
        this.compilationLocalConstantProvider = new TruffleConstantFieldProvider(this.config.lastTier().providers().getConstantFieldProvider(), this.config.lastTier().providers().getMetaAccess(), knownFields);
    }

    protected void initialize(OptionValues options) {
        this.instrumentationCfg = new InstrumentPhase.InstrumentationConfiguration(options);
        boolean needSourcePositions = (Boolean)options.get(PolyglotCompilerOptions.NodeSourcePositions) != false || this.instrumentationCfg.instrumentBranches || this.instrumentationCfg.instrumentBoundaries || !((Set)options.get(PolyglotCompilerOptions.TracePerformanceWarnings)).isEmpty() || TruffleOptions.AOT && (Boolean)options.get(PolyglotCompilerOptions.TraceTransferToInterpreter) != false;
        this.configForParsing = this.configPrototype.withNodeSourcePosition(this.configPrototype.trackNodeSourcePosition() || needSourcePositions).withOmitAssertions((Boolean)options.get(PolyglotCompilerOptions.ExcludeAssertions));
        this.allowAssumptionsDuringParsing = (Boolean)options.get(PolyglotCompilerOptions.ParsePEGraphsWithAssumptions);
        this.persistentEncodedGraphCache = (Boolean)options.get(PolyglotCompilerOptions.EncodedGraphCache) != false && (Boolean)options.get(PolyglotCompilerOptions.ParsePEGraphsWithAssumptions) == false;
    }

    public EconomicMap<ResolvedJavaMethod, EncodedGraph> getOrCreateEncodedGraphCache() {
        return EconomicMap.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentPhase.Instrumentation getInstrumentation() {
        if (this.instrumentation == null) {
            PartialEvaluator partialEvaluator = this;
            synchronized (partialEvaluator) {
                if (this.instrumentation == null) {
                    if (this.instrumentationCfg == null) {
                        throw new IllegalStateException("PartialEvaluator is not yet initialized");
                    }
                    long[] accessTable = new long[this.instrumentationCfg.instrumentationTableSize];
                    this.instrumentation = new InstrumentPhase.Instrumentation(accessTable);
                }
            }
        }
        return this.instrumentation;
    }

    static ResolvedJavaMethod findRequiredMethod(ResolvedJavaType declaringClass, ResolvedJavaMethod[] methods, String name, String descriptor) {
        for (ResolvedJavaMethod method : methods) {
            if (!method.getName().equals(name) || !method.getSignature().toMethodDescriptor().equals(descriptor)) continue;
            return method;
        }
        throw new NoSuchMethodError(declaringClass.toJavaName() + "." + name + descriptor);
    }

    public static InlineInvokePlugin.InlineInfo asInlineInfo(ResolvedJavaMethod method) {
        TruffleCompilerRuntime.InlineKind inlineKind = TruffleCompilerRuntime.getRuntime().getInlineKind(method, true);
        switch (inlineKind) {
            case DO_NOT_INLINE_DEOPTIMIZE_ON_EXCEPTION: {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_DEOPTIMIZE_ON_EXCEPTION;
            }
            case DO_NOT_INLINE_NO_EXCEPTION: {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_NO_EXCEPTION;
            }
            case DO_NOT_INLINE_WITH_EXCEPTION: 
            case DO_NOT_INLINE_WITH_SPECULATIVE_EXCEPTION: {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            case INLINE: {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo(method);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)inlineKind));
    }

    public Providers getProviders() {
        return this.config.lastTier().providers();
    }

    public GraphBuilderConfiguration getConfigPrototype() {
        return this.configPrototype;
    }

    public GraphBuilderConfiguration getConfig() {
        if (this.configForParsing == null) {
            throw new IllegalStateException("PartialEvaluator is not yet initialized");
        }
        return this.configForParsing;
    }

    public KnownTruffleTypes getKnownTruffleTypes() {
        return this.knownTruffleTypes;
    }

    public ResolvedJavaMethod[] getCompilationRootMethods() {
        return new ResolvedJavaMethod[]{this.profiledPERoot, this.callInlined, this.callDirectMethod};
    }

    public ResolvedJavaMethod[] getNeverInlineMethods() {
        return new ResolvedJavaMethod[]{this.callDirectMethod, this.callIndirectMethod};
    }

    public ResolvedJavaMethod getCallDirect() {
        return this.callDirectMethod;
    }

    public ResolvedJavaMethod getCallInlined() {
        return this.callInlined;
    }

    protected StructuredGraph.Builder customizeStructuredGraphBuilder(StructuredGraph.Builder builder) {
        return builder;
    }

    public ResolvedJavaMethod rootForCallTarget(CompilableTruffleAST compilable) {
        return this.profiledPERoot;
    }

    public ResolvedJavaMethod inlineRootForCallTarget(CompilableTruffleAST compilable) {
        return this.callInlined;
    }

    protected PEGraphDecoder createGraphDecoder(TruffleTierContext context, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePluginList, SourceLanguagePositionProvider sourceLanguagePositionProvider, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache, Supplier<AutoCloseable> createCachedGraphScope) {
        GraphBuilderConfiguration newConfig = this.configForParsing.copy();
        InvocationPlugins parsingInvocationPlugins = newConfig.getPlugins().getInvocationPlugins();
        GraphBuilderConfiguration.Plugins plugins = newConfig.getPlugins();
        ReplacementsImpl replacements = (ReplacementsImpl)this.config.lastTier().providers().getReplacements();
        plugins.clearInlineInvokePlugins();
        plugins.appendInlineInvokePlugin(replacements);
        plugins.appendInlineInvokePlugin(new ParsingInlineInvokePlugin(this, replacements, parsingInvocationPlugins, this.loopExplosionPlugin));
        if (!((Boolean)context.options.get(PolyglotCompilerOptions.PrintExpansionHistogram)).booleanValue()) {
            plugins.appendInlineInvokePlugin(new InlineDuringParsingPlugin());
        }
        InvocationPlugins decodingPlugins = context.isFirstTier() ? this.firstTierDecodingPlugins : this.lastTierDecodingPlugins;
        DeoptimizeOnExceptionPhase postParsingPhase = new DeoptimizeOnExceptionPhase(method -> TruffleCompilerRuntime.getRuntime().getInlineKind((ResolvedJavaMethod)method, true) == TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_SPECULATIVE_EXCEPTION);
        Providers compilationUnitProviders = this.config.lastTier().providers().copyWith(this.compilationLocalConstantProvider);
        assert (!this.allowAssumptionsDuringParsing || !this.persistentEncodedGraphCache);
        return new CachingPEGraphDecoder(this.config.architecture(), context.graph, compilationUnitProviders, newConfig, TruffleCompilerImpl.Optimizations, this.loopExplosionPlugin, decodingPlugins, inlineInvokePlugins, parameterPlugin, nodePluginList, this.callInlined, sourceLanguagePositionProvider, postParsingPhase, graphCache, createCachedGraphScope, this.allowAssumptionsDuringParsing, false);
    }

    public void doGraphPE(TruffleTierContext context, InlineInvokePlugin inlineInvokePlugin, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache) {
        InlineInvokePlugin[] inlineInvokePlugins = new InlineInvokePlugin[]{inlineInvokePlugin};
        PEGraphDecoder decoder = this.createGraphDecoder(context, context.isFirstTier() ? this.firstTierDecodingPlugins : this.lastTierDecodingPlugins, inlineInvokePlugins, new InterceptReceiverPlugin(context.compilable), this.nodePlugins, new TruffleSourceLanguagePositionProvider(context.task.inliningData()), graphCache, this.getCreateCachedGraphScope());
        GraphSizeListener listener = new GraphSizeListener(context.options, context.graph);
        try (Graph.NodeEventScope ignored = context.graph.trackNodeEvents(listener);){
            assert (!context.graph.isSubstitution());
            decoder.decode(context.graph.method());
        }
        assert (listener.graphSize == NodeCostUtil.computeGraphSize(listener.graph));
    }

    protected Supplier<AutoCloseable> getCreateCachedGraphScope() {
        return () -> null;
    }

    private GraphBuilderConfiguration createGraphBuilderConfig(GraphBuilderConfiguration graphBuilderConfig, boolean canDelayIntrinsification) {
        GraphBuilderConfiguration newConfig = graphBuilderConfig.copy();
        InvocationPlugins invocationPlugins = newConfig.getPlugins().getInvocationPlugins();
        this.registerGraphBuilderInvocationPlugins(invocationPlugins, canDelayIntrinsification);
        this.appendParsingNodePlugins(newConfig.getPlugins());
        return newConfig;
    }

    protected void appendParsingNodePlugins(GraphBuilderConfiguration.Plugins plugins) {
        block3: {
            block2: {
                if (JavaVersionUtil.JAVA_SPEC < 16 || JavaVersionUtil.JAVA_SPEC >= 19) break block2;
                ResolvedJavaType memorySegmentProxyType = TruffleCompilerRuntime.getRuntime().resolveType(this.config.lastTier().providers().getMetaAccess(), "jdk.internal.access.foreign.MemorySegmentProxy");
                for (ResolvedJavaMethod m : memorySegmentProxyType.getDeclaredMethods()) {
                    if (!m.getName().equals("scope")) continue;
                    PartialEvaluator.appendMemorySegmentScopePlugin(plugins, m);
                }
                break block3;
            }
            if (JavaVersionUtil.JAVA_SPEC < 19) break block3;
            ResolvedJavaType memorySegmentType = TruffleCompilerRuntime.getRuntime().resolveType(this.config.lastTier().providers().getMetaAccess(), "jdk.internal.foreign.Scoped");
            for (ResolvedJavaMethod m : memorySegmentType.getDeclaredMethods()) {
                if (!m.getName().equals("sessionImpl")) continue;
                PartialEvaluator.appendMemorySegmentScopePlugin(plugins, m);
            }
        }
    }

    private static void appendMemorySegmentScopePlugin(GraphBuilderConfiguration.Plugins plugins, final ResolvedJavaMethod scopeMethod) {
        plugins.appendNodePlugin(new NodePlugin(){

            @Override
            public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
                if (scopeMethod.equals(method) && !b.needsExplicitException()) {
                    b.add(new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint));
                    return true;
                }
                return false;
            }
        });
    }

    protected NodePlugin[] createNodePlugins(GraphBuilderConfiguration.Plugins plugins) {
        return plugins.getNodePlugins();
    }

    protected void registerGraphBuilderInvocationPlugins(InvocationPlugins invocationPlugins, boolean canDelayIntrinsification) {
        TruffleGraphBuilderPlugins.registerInvocationPlugins(invocationPlugins, canDelayIntrinsification, this.config.lastTier().providers(), this.knownTruffleTypes);
        for (GraphBuilderInvocationPluginProvider p : GraalServices.load(GraphBuilderInvocationPluginProvider.class)) {
            p.registerInvocationPlugins(this.config.lastTier().providers(), this.config.architecture(), invocationPlugins, canDelayIntrinsification);
        }
    }

    protected InvocationPlugins createDecodingInvocationPlugins(PartialEvaluatorConfiguration peConfig, GraphBuilderConfiguration.Plugins parent, Providers tierProviders) {
        InvocationPlugins decodingInvocationPlugins = new InvocationPlugins(null, parent.getInvocationPlugins());
        this.registerGraphBuilderInvocationPlugins(decodingInvocationPlugins, false);
        peConfig.registerDecodingInvocationPlugins(decodingInvocationPlugins, false, tierProviders, this.config.architecture());
        decodingInvocationPlugins.closeRegistration();
        return decodingInvocationPlugins;
    }

    public static SpeculationLog.SpeculationReason createTruffleBoundaryExceptionSpeculation(ResolvedJavaMethod targetMethod) {
        return TRUFFLE_BOUNDARY_EXCEPTION_SPECULATIONS.createSpeculationReason(targetMethod);
    }

    private static final class SourceLanguagePositionImpl
    implements SourceLanguagePosition {
        private final TruffleSourceLanguagePosition delegate;

        SourceLanguagePositionImpl(TruffleSourceLanguagePosition delegate) {
            this.delegate = delegate;
        }

        @Override
        public String toShortString() {
            return this.delegate.getDescription();
        }

        @Override
        public int getOffsetEnd() {
            return this.delegate.getOffsetEnd();
        }

        @Override
        public int getOffsetStart() {
            return this.delegate.getOffsetStart();
        }

        @Override
        public int getLineNumber() {
            return this.delegate.getLineNumber();
        }

        @Override
        public URI getURI() {
            return this.delegate.getURI();
        }

        @Override
        public String getLanguage() {
            return this.delegate.getLanguage();
        }

        @Override
        public int getNodeId() {
            return this.delegate.getNodeId();
        }

        @Override
        public String getNodeClassName() {
            return this.delegate.getNodeClassName();
        }
    }

    private static final class PELoopExplosionPlugin
    implements LoopExplosionPlugin {
        private PELoopExplosionPlugin() {
        }

        @Override
        public LoopExplosionPlugin.LoopExplosionKind loopExplosionKind(ResolvedJavaMethod method) {
            TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
            TruffleCompilerRuntime.LoopExplosionKind explosionKind = rt.getLoopExplosionKind(method);
            switch (explosionKind) {
                case NONE: {
                    return LoopExplosionPlugin.LoopExplosionKind.NONE;
                }
                case FULL_EXPLODE: {
                    return LoopExplosionPlugin.LoopExplosionKind.FULL_EXPLODE;
                }
                case FULL_EXPLODE_UNTIL_RETURN: {
                    return LoopExplosionPlugin.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN;
                }
                case FULL_UNROLL: {
                    return LoopExplosionPlugin.LoopExplosionKind.FULL_UNROLL;
                }
                case MERGE_EXPLODE: {
                    return LoopExplosionPlugin.LoopExplosionKind.MERGE_EXPLODE;
                }
                case FULL_UNROLL_UNTIL_RETURN: {
                    return LoopExplosionPlugin.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN;
                }
            }
            throw new IllegalStateException("Unsupported TruffleCompilerRuntime.LoopExplosionKind: " + String.valueOf((Object)explosionKind));
        }
    }

    private static final class TruffleSourceLanguagePositionProvider
    implements SourceLanguagePositionProvider {
        private TruffleInliningData inliningPlan;

        private TruffleSourceLanguagePositionProvider(TruffleInliningData inliningPlan) {
            this.inliningPlan = inliningPlan;
        }

        @Override
        public SourceLanguagePosition getPosition(JavaConstant node) {
            TruffleSourceLanguagePosition position = this.inliningPlan.getPosition(node);
            return position == null ? null : new SourceLanguagePositionImpl(position);
        }
    }

    private class InterceptReceiverPlugin
    implements ParameterPlugin {
        private final CompilableTruffleAST compilable;

        InterceptReceiverPlugin(CompilableTruffleAST compilable) {
            this.compilable = compilable;
        }

        @Override
        public FloatingNode interceptParameter(GraphBuilderTool b, int index, StampPair stamp) {
            if (index == 0) {
                JavaConstant c = this.compilable.asJavaConstant();
                return ConstantNode.forConstant(c, PartialEvaluator.this.config.lastTier().providers().getMetaAccess());
            }
            return null;
        }
    }

    private static final class GraphSizeListener
    extends Graph.NodeEventListener {
        private final int graphSizeLimit;
        private final StructuredGraph graph;
        private int graphSize;

        private GraphSizeListener(OptionValues options, StructuredGraph graph) {
            this.graphSizeLimit = (Integer)options.get(PolyglotCompilerOptions.MaximumGraalGraphSize);
            this.graph = graph;
            this.graphSize = NodeCostUtil.computeGraphSize(graph);
        }

        @Override
        public void nodeAdded(Node node) {
            this.increaseSizeAndCheckLimit(node);
        }

        private void increaseSizeAndCheckLimit(Node node) {
            this.graphSize += node.estimatedNodeSize().value;
            this.checkLimit();
        }

        private void checkLimit() {
            if (this.graphSize > this.graphSizeLimit) {
                throw new GraphTooBigBailoutException("Graph too big to safely compile. Node count: " + this.graph.getNodeCount() + ". Graph Size: " + this.graphSize + ". Limit: " + this.graphSizeLimit + ".");
            }
        }

        @Override
        public void beforeDecodingFields(Node node) {
            this.graphSize -= node.estimatedNodeSize().value;
        }

        @Override
        public void afterDecodingFields(Node node) {
            this.increaseSizeAndCheckLimit(node);
        }

        @Override
        public void nodeRemoved(Node node) {
            this.graphSize -= node.estimatedNodeSize().value;
        }
    }
}

