/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.nodes.MacroNode;

@NodeInfo
public abstract class ReflectionGetCallerClassNode
extends MacroNode
implements Canonicalizable,
Lowerable {
    public static final NodeClass<ReflectionGetCallerClassNode> TYPE = NodeClass.create(ReflectionGetCallerClassNode.class);

    protected ReflectionGetCallerClassNode(NodeClass<? extends ReflectionGetCallerClassNode> c, MacroNode.MacroParams p) {
        super(c, p);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ConstantNode callerClassNode = this.getCallerClassNode(tool.getMetaAccess(), tool.getConstantReflection());
        if (callerClassNode != null) {
            return callerClassNode;
        }
        return this;
    }

    @Override
    public void lower(LoweringTool tool) {
        ConstantNode callerClassNode = this.getCallerClassNode(tool.getMetaAccess(), tool.getConstantReflection());
        if (callerClassNode != null) {
            this.graph().replaceFixedWithFloating(this, this.graph().addOrUniqueWithInputs(callerClassNode));
        } else {
            super.lower(tool);
        }
    }

    private ConstantNode getCallerClassNode(MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        FrameState state = this.stateAfter();
        int n = 1;
        while (state != null) {
            ResolvedJavaMethod method = state.getMethod();
            switch (n) {
                case 0: {
                    throw GraalError.shouldNotReachHere("current frame state does not include the Reflection.getCallerClass frame");
                }
                case 1: {
                    if (this.isCallerSensitive(method)) break;
                    return null;
                }
                default: {
                    if (this.ignoredBySecurityStackWalk(metaAccess, method)) break;
                    ResolvedJavaType callerClass = method.getDeclaringClass();
                    return ConstantNode.forConstant(constantReflection.asJavaClass(callerClass), metaAccess);
                }
            }
            state = state.outerFrameState();
            ++n;
        }
        return null;
    }

    protected abstract boolean isCallerSensitive(ResolvedJavaMethod var1);

    protected abstract boolean ignoredBySecurityStackWalk(MetaAccessProvider var1, ResolvedJavaMethod var2);
}

