/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.CryptoForeignCalls;
import org.graalvm.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_128, size=NodeSize.SIZE_128)
public class GHASHProcessBlocksNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<GHASHProcessBlocksNode> TYPE = NodeClass.create(GHASHProcessBlocksNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Long)};
    @Node.Input
    protected ValueNode state;
    @Node.Input
    protected ValueNode hashSubkey;
    @Node.Input
    protected ValueNode data;
    @Node.Input
    protected ValueNode blocks;

    public GHASHProcessBlocksNode(ValueNode state, ValueNode hashSubkey, ValueNode data, ValueNode blocks) {
        this(state, hashSubkey, data, blocks, null);
    }

    public GHASHProcessBlocksNode(ValueNode state, ValueNode hashSubkey, ValueNode data, ValueNode blocks, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.forVoid(), runtimeCheckedCPUFeatures, LocationIdentity.any());
        this.state = state;
        this.hashSubkey = hashSubkey;
        this.data = data;
        this.blocks = blocks;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.state, this.hashSubkey, this.data, this.blocks};
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    public static EnumSet<?> minFeaturesAMD64() {
        return EnumSet.of(AMD64.CPUFeature.SSSE3, AMD64.CPUFeature.CLMUL);
    }

    public static EnumSet<?> minFeaturesAARCH64() {
        return EnumSet.of(AArch64.CPUFeature.PMULL);
    }

    @Node.NodeIntrinsic
    @GenerateStub(name="ghashProcessBlocks", minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")
    public static native void apply(Pointer var0, Pointer var1, Pointer var2, int var3);

    @Node.NodeIntrinsic
    public static native void apply(Pointer var0, Pointer var1, Pointer var2, int var3, @Node.ConstantNodeParameter EnumSet<?> var4);

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return CryptoForeignCalls.STUB_GHASH_PROCESS_BLOCKS;
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.getLIRGeneratorTool().emitGHASHProcessBlocks(gen.operand(this.state), gen.operand(this.hashSubkey), gen.operand(this.data), gen.operand(this.blocks));
    }
}

