/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptBciSupplier;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_64)
public abstract class BasicArrayCopyNode
extends WithExceptionNode
implements DeoptBciSupplier,
StateSplit,
Virtualizable,
SingleMemoryKill,
MemoryAccess,
Lowerable,
DeoptimizingNode.DeoptDuring {
    public static final NodeClass<BasicArrayCopyNode> TYPE = NodeClass.create(BasicArrayCopyNode.class);
    @Node.Input
    ValueNode src;
    @Node.Input
    ValueNode srcPos;
    @Node.Input
    ValueNode dest;
    @Node.Input
    ValueNode destPos;
    @Node.Input
    ValueNode length;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateDuring;
    @Node.OptionalInput(value=InputType.Memory)
    protected MemoryKill lastLocationAccess;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;
    protected JavaKind elementKind;
    protected int bci;

    public BasicArrayCopyNode(NodeClass<? extends BasicArrayCopyNode> type, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind elementKind, int bci) {
        super((NodeClass<? extends WithExceptionNode>)type, StampFactory.forKind(JavaKind.Void));
        this.bci = bci;
        this.src = src;
        this.srcPos = srcPos;
        this.dest = dest;
        this.destPos = destPos;
        this.length = length;
        this.elementKind = elementKind != JavaKind.Illegal ? elementKind : null;
    }

    public BasicArrayCopyNode(NodeClass<? extends BasicArrayCopyNode> type, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind elementKind) {
        this(type, src, srcPos, dest, destPos, length, elementKind, -6);
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public void setBci(int bci) {
        this.bci = bci;
    }

    public JavaKind getElementKind() {
        return this.elementKind;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        if (this.elementKind != null) {
            return NamedLocationIdentity.getArrayLocation(this.elementKind);
        }
        return LocationIdentity.any();
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.getLocationIdentity();
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsagesInterface(this.lastLocationAccess, lla);
        this.lastLocationAccess = lla;
    }

    @Override
    public FrameState stateDuring() {
        return this.stateDuring;
    }

    @Override
    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages(this.stateDuring, stateDuring);
        this.stateDuring = stateDuring;
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    public static JavaKind selectComponentKind(BasicArrayCopyNode arraycopy) {
        if (arraycopy.getSource() == null || arraycopy.getDestination() == null) {
            return null;
        }
        ResolvedJavaType srcType = StampTool.typeOrNull(arraycopy.getSource().stamp(NodeView.DEFAULT));
        ResolvedJavaType destType = StampTool.typeOrNull(arraycopy.getDestination().stamp(NodeView.DEFAULT));
        if (srcType == null || !srcType.isArray() || destType == null || !destType.isArray()) {
            return null;
        }
        if (!destType.getComponentType().isAssignableFrom(srcType.getComponentType())) {
            return null;
        }
        if (!arraycopy.isExact()) {
            return null;
        }
        return srcType.getComponentType().getJavaKind();
    }

    public ValueNode getSource() {
        return this.src;
    }

    public ValueNode getSourcePosition() {
        return this.srcPos;
    }

    public ValueNode getDestination() {
        return this.dest;
    }

    public ValueNode getDestinationPosition() {
        return this.destPos;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public void setSource(ValueNode value) {
        this.updateUsages(this.src, value);
        this.src = value;
    }

    public void setSourcePosition(ValueNode value) {
        this.updateUsages(this.srcPos, value);
        this.srcPos = value;
    }

    public static boolean checkBounds(int position, int length, VirtualObjectNode virtualObject) {
        assert (length >= 0);
        return position >= 0 && position <= virtualObject.entryCount() - length;
    }

    public static boolean checkEntryTypes(int srcPos, int length, VirtualObjectNode src, ResolvedJavaType destComponentType, VirtualizerTool tool) {
        if (destComponentType.getJavaKind() == JavaKind.Object && !destComponentType.isJavaLangObject()) {
            for (int i = 0; i < length; ++i) {
                ValueNode entry = tool.getEntry(src, srcPos + i);
                ResolvedJavaType type = StampTool.typeOrNull(entry);
                if (type != null && destComponentType.isAssignableFrom(type)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isExact() {
        ResolvedJavaType srcType = StampTool.typeOrNull(this.getSource().stamp(NodeView.DEFAULT));
        ResolvedJavaType destType = StampTool.typeOrNull(this.getDestination().stamp(NodeView.DEFAULT));
        if (srcType == null || !srcType.isArray() || destType == null || !destType.isArray()) {
            return false;
        }
        if (srcType.getComponentType().getJavaKind().isPrimitive() && destType.getComponentType().equals(srcType.getComponentType()) || this.getSource() == this.getDestination()) {
            return true;
        }
        return StampTool.isExactType(this.getDestination().stamp(NodeView.DEFAULT)) && destType != null && destType.isAssignableFrom(srcType);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode sourcePosition = tool.getAlias(this.getSourcePosition());
        ValueNode destinationPosition = tool.getAlias(this.getDestinationPosition());
        ValueNode replacedLength = tool.getAlias(this.getLength());
        if (sourcePosition.isConstant() && destinationPosition.isConstant() && replacedLength.isConstant()) {
            int srcPosInt = sourcePosition.asJavaConstant().asInt();
            int destPosInt = destinationPosition.asJavaConstant().asInt();
            int len = replacedLength.asJavaConstant().asInt();
            ValueNode destAlias = tool.getAlias(this.getDestination());
            if (destAlias instanceof VirtualArrayNode) {
                VirtualArrayNode destVirtual = (VirtualArrayNode)destAlias;
                if (len < 0 || !BasicArrayCopyNode.checkBounds(destPosInt, len, destVirtual)) {
                    return;
                }
                ValueNode srcAlias = tool.getAlias(this.getSource());
                if (srcAlias instanceof VirtualObjectNode) {
                    int i;
                    if (!(srcAlias instanceof VirtualArrayNode)) {
                        return;
                    }
                    VirtualArrayNode srcVirtual = (VirtualArrayNode)srcAlias;
                    if (destVirtual.componentType().getJavaKind() != srcVirtual.componentType().getJavaKind()) {
                        return;
                    }
                    if (!BasicArrayCopyNode.checkBounds(srcPosInt, len, srcVirtual)) {
                        return;
                    }
                    if (!BasicArrayCopyNode.checkEntryTypes(srcPosInt, len, srcVirtual, destVirtual.type().getComponentType(), tool)) {
                        return;
                    }
                    if (srcVirtual == destVirtual && srcPosInt < destPosInt) {
                        for (i = len - 1; i >= 0; --i) {
                            tool.setVirtualEntry(destVirtual, destPosInt + i, tool.getEntry(srcVirtual, srcPosInt + i));
                        }
                    } else {
                        for (i = 0; i < len; ++i) {
                            tool.setVirtualEntry(destVirtual, destPosInt + i, tool.getEntry(srcVirtual, srcPosInt + i));
                        }
                    }
                    tool.delete();
                    DebugContext debug = this.asNode().getDebug();
                    if (debug.isLogEnabled()) {
                        debug.log("virtualized arraycopy(%s, %d, %s, %d, %d)", this.getSource(), (Object)srcPosInt, (Object)this.getDestination(), (Object)destPosInt, (Object)len);
                    }
                } else {
                    ResolvedJavaType destComponentType;
                    ResolvedJavaType sourceType = StampTool.typeOrNull(srcAlias);
                    if (sourceType == null || !sourceType.isArray()) {
                        return;
                    }
                    ResolvedJavaType sourceComponentType = sourceType.getComponentType();
                    if (!sourceComponentType.equals(destComponentType = destVirtual.type().getComponentType())) {
                        return;
                    }
                    for (int i = 0; i < len; ++i) {
                        LoadIndexedNode load = new LoadIndexedNode(this.asNode().graph().getAssumptions(), srcAlias, ConstantNode.forInt(i + srcPosInt, this.asNode().graph()), null, destComponentType.getJavaKind());
                        load.setNodeSourcePosition(this.asNode().getNodeSourcePosition());
                        tool.addNode(load);
                        tool.setVirtualEntry(destVirtual, destPosInt + i, load);
                    }
                    tool.delete();
                }
            }
        }
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public void computeStateDuring(FrameState currentStateAfter) {
        FrameState newStateDuring = currentStateAfter.duplicateModifiedDuringCall(this.bci(), this.asNode().getStackKind());
        this.setStateDuring(newStateDuring);
    }
}

