/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.GenerateStubs;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToForeignCalls;
import org.graalvm.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_1024, size=NodeSize.SIZE_16)
public class ArrayCompareToNode
extends PureFunctionStubIntrinsicNode
implements Canonicalizable,
Virtualizable {
    public static final NodeClass<ArrayCompareToNode> TYPE = NodeClass.create(ArrayCompareToNode.class);
    protected final Stride strideA;
    protected final Stride strideB;
    @Node.Input
    protected ValueNode arrayA;
    @Node.Input
    protected ValueNode lengthA;
    @Node.Input
    protected ValueNode arrayB;
    @Node.Input
    protected ValueNode lengthB;

    public ArrayCompareToNode(ValueNode arrayA, ValueNode lengthA, ValueNode arrayB, ValueNode lengthB, @Node.ConstantNodeParameter Stride strideA, @Node.ConstantNodeParameter Stride strideB) {
        this(TYPE, arrayA, lengthA, arrayB, lengthB, strideA, strideB);
    }

    public ArrayCompareToNode(ValueNode arrayA, ValueNode lengthA, ValueNode arrayB, ValueNode lengthB, @Node.ConstantNodeParameter Stride strideA, @Node.ConstantNodeParameter Stride strideB, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(TYPE, arrayA, lengthA, arrayB, lengthB, strideA, strideB, runtimeCheckedCPUFeatures);
    }

    protected ArrayCompareToNode(NodeClass<? extends ArrayCompareToNode> c, ValueNode arrayA, ValueNode lengthA, ValueNode arrayB, ValueNode lengthB, @Node.ConstantNodeParameter Stride strideA, @Node.ConstantNodeParameter Stride strideB) {
        this(c, arrayA, lengthA, arrayB, lengthB, strideA, strideB, null);
    }

    protected ArrayCompareToNode(NodeClass<? extends ArrayCompareToNode> c, ValueNode arrayA, ValueNode lengthA, ValueNode arrayB, ValueNode lengthB, @Node.ConstantNodeParameter Stride strideA, @Node.ConstantNodeParameter Stride strideB, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        super(c, StampFactory.forKind(JavaKind.Int), runtimeCheckedCPUFeatures, NamedLocationIdentity.getArrayLocation(JavaKind.Byte));
        this.strideA = strideA;
        this.strideB = strideB;
        this.arrayA = arrayA;
        this.lengthA = lengthA;
        this.arrayB = arrayB;
        this.lengthB = lengthB;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode a2;
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        ValueNode a1 = GraphUtil.unproxify(this.arrayA);
        if (a1 == (a2 = GraphUtil.unproxify(this.arrayB))) {
            return ConstantNode.forInt(0);
        }
        return this;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias2;
        ValueNode alias1 = tool.getAlias(this.arrayA);
        if (alias1 == (alias2 = tool.getAlias(this.arrayB))) {
            tool.replaceWithValue(ConstantNode.forInt(0, this.graph()));
        }
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="byteArrayCompareToByteArray", parameters={"S1", "S1"}), @GenerateStub(name="byteArrayCompareToCharArray", parameters={"S1", "S2"}), @GenerateStub(name="charArrayCompareToByteArray", parameters={"S2", "S1"}), @GenerateStub(name="charArrayCompareToCharArray", parameters={"S2", "S2"})})
    public static native int compareTo(Pointer var0, int var1, Pointer var2, int var3, @Node.ConstantNodeParameter Stride var4, @Node.ConstantNodeParameter Stride var5);

    @Node.NodeIntrinsic
    public static native int compareTo(Pointer var0, int var1, Pointer var2, int var3, @Node.ConstantNodeParameter Stride var4, @Node.ConstantNodeParameter Stride var5, @Node.ConstantNodeParameter EnumSet<?> var6);

    public Stride getStrideA() {
        return this.strideA;
    }

    public Stride getStrideB() {
        return this.strideB;
    }

    public ValueNode getArrayA() {
        return this.arrayA;
    }

    public ValueNode getLengthA() {
        return this.lengthA;
    }

    public ValueNode getArrayB() {
        return this.arrayB;
    }

    public ValueNode getLengthB() {
        return this.lengthB;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return ArrayCompareToForeignCalls.getStub(this);
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.arrayA, this.lengthA, this.arrayB, this.lengthB};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitArrayCompareTo(this.strideA, this.strideB, this.getRuntimeCheckedCPUFeatures(), gen.operand(this.arrayA), gen.operand(this.lengthA), gen.operand(this.arrayB), gen.operand(this.lengthB)));
    }
}

