/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import java.util.Objects;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.UnaryOpLogicNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.type.StampTool;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
@Node.NodeIntrinsicFactory
public class InstanceOfNode
extends UnaryOpLogicNode
implements Lowerable {
    public static final NodeClass<InstanceOfNode> TYPE = NodeClass.create(InstanceOfNode.class);
    private final ObjectStamp checkedStamp;
    private JavaTypeProfile profile;
    @Node.OptionalInput(value=InputType.Anchor)
    protected AnchoringNode anchor;

    private InstanceOfNode(ObjectStamp checkedStamp, ValueNode object, JavaTypeProfile profile, AnchoringNode anchor) {
        this(TYPE, checkedStamp, object, profile, anchor);
    }

    protected InstanceOfNode(NodeClass<? extends InstanceOfNode> c, ObjectStamp checkedStamp, ValueNode object, JavaTypeProfile profile, AnchoringNode anchor) {
        super(c, object);
        this.checkedStamp = checkedStamp;
        this.profile = profile;
        this.anchor = anchor;
        assert (profile == null || anchor != null) : "profiles must be anchored";
        assert (checkedStamp != null);
        assert (this.type() != null);
    }

    public static LogicNode createAllowNull(TypeReference type, ValueNode object, JavaTypeProfile profile, AnchoringNode anchor) {
        if (StampTool.isPointerNonNull(object)) {
            return InstanceOfNode.create(type, object, profile, anchor);
        }
        return InstanceOfNode.createHelper(StampFactory.object(type), object, profile, anchor);
    }

    public static LogicNode create(TypeReference type, ValueNode object) {
        return InstanceOfNode.create(type, object, null, null);
    }

    public static LogicNode create(TypeReference type, ValueNode object, JavaTypeProfile profile, AnchoringNode anchor) {
        return InstanceOfNode.createHelper(StampFactory.objectNonNull(type), object, profile, anchor);
    }

    public static LogicNode createHelper(ObjectStamp checkedStamp, ValueNode object, JavaTypeProfile profile, AnchoringNode anchor) {
        LogicNode synonym = InstanceOfNode.findSynonym(checkedStamp, object, NodeView.DEFAULT);
        if (synonym != null) {
            return synonym;
        }
        return new InstanceOfNode(checkedStamp, object, profile, anchor);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ObjectStamp improvedStamp;
        TypeReference checkedType;
        NodeView view = NodeView.from(tool);
        LogicNode synonym = InstanceOfNode.findSynonym(this.checkedStamp, forValue, view);
        if (synonym != null) {
            return synonym;
        }
        if (!this.checkedStamp.isExactType() && (checkedType = TypeReference.createTrusted(tool.getAssumptions(), this.checkedStamp.type())) != null && checkedType.isExact() && (improvedStamp = (ObjectStamp)this.checkedStamp.tryImproveWith(StampFactory.object(checkedType))) != null) {
            return InstanceOfNode.createHelper(improvedStamp, forValue, this.profile, this.anchor);
        }
        return this;
    }

    public static LogicNode findSynonym(ObjectStamp checkedStamp, ValueNode object, NodeView view) {
        ObjectStamp inputStamp = (ObjectStamp)object.stamp(view);
        ObjectStamp joinedStamp = (ObjectStamp)checkedStamp.join(inputStamp);
        if (joinedStamp.isEmpty()) {
            return LogicConstantNode.contradiction();
        }
        ObjectStamp meetStamp = (ObjectStamp)checkedStamp.meet(inputStamp);
        if (checkedStamp.equals(meetStamp)) {
            return LogicConstantNode.tautology();
        }
        if (checkedStamp.alwaysNull()) {
            return IsNullNode.create(object);
        }
        if (Objects.equals(checkedStamp.type(), meetStamp.type()) && checkedStamp.isExactType() == meetStamp.isExactType() && checkedStamp.alwaysNull() == meetStamp.alwaysNull()) {
            assert (checkedStamp.nonNull() != inputStamp.nonNull());
            if (checkedStamp.nonNull()) {
                return LogicNegationNode.create(IsNullNode.create(object));
            }
            return IsNullNode.create(object);
        }
        assert (checkedStamp.type() != null);
        return null;
    }

    public TypeReference type() {
        return StampTool.typeReferenceOrNull(this.checkedStamp);
    }

    public JavaTypeProfile profile() {
        return this.profile;
    }

    @Override
    public Stamp getSucceedingStampForValue(boolean negated) {
        if (negated) {
            return null;
        }
        return this.checkedStamp;
    }

    @Override
    public TriState tryFold(Stamp valueStamp) {
        if (valueStamp instanceof ObjectStamp) {
            ObjectStamp inputStamp = (ObjectStamp)valueStamp;
            ObjectStamp joinedStamp = (ObjectStamp)this.checkedStamp.join(inputStamp);
            if (joinedStamp.isEmpty()) {
                return TriState.FALSE;
            }
            ObjectStamp meetStamp = (ObjectStamp)this.checkedStamp.meet(inputStamp);
            if (this.checkedStamp.equals(meetStamp)) {
                return TriState.TRUE;
            }
        }
        return TriState.UNKNOWN;
    }

    public boolean allowsNull() {
        return !this.checkedStamp.nonNull();
    }

    public void setProfile(JavaTypeProfile typeProfile, AnchoringNode anchor) {
        this.profile = typeProfile;
        this.updateUsagesInterface(this.anchor, anchor);
        this.anchor = anchor;
        assert (this.profile == null || anchor != null) : "profiles must be anchored";
    }

    public AnchoringNode getAnchor() {
        return this.anchor;
    }

    public ObjectStamp getCheckedStamp() {
        return this.checkedStamp;
    }

    @Node.NodeIntrinsic
    public static native boolean doInstanceof(@Node.ConstantNodeParameter ResolvedJavaType var0, Object var1);

    public static boolean intrinsify(GraphBuilderContext b, ResolvedJavaType type, ValueNode object) {
        InstanceOfNode node = new InstanceOfNode(StampFactory.objectNonNull(TypeReference.create(b.getAssumptions(), type)), object, null, null);
        node = b.add(node);
        b.addPush(JavaKind.Int, ConditionalNode.create(node, NodeView.DEFAULT));
        return true;
    }

    @Override
    public TriState implies(boolean thisNegated, LogicNode other) {
        InstanceOfNode instanceOfNode;
        if (other instanceof InstanceOfNode && (instanceOfNode = (InstanceOfNode)other).getValue() == this.getValue()) {
            if (thisNegated) {
                if (this.getCheckedStamp().meet(instanceOfNode.getCheckedStamp()).equals(this.getCheckedStamp())) {
                    return TriState.get((boolean)false);
                }
            } else if (instanceOfNode.getCheckedStamp().meet(this.getCheckedStamp()).equals(instanceOfNode.getCheckedStamp())) {
                return TriState.get((boolean)true);
            }
        }
        return super.implies(thisNegated, other);
    }
}

