/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.NodeWithIdentity;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(allowedUsageTypes={InputType.Anchor, InputType.Guard}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class ValueAnchorNode
extends FixedWithNextNode
implements LIRLowerable,
Simplifiable,
Virtualizable,
AnchoringNode,
GuardingNode,
NodeWithIdentity {
    public static final NodeClass<ValueAnchorNode> TYPE = NodeClass.create(ValueAnchorNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    ValueNode anchored;

    public ValueAnchorNode(ValueNode value) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.anchored = value;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
    }

    public ValueNode getAnchoredNode() {
        return this.anchored;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        FixedAccessNode currentNext;
        while (this.next() instanceof ValueAnchorNode) {
            ValueAnchorNode nextAnchor = (ValueAnchorNode)this.next();
            if (nextAnchor.anchored != this.anchored && nextAnchor.anchored != null) break;
            nextAnchor.replaceAtUsages(this);
            GraphUtil.removeFixedWithUnusedInputs(nextAnchor);
            tool.addToWorkList(this.usages());
        }
        if (tool.allUsagesAvailable() && this.hasNoUsages() && this.next() instanceof FixedAccessNode && (currentNext = (FixedAccessNode)this.next()).getGuard() == this.anchored) {
            GraphUtil.removeFixedWithUnusedInputs(this);
            return;
        }
        if (this.anchored != null && (this.anchored.isConstant() || this.anchored instanceof FixedNode)) {
            this.removeAnchoredNode();
        }
        if (this.anchored == null && this.hasNoUsages()) {
            GraphUtil.removeFixedWithUnusedInputs(this);
        }
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        if (this.anchored == null || this.anchored instanceof AbstractBeginNode) {
            tool.delete();
        } else {
            ValueNode alias = tool.getAlias(this.anchored);
            if (alias instanceof VirtualObjectNode) {
                tool.delete();
            }
        }
    }

    public void removeAnchoredNode() {
        this.updateUsages(this.anchored, null);
        this.anchored = null;
    }
}

