/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.OrderedMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="JavaRead#{p#location/s}", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class JavaReadNode
extends FixedAccessNode
implements Lowerable,
GuardingNode,
Canonicalizable,
OrderedMemoryAccess,
SingleMemoryKill {
    public static final NodeClass<JavaReadNode> TYPE = NodeClass.create(JavaReadNode.class);
    protected final JavaKind readKind;
    protected final boolean compressible;
    private final MemoryOrderMode memoryOrder;

    public JavaReadNode(JavaKind readKind, AddressNode address, LocationIdentity location, OnHeapMemoryAccess.BarrierType barrierType, MemoryOrderMode memoryOrder, boolean compressible) {
        this(StampFactory.forKind(readKind), readKind, address, location, barrierType, memoryOrder, compressible);
    }

    public JavaReadNode(Stamp stamp, JavaKind readKind, AddressNode address, LocationIdentity location, OnHeapMemoryAccess.BarrierType barrierType, MemoryOrderMode memoryOrder, boolean compressible) {
        this(TYPE, stamp, readKind, address, location, barrierType, memoryOrder, compressible);
    }

    protected JavaReadNode(NodeClass<? extends JavaReadNode> c, Stamp stamp, JavaKind readKind, AddressNode address, LocationIdentity location, OnHeapMemoryAccess.BarrierType barrierType, MemoryOrderMode memoryOrder, boolean compressible) {
        super(c, address, location, stamp, barrierType);
        this.readKind = readKind;
        this.compressible = compressible;
        this.memoryOrder = memoryOrder;
    }

    @Override
    public boolean canNullCheck() {
        return true;
    }

    public JavaKind getReadKind() {
        return this.readKind;
    }

    public boolean isCompressible() {
        return this.compressible;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.getAddress() instanceof OffsetAddressNode) {
            OffsetAddressNode objAddress = (OffsetAddressNode)this.getAddress();
            return ReadNode.canonicalizeRead(this, tool, this.readKind, objAddress.getBase(), objAddress.getOffset(), this.getLocationIdentity());
        }
        return this;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        if (this.ordersMemoryAccesses()) {
            return LocationIdentity.any();
        }
        return MemoryKill.NO_LOCATION;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }
}

