/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.cfg;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;

public class ReversePostOrder {
    private static void enqueueBlockInRPO(Block b, Block[] reversePostOrder, int nextIndex) {
        reversePostOrder[nextIndex] = b;
        b.setId(nextIndex);
    }

    private static void compute(ControlFlowGraph cfg, FixedNode start, Block[] rpoBlocks, int startIndex) {
        assert (startIndex < rpoBlocks.length);
        LinkedList<FixedNode> toProcess = new LinkedList<FixedNode>();
        toProcess.push(start);
        NodeBitMap visitedNodes = cfg.graph.createNodeBitMap();
        int currentIndex = startIndex;
        class OpenLoopsData {
            int endsVisited;
            final LoopBeginNode lb;
            final boolean loopHasNoExits;
            final /* synthetic */ NodeBitMap val$visitedNodes;

            OpenLoopsData(LoopBeginNode loopBeginNode) {
                this.val$visitedNodes = loopBeginNode;
                this.lb = lb;
                this.loopHasNoExits = lb.loopExits().count() == 0;
            }

            boolean loopFullyProcessed() {
                return this.allEndsVisited() && this.allLexPredecessorsVisited();
            }

            boolean allEndsVisited() {
                return this.lb.getLoopEndCount() == this.endsVisited;
            }

            boolean allLexPredecessorsVisited() {
                for (LoopExitNode lex : this.lb.loopExits()) {
                    FixedNode pred = (FixedNode)lex.predecessor();
                    if (this.val$visitedNodes.isMarked(pred)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return this.lb + "-> ends visited=" + this.endsVisited;
            }
        }
        ArrayDeque<OpenLoopsData> openLoops = new ArrayDeque<OpenLoopsData>();
        block0: while (true) {
            int i;
            OpenLoopsData olPeek;
            FixedNode cur = null;
            if (!openLoops.isEmpty() && (olPeek = (OpenLoopsData)openLoops.peek()).loopFullyProcessed()) {
                cur = olPeek.lb.loopExits().first();
            }
            if (cur == null && !toProcess.isEmpty()) {
                cur = (FixedNode)toProcess.pop();
            }
            if (cur == null) break;
            if (cur instanceof LoopBeginNode) {
                openLoops.push(new OpenLoopsData((LoopBeginNode)cur, visitedNodes));
            }
            if (cur instanceof LoopExitNode) {
                LoopExitNode lex = (LoopExitNode)cur;
                OpenLoopsData ol = (OpenLoopsData)openLoops.peek();
                GraalError.guarantee(ol.lb == lex.loopBegin(), "Different loop on stack, should be %s is %s", (Object)lex.loopBegin(), (Object)ol.lb);
                GraalError.guarantee(ol != null, "No open loop for loop exit %s with loop begin %s", (Object)lex, (Object)lex.loopBegin());
                if (!ol.loopFullyProcessed()) {
                    GraalError.guarantee(toProcess.size() > 0, "If a loop is not fully processed there need to be further blocks, %s", (Object)lex);
                    continue;
                }
                openLoops.pop();
                List<LoopExitNode> loopExits = ol.lb.loopExits().snapshot();
                i = loopExits.size() - 1;
                while (true) {
                    if (i < 0) continue block0;
                    LoopExitNode singleExit = loopExits.get(i);
                    ReversePostOrder.enqueueBlockInRPO(cfg.blockFor(singleExit), rpoBlocks, currentIndex++);
                    visitedNodes.mark(singleExit);
                    ReversePostOrder.pushOrStall(singleExit.next(), toProcess);
                    --i;
                }
            }
            Block curBlock = cfg.blockFor(cur);
            if (cur == curBlock.getBeginNode()) {
                ReversePostOrder.enqueueBlockInRPO(curBlock, rpoBlocks, currentIndex++);
            }
            while (true) {
                visitedNodes.mark(cur);
                if (cur == curBlock.getEndNode()) {
                    if (cur instanceof EndNode) {
                        EndNode endNode = (EndNode)cur;
                        if (!ReversePostOrder.allEndsVisited(visitedNodes, endNode)) continue block0;
                        ReversePostOrder.pushOrStall(endNode.merge(), toProcess);
                        continue block0;
                    }
                    if (cur instanceof LoopEndNode) {
                        LoopEndNode len = (LoopEndNode)cur;
                        OpenLoopsData ol = (OpenLoopsData)openLoops.peek();
                        GraalError.guarantee(ol.lb == len.loopBegin(), "Loop begin does not match, loop end begin %s stack loop begin %s", (Object)len.loopBegin(), (Object)ol.lb);
                        ++ol.endsVisited;
                        if (!ol.loopHasNoExits || !ol.loopFullyProcessed()) continue block0;
                        openLoops.pop();
                        continue block0;
                    }
                    if (cur instanceof ControlSplitNode) {
                        ControlSplitNode split = (ControlSplitNode)cur;
                        List<Node> successors = split.successors().snapshot();
                        i = successors.size() - 1;
                        while (true) {
                            if (i < 0) continue block0;
                            FixedNode successor = (FixedNode)successors.get(i);
                            ReversePostOrder.pushOrStall(successor, toProcess);
                            --i;
                        }
                    }
                    if (cur instanceof FixedWithNextNode) {
                        ReversePostOrder.pushOrStall(((FixedWithNextNode)cur).next(), toProcess);
                        continue block0;
                    }
                    GraalError.guarantee(cur instanceof ControlSinkNode, "Node %s must be a control flow sink", (Object)cur);
                    continue block0;
                }
                cur = ((FixedWithNextNode)cur).next();
            }
            break;
        }
    }

    private static void pushOrStall(FixedNode n, LinkedList<FixedNode> toProcess) {
        if (!(n instanceof LoopExitNode)) {
            toProcess.push(n);
        }
    }

    private static boolean allEndsVisited(NodeBitMap stalledEnds, AbstractEndNode current) {
        for (AbstractEndNode abstractEndNode : current.merge().forwardEnds()) {
            if (abstractEndNode == current || stalledEnds.isMarked(abstractEndNode)) continue;
            return false;
        }
        return true;
    }

    public static Block[] identifyBlocks(ControlFlowGraph cfg, int numBlocks) {
        Block startBlock = cfg.blockFor(cfg.graph.start());
        startBlock.setPredecessors(Block.EMPTY_ARRAY);
        Block[] reversePostOrder = new Block[numBlocks];
        ReversePostOrder.compute(cfg, cfg.graph.start(), reversePostOrder, 0);
        ReversePostOrder.assignPredecessorsAndSuccessors(reversePostOrder, cfg);
        return reversePostOrder;
    }

    private static void computeLoopPredecessors(NodeMap<Block> nodeMap, Block block, LoopBeginNode loopBeginNode) {
        int i;
        int forwardEndCount = loopBeginNode.forwardEndCount();
        LoopEndNode[] loopEnds = loopBeginNode.orderedLoopEnds();
        AbstractBlockBase[] predecessors = new Block[forwardEndCount + loopEnds.length];
        for (i = 0; i < forwardEndCount; ++i) {
            predecessors[i] = nodeMap.get(loopBeginNode.forwardEndAt(i));
        }
        for (i = 0; i < loopEnds.length; ++i) {
            predecessors[i + forwardEndCount] = nodeMap.get(loopEnds[i]);
        }
        block.setPredecessors(predecessors);
    }

    private static void assignPredecessorsAndSuccessors(Block[] blocks, ControlFlowGraph cfg) {
        for (int bI = 0; bI < blocks.length; ++bI) {
            Block b = blocks[bI];
            FixedNode blockEndNode = b.getEndNode();
            if (blockEndNode instanceof EndNode) {
                EndNode endNode = (EndNode)blockEndNode;
                Block suxBlock = cfg.getNodeToBlock().get(endNode.merge());
                b.setSuccessors(new Block[]{suxBlock});
            } else if (blockEndNode instanceof ControlSplitNode) {
                ArrayList<Block> succ = new ArrayList<Block>();
                Block[] ifPred = new Block[]{b};
                for (Node node : blockEndNode.successors()) {
                    Block sucBlock = cfg.getNodeToBlock().get(node);
                    succ.add(sucBlock);
                    sucBlock.setPredecessors(ifPred);
                }
                b.setSuccessors(succ.toArray(new Block[succ.size()]), ((ControlSplitNode)blockEndNode).successorProbabilities());
            } else if (blockEndNode instanceof LoopEndNode) {
                LoopEndNode loopEndNode = (LoopEndNode)blockEndNode;
                b.setSuccessors(new Block[]{cfg.getNodeToBlock().get(loopEndNode.loopBegin())});
            } else if (blockEndNode instanceof ControlSinkNode) {
                b.setSuccessors(Block.EMPTY_ARRAY);
            } else {
                assert (!(blockEndNode instanceof AbstractEndNode)) : "Algorithm only supports EndNode and LoopEndNode.";
                AbstractBlockBase[] ifPred = new Block[]{b};
                for (Node suxNode : blockEndNode.successors()) {
                    Block block = cfg.getNodeToBlock().get(suxNode);
                    block.setPredecessors(ifPred);
                }
                assert (blockEndNode.successors().count() == 1) : "Node " + blockEndNode;
                Block sequentialSuc = cfg.getNodeToBlock().get(blockEndNode.successors().first());
                b.setSuccessors(new Block[]{sequentialSuc});
            }
            AbstractBeginNode blockBeginNode = b.getBeginNode();
            if (blockBeginNode instanceof LoopBeginNode) {
                ReversePostOrder.computeLoopPredecessors(cfg.getNodeToBlock(), b, (LoopBeginNode)blockBeginNode);
                continue;
            }
            if (!(blockBeginNode instanceof AbstractMergeNode)) continue;
            AbstractMergeNode mergeNode = (AbstractMergeNode)blockBeginNode;
            int forwardEndCount = mergeNode.forwardEndCount();
            AbstractBlockBase[] abstractBlockBaseArray = new Block[forwardEndCount];
            for (int i = 0; i < forwardEndCount; ++i) {
                abstractBlockBaseArray[i] = cfg.getNodeToBlock().get(mergeNode.forwardEndAt(i));
            }
            b.setPredecessors(abstractBlockBaseArray);
        }
    }
}

