/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo
public abstract class IntegerLowerThanNode
extends CompareNode {
    public static final NodeClass<IntegerLowerThanNode> TYPE = NodeClass.create(IntegerLowerThanNode.class);
    private final LowerOp op;

    protected IntegerLowerThanNode(NodeClass<? extends CompareNode> c, ValueNode x, ValueNode y, LowerOp op) {
        super(c, op.getCondition(), false, x, y);
        this.op = op;
    }

    protected LowerOp getOp() {
        return this.op;
    }

    @Override
    public Stamp getSucceedingStampForX(boolean negated, Stamp xStampGeneric, Stamp yStampGeneric) {
        return this.getSucceedingStampForX(negated, !negated, xStampGeneric, yStampGeneric, this.getX(), this.getY());
    }

    @Override
    public Stamp getSucceedingStampForY(boolean negated, Stamp xStampGeneric, Stamp yStampGeneric) {
        return this.getSucceedingStampForX(!negated, !negated, yStampGeneric, xStampGeneric, this.getY(), this.getX());
    }

    private Stamp getSucceedingStampForX(boolean mirror, boolean strict, Stamp xStampGeneric, Stamp yStampGeneric, ValueNode forX, ValueNode forY) {
        Stamp s = this.getSucceedingStampForX(mirror, strict, xStampGeneric, yStampGeneric);
        if (s != null && s.isUnrestricted()) {
            s = null;
        }
        if (forY instanceof AddNode && xStampGeneric instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
            AddNode addNode = (AddNode)forY;
            IntegerStamp aStamp = null;
            if (addNode.getX() == forX && addNode.getY().stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                aStamp = (IntegerStamp)addNode.getY().stamp(NodeView.DEFAULT);
            } else if (addNode.getY() == forX && addNode.getX().stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                aStamp = (IntegerStamp)addNode.getX().stamp(NodeView.DEFAULT);
            }
            if (aStamp != null) {
                IntegerStamp result = this.getOp().getSucceedingStampForXLowerXPlusA(mirror, strict, aStamp, xStamp);
                if ((result = (IntegerStamp)xStamp.tryImproveWith(result)) != null) {
                    s = s != null ? s.improveWith(result) : result;
                }
            }
        }
        return s;
    }

    private Stamp getSucceedingStampForX(boolean mirror, boolean strict, Stamp xStampGeneric, Stamp yStampGeneric) {
        if (xStampGeneric instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
            if (yStampGeneric instanceof IntegerStamp) {
                IntegerStamp yStamp = (IntegerStamp)yStampGeneric;
                assert (yStamp.getBits() == xStamp.getBits());
                IntegerStamp s = this.getOp().getSucceedingStampForX(xStamp, yStamp, mirror, strict);
                if (s != null) {
                    return s;
                }
            }
        }
        return null;
    }

    @Override
    public TriState tryFold(Stamp xStampGeneric, Stamp yStampGeneric) {
        return this.getOp().tryFold(xStampGeneric, yStampGeneric);
    }

    @Override
    public TriState implies(boolean thisNegated, LogicNode other) {
        if (other instanceof IntegerLowerThanNode) {
            IntegerLowerThanNode otherLowerThan = (IntegerLowerThanNode)other;
            if (this.getOp() == otherLowerThan.getOp() && this.getX() == otherLowerThan.getX()) {
                LogicNode compareYs = this.getOp().create(this.getY(), otherLowerThan.getY(), NodeView.DEFAULT);
                if (!thisNegated && compareYs.isTautology()) {
                    return TriState.TRUE;
                }
                if (thisNegated && compareYs.isContradiction()) {
                    return TriState.FALSE;
                }
            }
        }
        return super.implies(thisNegated, other);
    }

    public static abstract class LowerOp
    extends CompareNode.CompareOp {
        @Override
        public LogicNode canonical(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, boolean unorderedIsTrue, ValueNode forX, ValueNode forY, NodeView view) {
            LogicNode result = super.canonical(constantReflection, metaAccess, options, smallestCompareWidth, condition, unorderedIsTrue, forX, forY, view);
            if (result != null) {
                return result;
            }
            LogicNode synonym = this.findSynonym(forX, forY, view);
            if (synonym != null) {
                return synonym;
            }
            return null;
        }

        protected abstract long upperBound(IntegerStamp var1);

        protected abstract long lowerBound(IntegerStamp var1);

        protected abstract int compare(long var1, long var3);

        protected abstract long min(long var1, long var3);

        protected abstract long max(long var1, long var3);

        protected long min(long a, long b, int bits) {
            return this.min(this.cast(a, bits), this.cast(b, bits));
        }

        protected long max(long a, long b, int bits) {
            return this.max(this.cast(a, bits), this.cast(b, bits));
        }

        protected abstract long cast(long var1, int var3);

        protected abstract long minValue(int var1);

        protected abstract long maxValue(int var1);

        protected abstract IntegerStamp forInteger(int var1, long var2, long var4);

        protected abstract CanonicalCondition getCondition();

        protected abstract IntegerLowerThanNode createNode(ValueNode var1, ValueNode var2);

        public LogicNode create(ValueNode x, ValueNode y, NodeView view) {
            LogicNode result = CompareNode.tryConstantFoldPrimitive(this.getCondition(), x, y, false, view);
            if (result != null) {
                return result;
            }
            result = this.findSynonym(x, y, view);
            if (result != null) {
                return result;
            }
            return this.createNode(x, y);
        }

        public LogicConstantNode constantOrNull(ValueNode x, ValueNode y, NodeView view) {
            LogicNode result = CompareNode.tryConstantFoldPrimitive(this.getCondition(), x, y, false, view);
            if (result instanceof LogicConstantNode) {
                return (LogicConstantNode)result;
            }
            result = this.findSynonym(x, y, view);
            if (result instanceof LogicConstantNode) {
                return (LogicConstantNode)result;
            }
            return null;
        }

        protected LogicNode findSynonym(ValueNode forX, ValueNode forY, NodeView view) {
            if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY)) {
                return LogicConstantNode.contradiction();
            }
            Stamp xStampGeneric = forX.stamp(view);
            TriState fold = this.tryFold(xStampGeneric, forY.stamp(view));
            if (fold.isTrue()) {
                return LogicConstantNode.tautology();
            }
            if (fold.isFalse()) {
                return LogicConstantNode.contradiction();
            }
            if (forY.stamp(view) instanceof IntegerStamp) {
                AddNode addNode;
                LogicNode canonical;
                long xValue;
                IntegerStamp yStamp = (IntegerStamp)forY.stamp(view);
                IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
                int bits = yStamp.getBits();
                if (forX.isJavaConstant() && !forY.isConstant() && (xValue = forX.asJavaConstant().asLong()) != this.maxValue(bits)) {
                    return LogicNegationNode.create(this.create(forY, ConstantNode.forIntegerStamp(yStamp, xValue + 1L), view));
                }
                if (forY.isJavaConstant()) {
                    long yValue = forY.asJavaConstant().asLong();
                    if (yValue == this.maxValue(bits)) {
                        return LogicNegationNode.create(IntegerEqualsNode.create(forX, forY, view));
                    }
                    if (yValue == this.minValue(bits) + 1L) {
                        return IntegerEqualsNode.create(forX, ConstantNode.forIntegerStamp(yStamp, this.minValue(bits)), view);
                    }
                    if (yValue != this.minValue(bits) && xStamp.lowerBound() == yValue - 1L && (yValue > 0L || this.getCondition() == CanonicalCondition.LT)) {
                        return IntegerEqualsNode.create(forX, ConstantNode.forIntegerStamp(yStamp, yValue - 1L), view);
                    }
                } else if (forY instanceof AddNode && (canonical = this.canonicalizeXLowerXPlusA(forX, addNode = (AddNode)forY, false, true, view)) != null) {
                    return canonical;
                }
                if (forX instanceof AddNode && (canonical = this.canonicalizeXLowerXPlusA(forY, addNode = (AddNode)forX, true, false, view)) != null) {
                    return canonical;
                }
                if (forX instanceof PiNode && forY instanceof PiNode) {
                    PiNode piX = (PiNode)forX;
                    PiNode piY = (PiNode)forY;
                    ValueNode originalX = piX.getOriginalNode();
                    ValueNode originalY = piY.getOriginalNode();
                    if (originalY instanceof AddNode && ((AddNode)originalY).getY().isConstant() && ((AddNode)originalY).getX() == originalX) {
                        return this.canonicalizePiXLowerPiXPlusC(piX, piY, false, view);
                    }
                    if (originalX instanceof AddNode && ((AddNode)originalX).getY().isConstant() && ((AddNode)originalX).getX() == originalY) {
                        return this.canonicalizePiXLowerPiXPlusC(piY, piX, true, view);
                    }
                }
                return this.canonicalizeCommonArithmetic(forX, forY, view);
            }
            return null;
        }

        private LogicConstantNode canonicalizePiXLowerPiXPlusC(PiNode piValue, PiNode piWithAdd, boolean mirror, NodeView view) {
            AddNode originalWithAdd = (AddNode)piWithAdd.getOriginalNode();
            ValueNode constant = originalWithAdd.getY();
            Stamp piWithAddStamp = piWithAdd.stamp(view);
            Stamp subValueStamp = ArithmeticOpTable.forStamp(piWithAddStamp).getSub().foldStamp(piWithAddStamp, constant.stamp(view));
            ValueNode newValue = PiNode.create(piValue, subValueStamp, piWithAdd.getGuard().asNode());
            ValueNode newWithAdd = AddNode.create(newValue, constant, view);
            if (mirror) {
                return this.constantOrNull(newWithAdd, newValue, view);
            }
            return this.constantOrNull(newValue, newWithAdd, view);
        }

        protected LogicNode canonicalizeCommonArithmetic(ValueNode forX, ValueNode forY, NodeView view) {
            IntegerStamp stamp2;
            IntegerStamp stamp1;
            if (this.isMatchingBitExtendNode(forX) && this.isMatchingBitExtendNode(forY)) {
                IntegerConvertNode forX1 = (IntegerConvertNode)forX;
                IntegerConvertNode forY1 = (IntegerConvertNode)forY;
                if (forX1.getInputBits() >= 32 && forX1.getResultBits() == forY1.getResultBits() && forX1.getInputBits() == forY1.getInputBits()) {
                    return this.create(forX1.getValue(), forY1.getValue(), view);
                }
            }
            if (forX instanceof AddNode && forY instanceof AddNode) {
                AddNode addX = (AddNode)forX;
                AddNode addY = (AddNode)forY;
                ValueNode v1 = null;
                ValueNode v2 = null;
                ValueNode common = null;
                if (addX.getX() == addY.getX()) {
                    v1 = addX.getY();
                    v2 = addY.getY();
                    common = addX.getX();
                } else if (addX.getX() == addY.getY()) {
                    v1 = addX.getY();
                    v2 = addY.getX();
                    common = addX.getX();
                } else if (addX.getY() == addY.getX()) {
                    v1 = addX.getX();
                    v2 = addY.getY();
                    common = addX.getY();
                } else if (addX.getY() == addY.getY()) {
                    v1 = addX.getX();
                    v2 = addY.getX();
                    common = addX.getY();
                }
                if (v1 != null) {
                    assert (v2 != null);
                    stamp1 = (IntegerStamp)v1.stamp(view);
                    stamp2 = (IntegerStamp)v2.stamp(view);
                    IntegerStamp stampCommon = (IntegerStamp)common.stamp(view);
                    if (!this.addCanOverflow(stamp1, stampCommon) && !this.addCanOverflow(stamp2, stampCommon)) {
                        return this.create(v1, v2, view);
                    }
                }
            }
            if (forX instanceof LeftShiftNode && forY instanceof LeftShiftNode) {
                PrimitiveConstant constant;
                LeftShiftNode leftShiftX = (LeftShiftNode)forX;
                LeftShiftNode leftShiftY = (LeftShiftNode)forY;
                if (leftShiftX.getY() == leftShiftY.getY() && leftShiftX.getY().isConstant() && leftShiftX.getY().asConstant() instanceof PrimitiveConstant && (constant = (PrimitiveConstant)leftShiftX.getY().asConstant()).getJavaKind().isNumericInteger()) {
                    ValueNode v1 = leftShiftX.getX();
                    ValueNode v2 = leftShiftY.getX();
                    stamp1 = (IntegerStamp)v1.stamp(view);
                    stamp2 = (IntegerStamp)v2.stamp(view);
                    if (!this.leftShiftCanOverflow(stamp1, constant.asLong()) && !this.leftShiftCanOverflow(stamp2, constant.asLong())) {
                        return this.create(v1, v2, view);
                    }
                }
            }
            return null;
        }

        protected abstract boolean isMatchingBitExtendNode(ValueNode var1);

        protected abstract boolean addCanOverflow(IntegerStamp var1, IntegerStamp var2);

        protected abstract boolean leftShiftCanOverflow(IntegerStamp var1, long var2);

        protected static LogicNode canonicalizeRangeFlip(ValueNode forX, ValueNode forY, int bits, boolean signed, NodeView view) {
            long min = CodeUtil.minValue((int)bits);
            long xResidue = 0L;
            ValueNode left = null;
            JavaConstant leftCst = null;
            if (forX instanceof AddNode) {
                AddNode xAdd = (AddNode)forX;
                if (xAdd.getY().isJavaConstant() && !xAdd.getY().asJavaConstant().isDefaultForKind()) {
                    long xCst = xAdd.getY().asJavaConstant().asLong();
                    xResidue = xCst - min;
                    left = xAdd.getX();
                }
            } else if (forX.isJavaConstant()) {
                leftCst = forX.asJavaConstant();
            }
            if (left == null && leftCst == null) {
                return null;
            }
            long yResidue = 0L;
            ValueNode right = null;
            JavaConstant rightCst = null;
            if (forY instanceof AddNode) {
                AddNode yAdd = (AddNode)forY;
                if (yAdd.getY().isJavaConstant() && !yAdd.getY().asJavaConstant().isDefaultForKind()) {
                    long yCst = yAdd.getY().asJavaConstant().asLong();
                    yResidue = yCst - min;
                    right = yAdd.getX();
                }
            } else if (forY.isJavaConstant()) {
                rightCst = forY.asJavaConstant();
            }
            if (right == null && rightCst == null) {
                return null;
            }
            if (xResidue == 0L && left != null || yResidue == 0L && right != null) {
                if (left == null) {
                    assert (leftCst != null);
                    left = ConstantNode.forIntegerBits(bits, leftCst.asLong() - min);
                } else if (xResidue != 0L) {
                    left = AddNode.create(left, ConstantNode.forIntegerBits(bits, xResidue), view);
                }
                if (right == null) {
                    assert (rightCst != null);
                    right = ConstantNode.forIntegerBits(bits, rightCst.asLong() - min);
                } else if (yResidue != 0L) {
                    right = AddNode.create(right, ConstantNode.forIntegerBits(bits, yResidue), view);
                }
                if (signed) {
                    return new IntegerBelowNode(left, right);
                }
                return new IntegerLessThanNode(left, right);
            }
            return null;
        }

        private LogicNode canonicalizeXLowerXPlusA(ValueNode forX, AddNode addNode, boolean mirrored, boolean strict, NodeView view) {
            boolean exact;
            IntegerStamp succeedingXStamp;
            IntegerStamp aStamp;
            IntegerStamp xStamp = (IntegerStamp)forX.stamp(view);
            if (addNode.getX() == forX && addNode.getY().stamp(view) instanceof IntegerStamp) {
                aStamp = (IntegerStamp)addNode.getY().stamp(view);
                succeedingXStamp = this.getSucceedingStampForXLowerXPlusA(mirrored, strict, aStamp, xStamp);
                exact = aStamp.lowerBound() == aStamp.upperBound();
            } else if (addNode.getY() == forX && addNode.getX().stamp(view) instanceof IntegerStamp) {
                aStamp = (IntegerStamp)addNode.getX().stamp(view);
                succeedingXStamp = this.getSucceedingStampForXLowerXPlusA(mirrored, strict, aStamp, xStamp);
                exact = aStamp.lowerBound() == aStamp.upperBound();
            } else {
                return null;
            }
            if (succeedingXStamp.join(forX.stamp(view)).isEmpty()) {
                return LogicConstantNode.contradiction();
            }
            if (exact && !succeedingXStamp.isEmpty()) {
                int bits = succeedingXStamp.getBits();
                if (this.compare(this.lowerBound(succeedingXStamp), this.minValue(bits)) > 0) {
                    return LogicNegationNode.create(this.create(forX, ConstantNode.forIntegerStamp(succeedingXStamp, this.lowerBound(succeedingXStamp)), view));
                }
                if (this.compare(this.upperBound(succeedingXStamp), this.maxValue(bits)) < 0) {
                    return LogicNegationNode.create(this.create(ConstantNode.forIntegerStamp(succeedingXStamp, this.upperBound(succeedingXStamp)), forX, view));
                }
            }
            return null;
        }

        protected TriState tryFold(Stamp xStampGeneric, Stamp yStampGeneric) {
            if (xStampGeneric instanceof IntegerStamp && yStampGeneric instanceof IntegerStamp) {
                IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
                IntegerStamp yStamp = (IntegerStamp)yStampGeneric;
                if (this.compare(this.upperBound(xStamp), this.lowerBound(yStamp)) < 0) {
                    return TriState.TRUE;
                }
                if (this.compare(this.lowerBound(xStamp), this.upperBound(yStamp)) >= 0) {
                    return TriState.FALSE;
                }
            }
            return TriState.UNKNOWN;
        }

        protected IntegerStamp getSucceedingStampForX(IntegerStamp xStamp, IntegerStamp yStamp, boolean mirror, boolean strict) {
            int bits = xStamp.getBits();
            assert (yStamp.getBits() == bits);
            if (mirror) {
                long low = this.lowerBound(yStamp);
                if (strict) {
                    if (low == this.maxValue(bits)) {
                        return null;
                    }
                    ++low;
                }
                if (this.compare(low, this.lowerBound(xStamp)) > 0 || this.upperBound(xStamp) != (xStamp.upperBound() & CodeUtil.mask((int)xStamp.getBits()))) {
                    return this.forInteger(bits, low, this.upperBound(xStamp));
                }
            } else {
                long low = this.upperBound(yStamp);
                if (strict) {
                    if (low == this.minValue(bits)) {
                        return null;
                    }
                    --low;
                }
                if (this.compare(low, this.upperBound(xStamp)) < 0 || this.lowerBound(xStamp) != (xStamp.lowerBound() & CodeUtil.mask((int)xStamp.getBits()))) {
                    return this.forInteger(bits, this.lowerBound(xStamp), low);
                }
            }
            return null;
        }

        protected IntegerStamp getSucceedingStampForXLowerXPlusA(boolean mirrored, boolean strict, IntegerStamp aStamp, IntegerStamp xStamp) {
            int bits = aStamp.getBits();
            long min = this.minValue(bits);
            long max = this.maxValue(bits);
            if (mirrored) {
                if (aStamp.contains(0L)) {
                    return aStamp.unrestricted();
                }
                return this.forInteger(bits, this.min(max - aStamp.lowerBound() + 1L, max - aStamp.upperBound() + 1L, bits), this.min(max, this.upperBound(xStamp)));
            }
            long aLower = aStamp.lowerBound();
            long aUpper = aStamp.upperBound();
            if (strict) {
                if (aLower == 0L) {
                    aLower = 1L;
                }
                if (aUpper == 0L) {
                    aUpper = -1L;
                }
                if (aLower > aUpper) {
                    return aStamp.empty();
                }
            }
            if (aLower < 0L && aUpper > 0L) {
                return aStamp.unrestricted();
            }
            return this.forInteger(bits, min, this.max(max - aLower, max - aUpper, bits));
        }
    }
}

