/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64.vector;

import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.vector.AVX512Support;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64VectorBlend {

    public static class EvexBlendOp
    extends AbstractBlendOp
    implements AVX512Support {
        public static final LIRInstructionClass<EvexBlendOp> TYPE = LIRInstructionClass.create(EvexBlendOp.class);
        @Opcode
        private final AMD64Assembler.VexRVMOp opcode;

        public EvexBlendOp(AMD64Assembler.VexRVMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, AllocatableValue y, AllocatableValue mask) {
            super(TYPE, size, result, x, y, mask);
            this.opcode = opcode;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.y)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), ValueUtil.asRegister((Value)this.mask));
            } else {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress((Value)this.y), ValueUtil.asRegister((Value)this.mask));
            }
        }

        @Override
        public AllocatableValue getOpmask() {
            return this.mask;
        }
    }

    public static class VexBlendOp
    extends AbstractBlendOp {
        public static final LIRInstructionClass<VexBlendOp> TYPE = LIRInstructionClass.create(VexBlendOp.class);
        @Opcode
        private final AMD64Assembler.VexRVMROp opcode;

        public VexBlendOp(AMD64Assembler.VexRVMROp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, AllocatableValue y, AllocatableValue mask) {
            super(TYPE, size, result, x, y, mask);
            this.opcode = opcode;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.y)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.mask), ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
            } else {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.mask), ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress((Value)this.y));
            }
        }
    }

    private static abstract class AbstractBlendOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<AbstractBlendOp> TYPE = LIRInstructionClass.create(AbstractBlendOp.class);
        protected final AVXKind.AVXSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue y;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue mask;

        AbstractBlendOp(LIRInstructionClass<? extends AbstractBlendOp> c, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, AllocatableValue y, AllocatableValue mask) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
            this.size = size;
            this.result = result;
            this.x = x;
            this.y = y;
            this.mask = mask;
        }
    }
}

