/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.amd64.AMD64ComplexVectorOp;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="AMD64_ENCODE_ARRAY")
@StubPort(path="src/hotspot/cpu/x86/macroAssembler_x86.cpp", lineStart=5890, lineEnd=6048, commit="77e21c57ce00463db4cc3d87f93729cbfe2c96b4", sha1="28e9e817bee0afd9e5b698c5bff3ed519e09e410")
public final class AMD64EncodeArrayOp
extends AMD64ComplexVectorOp {
    public static final LIRInstructionClass<AMD64EncodeArrayOp> TYPE = LIRInstructionClass.create(AMD64EncodeArrayOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value originSrcValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value originDstValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
    private Value originLengthValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value srcValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value dstValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value lenValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vectorTempValue1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vectorTempValue2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vectorTempValue3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vectorTempValue4;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value tempValue5;
    private final LIRGeneratorTool.CharsetName charset;

    public AMD64EncodeArrayOp(LIRGeneratorTool tool, Value result, Value src, Value dst, Value length, LIRGeneratorTool.CharsetName charset) {
        super(TYPE, tool, null, AVXKind.AVXSize.YMM);
        this.resultValue = result;
        this.originSrcValue = src;
        this.originDstValue = dst;
        this.originLengthValue = length;
        this.srcValue = tool.newVariable(src.getValueKind());
        this.dstValue = tool.newVariable(dst.getValueKind());
        this.lenValue = tool.newVariable(length.getValueKind());
        LIRKind lirKind = LIRKind.value((PlatformKind)this.getVectorKind(JavaKind.Byte));
        this.vectorTempValue1 = tool.newVariable(lirKind);
        this.vectorTempValue2 = tool.newVariable(lirKind);
        this.vectorTempValue3 = tool.newVariable(lirKind);
        this.vectorTempValue4 = tool.newVariable(lirKind);
        this.tempValue5 = tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.charset = charset;
        assert (charset == LIRGeneratorTool.CharsetName.ASCII || charset == LIRGeneratorTool.CharsetName.ISO_8859_1);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Label labelDone = new Label();
        Label labelCopy1Char = new Label();
        Label labelCopy1CharExit = new Label();
        AMD64Move.move(crb, masm, this.srcValue, this.originSrcValue);
        AMD64Move.move(crb, masm, this.dstValue, this.originDstValue);
        AMD64Move.move(crb, masm, this.lenValue, this.originLengthValue);
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register len = ValueUtil.asRegister((Value)this.lenValue);
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register vectorTemp1 = ValueUtil.asRegister((Value)this.vectorTempValue1);
        Register vectorTemp2 = ValueUtil.asRegister((Value)this.vectorTempValue2);
        Register vectorTemp3 = ValueUtil.asRegister((Value)this.vectorTempValue3);
        Register vectorTemp4 = ValueUtil.asRegister((Value)this.vectorTempValue4);
        Register temp5 = ValueUtil.asRegister((Value)this.tempValue5);
        boolean ascii = this.charset == LIRGeneratorTool.CharsetName.ASCII;
        int mask = ascii ? -8323200 : -16711936;
        int shortMask = ascii ? 65408 : 65280;
        masm.xorl(result, result);
        masm.testlAndJcc(len, len, AMD64Assembler.ConditionFlag.Zero, labelDone, false);
        masm.movl(result, len);
        masm.leaq(src, new AMD64Address(src, len, Stride.S2));
        masm.leaq(dst, new AMD64Address(dst, len, Stride.S1));
        masm.negq(len);
        if (this.supportsAVX2AndYMM() || masm.supports(AMD64.CPUFeature.SSE4_2)) {
            Label labelCopy8Chars = new Label();
            Label labelCopy8CharsExit = new Label();
            Label labelChars16Check = new Label();
            Label labelCopy16Chars = new Label();
            Label labelCopy16CharsExit = new Label();
            if (this.supportsAVX2AndYMM()) {
                Label labelChars32Check = new Label();
                Label labelCopy32Chars = new Label();
                Label labelCopy32CharsExit = new Label();
                masm.movl(temp5, mask);
                masm.movdl(vectorTemp1, temp5);
                masm.emit(AMD64Assembler.VexRMOp.VPBROADCASTD, vectorTemp1, vectorTemp1, AVXKind.AVXSize.YMM);
                masm.jmp(labelChars32Check);
                masm.bind(labelCopy32Chars);
                masm.vmovdqu(vectorTemp3, new AMD64Address(src, len, Stride.S2, -64));
                masm.vmovdqu(vectorTemp4, new AMD64Address(src, len, Stride.S2, -32));
                masm.emit(AMD64Assembler.VexRVMOp.VPOR, vectorTemp2, vectorTemp3, vectorTemp4, AVXKind.AVXSize.YMM);
                masm.vptest(vectorTemp2, vectorTemp1, AVXKind.AVXSize.YMM);
                masm.jcc(AMD64Assembler.ConditionFlag.NotZero, labelCopy32CharsExit, true);
                masm.emit(AMD64Assembler.VexRVMOp.VPACKUSWB, vectorTemp3, vectorTemp3, vectorTemp4, AVXKind.AVXSize.YMM);
                masm.emit(AMD64Assembler.VexRMIOp.VPERMQ, vectorTemp4, vectorTemp3, 216, AVXKind.AVXSize.YMM);
                masm.vmovdqu(new AMD64Address(dst, len, Stride.S1, -32), vectorTemp4);
                masm.bind(labelChars32Check);
                masm.addqAndJcc(len, 32, AMD64Assembler.ConditionFlag.LessEqual, labelCopy32Chars, false);
                masm.bind(labelCopy32CharsExit);
                masm.subqAndJcc(len, 16, AMD64Assembler.ConditionFlag.Greater, labelCopy16CharsExit, true);
            } else {
                masm.movl(temp5, mask);
                masm.movdl(vectorTemp1, temp5);
                masm.pshufd(vectorTemp1, vectorTemp1, 0);
                masm.jmpb(labelChars16Check);
            }
            masm.bind(labelCopy16Chars);
            if (this.supportsAVX2AndYMM()) {
                masm.vmovdqu(vectorTemp2, new AMD64Address(src, len, Stride.S2, -32));
                masm.vptest(vectorTemp2, vectorTemp1, AVXKind.AVXSize.YMM);
                masm.jcc(AMD64Assembler.ConditionFlag.NotZero, labelCopy16CharsExit);
                masm.emit(AMD64Assembler.VexRVMOp.VPACKUSWB, vectorTemp2, vectorTemp2, vectorTemp1, AVXKind.AVXSize.YMM);
                masm.emit(AMD64Assembler.VexRMIOp.VPERMQ, vectorTemp3, vectorTemp2, 216, AVXKind.AVXSize.YMM);
            } else {
                if (masm.supports(AMD64.CPUFeature.AVX)) {
                    masm.movdqu(vectorTemp3, new AMD64Address(src, len, Stride.S2, -32));
                    masm.movdqu(vectorTemp4, new AMD64Address(src, len, Stride.S2, -16));
                    masm.emit(AMD64Assembler.VexRVMOp.VPOR, vectorTemp2, vectorTemp3, vectorTemp4, AVXKind.AVXSize.XMM);
                } else {
                    masm.movdqu(vectorTemp3, new AMD64Address(src, len, Stride.S2, -32));
                    masm.por(vectorTemp2, vectorTemp3);
                    masm.movdqu(vectorTemp4, new AMD64Address(src, len, Stride.S2, -16));
                    masm.por(vectorTemp2, vectorTemp4);
                }
                masm.ptest(vectorTemp2, vectorTemp1);
                masm.jccb(AMD64Assembler.ConditionFlag.NotZero, labelCopy16CharsExit);
                masm.packuswb(vectorTemp3, vectorTemp4);
            }
            masm.movdqu(new AMD64Address(dst, len, Stride.S1, -16), vectorTemp3);
            masm.bind(labelChars16Check);
            masm.addqAndJcc(len, 16, AMD64Assembler.ConditionFlag.LessEqual, labelCopy16Chars, false);
            masm.bind(labelCopy16CharsExit);
            masm.subqAndJcc(len, 8, AMD64Assembler.ConditionFlag.Greater, labelCopy8CharsExit, true);
            masm.bind(labelCopy8Chars);
            masm.movdqu(vectorTemp3, new AMD64Address(src, len, Stride.S2, -16));
            masm.ptest(vectorTemp3, vectorTemp1);
            masm.jccb(AMD64Assembler.ConditionFlag.NotZero, labelCopy8CharsExit);
            masm.packuswb(vectorTemp3, vectorTemp1);
            masm.movq(new AMD64Address(dst, len, Stride.S1, -8), vectorTemp3);
            masm.addqAndJcc(len, 8, AMD64Assembler.ConditionFlag.LessEqual, labelCopy8Chars, true);
            masm.bind(labelCopy8CharsExit);
            masm.subqAndJcc(len, 8, AMD64Assembler.ConditionFlag.Zero, labelDone, true);
        }
        masm.bind(labelCopy1Char);
        masm.movzwl(temp5, new AMD64Address(src, len, Stride.S2, 0));
        masm.testlAndJcc(temp5, shortMask, AMD64Assembler.ConditionFlag.NotZero, labelCopy1CharExit, true);
        masm.movb(new AMD64Address(dst, len, Stride.S1, 0), temp5);
        masm.addqAndJcc(len, 1, AMD64Assembler.ConditionFlag.Less, labelCopy1Char, true);
        masm.bind(labelCopy1CharExit);
        masm.addq(result, len);
        masm.bind(labelDone);
    }
}

