/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.type;

import java.util.Objects;
import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotMemoryAccessProvider;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.hotspot.nodes.type.MetaspacePointerStamp;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;

public final class KlassPointerStamp
extends MetaspacePointerStamp {
    private static final KlassPointerStamp KLASS = new KlassPointerStamp(false, false);
    private static final KlassPointerStamp KLASS_NON_NULL = new KlassPointerStamp(true, false);
    private static final KlassPointerStamp KLASS_ALWAYS_NULL = new KlassPointerStamp(false, true);
    private final CompressEncoding encoding;

    public static KlassPointerStamp klass() {
        return KLASS;
    }

    public static KlassPointerStamp klassNonNull() {
        return KLASS_NON_NULL;
    }

    public static KlassPointerStamp klassAlwaysNull() {
        return KLASS_ALWAYS_NULL;
    }

    private KlassPointerStamp(boolean nonNull, boolean alwaysNull) {
        this(nonNull, alwaysNull, null);
    }

    private KlassPointerStamp(boolean nonNull, boolean alwaysNull, CompressEncoding encoding) {
        super(nonNull, alwaysNull);
        this.encoding = encoding;
    }

    @Override
    public void accept(SpeculationReasonGroup.SpeculationContextObject.Visitor v) {
        super.accept(v);
        v.visitLong(this.encoding.getBase());
        v.visitInt(this.encoding.getShift());
    }

    @Override
    protected AbstractPointerStamp copyWith(boolean newNonNull, boolean newAlwaysNull) {
        return new KlassPointerStamp(newNonNull, newAlwaysNull, this.encoding);
    }

    @Override
    public boolean isCompatible(Stamp otherStamp) {
        if (this == otherStamp) {
            return true;
        }
        if (otherStamp instanceof KlassPointerStamp) {
            KlassPointerStamp other = (KlassPointerStamp)otherStamp;
            return Objects.equals(this.encoding, other.encoding);
        }
        return false;
    }

    @Override
    public boolean isCompatible(Constant constant) {
        if (constant instanceof HotSpotMetaspaceConstant) {
            return ((HotSpotMetaspaceConstant)constant).asResolvedJavaType() != null;
        }
        return super.isCompatible(constant);
    }

    @Override
    public Stamp constant(Constant c, MetaAccessProvider meta) {
        if (this.isCompressed()) {
            if (HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(c)) {
                return new KlassPointerStamp(false, true, this.encoding);
            }
        } else if (JavaConstant.NULL_POINTER.equals(c)) {
            return KLASS_ALWAYS_NULL;
        }
        assert (c instanceof HotSpotMetaspaceConstant);
        assert (((HotSpotMetaspaceConstant)c).isCompressed() == this.isCompressed());
        if (this.nonNull()) {
            return this;
        }
        if (this.isCompressed()) {
            return new KlassPointerStamp(true, false, this.encoding);
        }
        return KLASS_NON_NULL;
    }

    @Override
    public JavaConstant nullConstant() {
        if (this.isCompressed()) {
            return HotSpotCompressedNullConstant.COMPRESSED_NULL;
        }
        return super.nullConstant();
    }

    @Override
    public LIRKind getLIRKind(LIRKindTool tool) {
        if (this.isCompressed()) {
            return tool.getNarrowPointerKind();
        }
        return super.getLIRKind(tool);
    }

    @Override
    public boolean isCompressed() {
        return this.encoding != null;
    }

    public CompressEncoding getEncoding() {
        return this.encoding;
    }

    public KlassPointerStamp compressed(CompressEncoding newEncoding) {
        assert (!this.isCompressed());
        return new KlassPointerStamp(this.nonNull(), this.alwaysNull(), newEncoding);
    }

    public KlassPointerStamp uncompressed() {
        assert (this.isCompressed());
        return new KlassPointerStamp(this.nonNull(), this.alwaysNull());
    }

    @Override
    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement) {
        HotSpotMemoryAccessProvider hsProvider = (HotSpotMemoryAccessProvider)provider;
        if (this.isCompressed()) {
            return hsProvider.readNarrowKlassPointerConstant(base, displacement);
        }
        return hsProvider.readKlassPointerConstant(base, displacement);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof KlassPointerStamp)) {
            return false;
        }
        KlassPointerStamp other = (KlassPointerStamp)obj;
        return Objects.equals(this.encoding, other.encoding);
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder("Klass*");
        this.appendString(ret);
        if (this.isCompressed()) {
            ret.append("(compressed ").append(this.encoding).append(")");
        }
        return ret.toString();
    }
}

