/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;

public final class AMD64HotSpotMathIntrinsicOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64HotSpotMathIntrinsicOp> TYPE = LIRInstructionClass.create(AMD64HotSpotMathIntrinsicOp.class);
    @Opcode
    private final UnaryMathIntrinsicNode.UnaryOperation opcode;
    @LIRInstruction.Def
    protected Value result;
    @LIRInstruction.Use
    protected Value input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value temp;

    public AMD64HotSpotMathIntrinsicOp(UnaryMathIntrinsicNode.UnaryOperation opcode, Value result, Value input, Value temp) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.opcode = opcode;
        this.result = result;
        this.input = input;
        this.temp = temp;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        AMD64Address stackSlot = (AMD64Address)crb.asAddress(this.temp);
        switch (this.opcode) {
            case LOG: {
                masm.flog(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), false, stackSlot);
                break;
            }
            case LOG10: {
                masm.flog(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), true, stackSlot);
                break;
            }
            case SIN: {
                masm.fsin(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), stackSlot);
                break;
            }
            case COS: {
                masm.fcos(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), stackSlot);
                break;
            }
            case TAN: {
                masm.ftan(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), stackSlot);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }
}

