/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotVMEventListener;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.hotspot.HotSpotCodeCacheListener;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class HotSpotGraalVMEventListener
implements HotSpotVMEventListener {
    private final HotSpotGraalRuntime runtime;
    private List<HotSpotCodeCacheListener> listeners;

    HotSpotGraalVMEventListener(HotSpotGraalRuntime runtime) {
        this.runtime = runtime;
        this.listeners = new ArrayList<HotSpotCodeCacheListener>();
        for (HotSpotCodeCacheListener listener : GraalServices.load(HotSpotCodeCacheListener.class)) {
            this.listeners.add(listener);
        }
    }

    public void notifyShutdown() {
        this.runtime.shutdown();
    }

    public void notifyInstall(HotSpotCodeCacheProvider codeCache, InstalledCode installedCode, CompiledCode compiledCode) {
        DebugContext debug = DebugContext.forCurrentThread();
        if (debug.isDumpEnabled(1)) {
            CompilationResult compResult = debug.contextLookup(CompilationResult.class);
            assert (compResult != null) : "can't dump installed code properly without CompilationResult";
            debug.dump(1, installedCode, "After code installation");
        }
        if (debug.isLogEnabled()) {
            debug.log("%s", (Object)codeCache.disassemble(installedCode));
        }
        for (HotSpotCodeCacheListener listener : this.listeners) {
            listener.notifyInstall(codeCache, installedCode, compiledCode);
        }
    }

    public void notifyBootstrapFinished() {
        this.runtime.notifyBootstrapFinished();
        if (DebugOptions.ClearMetricsAfterBootstrap.getValue(this.runtime.getOptions()).booleanValue()) {
            this.runtime.clearMetrics();
        }
    }
}

