/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedDeque;
import jdk.vm.ci.hotspot.HotSpotInstalledCode;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.debug.CSVUtil;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;

public final class CompilationStatistics {
    private static final long RESOLUTION = 100000000L;
    private static final CompilationStatistics DUMMY = new CompilationStatistics(null, false);
    private static ConcurrentLinkedDeque<CompilationStatistics> list = new ConcurrentLinkedDeque();
    private static final ThreadLocal<Deque<CompilationStatistics>> current = new ThreadLocal<Deque<CompilationStatistics>>(){

        @Override
        protected Deque<CompilationStatistics> initialValue() {
            return new ArrayDeque<CompilationStatistics>();
        }
    };
    private static long zeroTime = System.nanoTime();
    @NotReported
    private final long startTime;
    @NotReported
    private long threadAllocatedBytesStart;
    private int bytecodeCount;
    private int codeSize;
    @TimeValue
    private long duration;
    private long memoryUsed;
    private final boolean osr;
    private final String holder;
    private final String name;
    private final String signature;

    private static long getThreadAllocatedBytes() {
        return GraalServices.getCurrentThreadAllocatedBytes();
    }

    private CompilationStatistics(HotSpotResolvedJavaMethod method, boolean osr) {
        this.osr = osr;
        if (method != null) {
            this.holder = method.getDeclaringClass().getName();
            this.name = method.getName();
            this.signature = method.getSignature().toMethodDescriptor();
            this.startTime = System.nanoTime();
            this.bytecodeCount = method.getCodeSize();
            this.threadAllocatedBytesStart = CompilationStatistics.getThreadAllocatedBytes();
        } else {
            assert (DUMMY == null) : "only DUMMY has no method";
            this.holder = "";
            this.name = "";
            this.signature = "";
            this.startTime = 0L;
        }
    }

    public void finish(HotSpotResolvedJavaMethod method, HotSpotInstalledCode code) {
        if (this.isEnabled()) {
            this.duration = System.nanoTime() - this.startTime;
            this.codeSize = (int)code.getCodeSize();
            this.memoryUsed = CompilationStatistics.getThreadAllocatedBytes() - this.threadAllocatedBytesStart;
            if (current.get().getLast() != this) {
                throw new RuntimeException("mismatch in finish()");
            }
            current.get().removeLast();
        }
    }

    public static CompilationStatistics current() {
        return current.get().isEmpty() ? null : current.get().getLast();
    }

    public static CompilationStatistics create(OptionValues options, HotSpotResolvedJavaMethod method, boolean isOSR) {
        if (Options.UseCompilationStatistics.getValue(options).booleanValue()) {
            CompilationStatistics stats = new CompilationStatistics(method, isOSR);
            list.add(stats);
            current.get().addLast(stats);
            return stats;
        }
        return DUMMY;
    }

    public boolean isEnabled() {
        return this != DUMMY;
    }

    public static void clear(String dumpName) {
        try {
            ConcurrentLinkedDeque<CompilationStatistics> snapshot = list;
            long snapshotZeroTime = zeroTime;
            list = new ConcurrentLinkedDeque();
            zeroTime = System.nanoTime();
            Date now = new Date();
            String dateString = now.getYear() + 1900 + "-" + (now.getMonth() + 1) + "-" + now.getDate() + "-" + now.getHours() + now.getMinutes();
            CompilationStatistics.dumpCompilations(snapshot, dumpName, dateString);
            try (FileOutputStream fos = new FileOutputStream("timeline_" + dateString + "_" + dumpName + ".csv", true);
                 PrintStream out = new PrintStream(fos);){
                long[] timeSpent = new long[10000];
                int maxTick = 0;
                for (CompilationStatistics stats : snapshot) {
                    long start = stats.startTime - snapshotZeroTime;
                    long duration = stats.duration;
                    if (start < 0L) {
                        duration -= -start;
                        start = 0L;
                    }
                    int tick = (int)(start / 100000000L);
                    long timeLeft = 100000000L - start % 100000000L;
                    while (tick < timeSpent.length && duration > 0L) {
                        if (tick > maxTick) {
                            maxTick = tick;
                        }
                        int n = tick++;
                        timeSpent[n] = timeSpent[n] + Math.min(timeLeft, duration);
                        duration -= timeLeft;
                        timeLeft = 100000000L;
                    }
                }
                String timelineName = (String)Services.getSavedProperties().get("stats.timeline.name");
                if (timelineName != null && !timelineName.isEmpty()) {
                    out.printf("%s%c", CSVUtil.Escape.escape(timelineName), Character.valueOf(';'));
                }
                for (int i = 0; i < maxTick; ++i) {
                    out.printf("%d%c", CompilationStatistics.normalize(timeSpent[i]), Character.valueOf(';'));
                }
                out.printf("%d", CompilationStatistics.normalize(timeSpent[maxTick]));
                out.println();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static long normalize(long time) {
        return time * 100L / 100000000L;
    }

    protected static void dumpCompilations(ConcurrentLinkedDeque<CompilationStatistics> snapshot, String dumpName, String dateString) throws IllegalAccessException, FileNotFoundException {
        String fileName = "compilations_" + dateString + "_" + dumpName + ".csv";
        char separator = '\t';
        try (PrintStream out = new PrintStream(fileName);){
            Field[] declaredFields = CompilationStatistics.class.getDeclaredFields();
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Field field : declaredFields) {
                if (Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(NotReported.class)) continue;
                fields.add(field);
            }
            String format = CSVUtil.buildFormatString("%s", separator, fields.size());
            CSVUtil.Escape.println(out, separator, '\"', '\\', format, fields.toArray());
            for (CompilationStatistics stats : snapshot) {
                Object[] values = new Object[fields.size()];
                for (int i = 0; i < fields.size(); ++i) {
                    Field field = (Field)fields.get(i);
                    if (field.isAnnotationPresent(TimeValue.class)) {
                        double value = (double)field.getLong(stats) / 1000000.0;
                        values[i] = String.format(Locale.ENGLISH, "%.3f", value);
                        continue;
                    }
                    values[i] = field.get(stats);
                }
                CSVUtil.Escape.println(out, separator, '\"', '\\', format, values);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface TimeValue {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface NotReported {
    }

    public static class Options {
        public static final OptionKey<Boolean> UseCompilationStatistics = new OptionKey<Boolean>(false);
    }
}

