/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.CompilationWatchDog;
import org.graalvm.compiler.core.common.util.Util;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

final class BootstrapWatchDog
extends Thread {
    private final AtomicInteger compilations = new AtomicInteger();
    private boolean hitCriticalRateOrTimeout;
    private double maxRate;
    private final HotSpotGraalRuntimeProvider graalRuntime;
    private static final boolean DEBUG = Boolean.parseBoolean((String)Services.getSavedProperties().get("debug.graal.BootstrapWatchDog"));
    private static final int INITIAL_DELAY = 10;
    private static final long EPOCH = 5L;
    private final int timeout;
    private final double maxRateDecrease;
    private final Map<Thread, Watch> requests = new HashMap<Thread, Watch>();
    private final ThreadLocal<Watch> requestForThread = new ThreadLocal();

    static BootstrapWatchDog maybeCreate(HotSpotGraalRuntimeProvider graalRuntime) {
        OptionValues options = graalRuntime.getOptions();
        int timeout = (int)(Options.BootstrapTimeout.getValue(options) * 60.0);
        double maxRateDecrease = Options.BootstrapWatchDogCriticalRateRatio.getValue(options);
        return maxRateDecrease <= 0.0 && timeout == 0 ? null : new BootstrapWatchDog(graalRuntime, timeout, maxRateDecrease);
    }

    private BootstrapWatchDog(HotSpotGraalRuntimeProvider graalRuntime, int timeout, double maxRateDecrease) {
        this.setName(this.getClass().getSimpleName());
        this.start();
        this.graalRuntime = graalRuntime;
        this.timeout = timeout;
        this.maxRateDecrease = maxRateDecrease;
    }

    @Override
    public void run() {
        if (DEBUG) {
            TTY.printf("%nStarted %s%n", this);
        }
        long start = System.currentTimeMillis();
        Map<Thread, Watch> requestsAtTimeout = null;
        HashMap<Thread, StackTraceElement[]> stacksAtTimeout = null;
        try {
            Thread.sleep(10000L);
            while (true) {
                int currentCompilations = this.compilations.get();
                long elapsed = System.currentTimeMillis() - start;
                double rate = (double)currentCompilations / BootstrapWatchDog.seconds(elapsed);
                if (DEBUG) {
                    TTY.printf("%.2f: compilation rate is %.2f/sec%n", BootstrapWatchDog.seconds(elapsed), rate);
                }
                if (rate > this.maxRate) {
                    this.maxRate = rate;
                } else if (rate < this.maxRate * this.maxRateDecrease) {
                    TTY.printf("%nAfter %.2f seconds bootstrapping, compilation rate is %.2f compilations per second which is below %.2f times the max compilation rate of %.2f%n", BootstrapWatchDog.seconds(elapsed), rate, this.maxRateDecrease, this.maxRate);
                    TTY.printf("To enable monitoring of long running individual compilations, re-run with -D%s%s=%.2f%n", "graal.", CompilationWatchDog.Options.CompilationWatchDogStartDelay.getName(), BootstrapWatchDog.seconds(elapsed) - 5.0);
                    this.hitCriticalRateOrTimeout = true;
                    return;
                }
                if (elapsed > (long)(this.timeout * 1000)) {
                    if (requestsAtTimeout == null) {
                        requestsAtTimeout = this.snapshotRequests();
                        stacksAtTimeout = new HashMap<Thread, StackTraceElement[]>();
                        for (Thread t : requestsAtTimeout.keySet()) {
                            stacksAtTimeout.put(t, t.getStackTrace());
                        }
                    } else {
                        TTY.printf("%nHit bootstrapping timeout after %.2f seconds%n", BootstrapWatchDog.seconds(elapsed));
                        Map<Thread, Watch> requestsNow = this.snapshotRequests();
                        for (Map.Entry<Thread, Watch> e : requestsAtTimeout.entrySet()) {
                            Thread t = e.getKey();
                            CompilationRequest request1 = requestsAtTimeout.get((Object)t).request;
                            CompilationRequest request2 = requestsNow.get((Object)t).request;
                            if (request1 != null && request1 == request2) {
                                Object[] stackTraceNow = t.getStackTrace();
                                TTY.printf("Printing stack trace for current compilation of %s lasting more than %d seconds:%n%s", request1.getMethod().format("%H.%n(%p)"), 5L, Util.toString((StackTraceElement[])stackTraceNow));
                                assert (stacksAtTimeout != null);
                                if (!Arrays.equals((Object[])stacksAtTimeout.get(t), stackTraceNow)) continue;
                                TTY.printf("\t** Identical stack trace %d seconds ago, implying a hung compilation **%n", 5L);
                                continue;
                            }
                            if (!DEBUG) continue;
                            TTY.printf("%s was compiling %s%n", t, request1.getMethod().format("%H.%n(%p)"));
                        }
                        this.hitCriticalRateOrTimeout = true;
                        return;
                    }
                }
                if (!this.graalRuntime.isBootstrapping()) {
                    return;
                }
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace(TTY.out);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Thread, Watch> snapshotRequests() {
        Map<Thread, Watch> map = this.requests;
        synchronized (map) {
            return new HashMap<Thread, Watch>(this.requests);
        }
    }

    private static double seconds(long ms) {
        return (double)ms / 1000.0;
    }

    boolean hitCriticalCompilationRateOrTimeout() {
        return this.hitCriticalRateOrTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Watch watch(CompilationRequest request) {
        Watch watch = this.requestForThread.get();
        if (watch == null) {
            watch = new Watch();
            Map<Thread, Watch> map = this.requests;
            synchronized (map) {
                this.requests.put(Thread.currentThread(), watch);
            }
        }
        watch.open(request);
        return watch;
    }

    class Watch
    implements AutoCloseable {
        CompilationRequest request;

        Watch() {
        }

        void open(CompilationRequest r) {
            assert (this.request == null);
            this.request = r;
        }

        @Override
        public void close() {
            BootstrapWatchDog.this.compilations.incrementAndGet();
            this.request = null;
        }
    }

    public static class Options {
        public static final OptionKey<Double> BootstrapWatchDogCriticalRateRatio = new OptionKey<Double>(0.25);
        public static final OptionKey<Double> BootstrapTimeout = new OptionKey<Double>(15.0);
    }
}

