/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.util.function.Consumer;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;

public final class CachedGraph<G extends Graph> {
    private final G readonlyCopy;
    private G mutableCopy;

    private CachedGraph(G readonlyCopy, G mutableCopy) {
        this.readonlyCopy = readonlyCopy;
        this.mutableCopy = mutableCopy;
    }

    public static <G extends Graph> CachedGraph<G> fromReadonlyCopy(G graph) {
        return new CachedGraph<Object>(graph, null);
    }

    public static <G extends Graph> CachedGraph<G> fromMutableCopy(G graph) {
        return new CachedGraph<G>(graph, graph);
    }

    public G getReadonlyCopy() {
        if (this.hasMutableCopy()) {
            return this.mutableCopy;
        }
        return this.readonlyCopy;
    }

    public boolean hasMutableCopy() {
        return this.mutableCopy != null;
    }

    public G getMutableCopy(Consumer<UnmodifiableEconomicMap<Node, Node>> duplicationMapCallback) {
        if (!this.hasMutableCopy()) {
            this.mutableCopy = ((Graph)this.readonlyCopy).copy(duplicationMapCallback, ((Graph)this.readonlyCopy).getDebug());
        }
        return this.mutableCopy;
    }
}

