/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.calc;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.SerializableConstant;
import org.graalvm.compiler.core.common.type.ArithmeticStamp;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;

public class ReinterpretUtils {
    public static Constant foldConstant(Stamp resultStamp, Constant constant) {
        SerializableConstant c = (SerializableConstant)constant;
        ByteBuffer buffer = ByteBuffer.wrap(new byte[c.getSerializedSize()]).order(ByteOrder.nativeOrder());
        c.serialize(buffer);
        buffer.rewind();
        SerializableConstant ret = ((ArithmeticStamp)resultStamp).deserialize(buffer);
        assert (!buffer.hasRemaining());
        return ret;
    }

    public static IntegerStamp floatToInt(FloatStamp stamp) {
        long exponentMask;
        int bits = stamp.getBits();
        long signBit = 1L << bits - 1;
        if (bits == 64) {
            exponentMask = Double.doubleToRawLongBits(Double.POSITIVE_INFINITY);
        } else {
            assert (bits == 32);
            exponentMask = Float.floatToRawIntBits(Float.POSITIVE_INFINITY);
        }
        long positiveInfinity = exponentMask;
        long negativeInfinity = CodeUtil.signExtend((long)(signBit | positiveInfinity), (int)bits);
        long negativeZero = CodeUtil.signExtend((long)(signBit | 0L), (int)bits);
        if (stamp.isNaN()) {
            return IntegerStamp.create(bits, negativeInfinity + 1L, CodeUtil.maxValue((int)bits), exponentMask, CodeUtil.mask((int)bits));
        }
        long upperBound = stamp.isNonNaN() ? (stamp.upperBound() < 0.0 ? (stamp.lowerBound() > Double.NEGATIVE_INFINITY ? negativeInfinity - 1L : negativeInfinity) : (stamp.upperBound() == 0.0 ? 0L : (stamp.upperBound() < Double.POSITIVE_INFINITY ? positiveInfinity - 1L : positiveInfinity))) : CodeUtil.maxValue((int)bits);
        long lowerBound = stamp.lowerBound() > 0.0 ? (stamp.isNonNaN() ? 1L : negativeInfinity + 1L) : (stamp.upperBound() == Double.NEGATIVE_INFINITY ? negativeInfinity : (stamp.upperBound() < 0.0 ? negativeZero + 1L : negativeZero));
        return StampFactory.forInteger(bits, lowerBound, upperBound);
    }

    public static FloatStamp intToFloat(IntegerStamp stamp) {
        boolean nonNaN;
        double upperBound;
        double maxPositive;
        double minPositive;
        long exponentMask;
        int bits = stamp.getBits();
        long signBit = 1L << bits - 1;
        if (bits == 64) {
            exponentMask = Double.doubleToRawLongBits(Double.POSITIVE_INFINITY);
            minPositive = Double.MIN_VALUE;
            maxPositive = Double.MAX_VALUE;
        } else {
            assert (bits == 32);
            exponentMask = Float.floatToRawIntBits(Float.POSITIVE_INFINITY);
            minPositive = 1.4E-45f;
            maxPositive = 3.4028234663852886E38;
        }
        long significandMask = CodeUtil.mask((int)bits) & ((signBit | exponentMask) ^ 0xFFFFFFFFFFFFFFFFL);
        long positiveInfinity = exponentMask;
        long negativeInfinity = CodeUtil.signExtend((long)(signBit | positiveInfinity), (int)bits);
        long negativeZero = CodeUtil.signExtend((long)(signBit | 0L), (int)bits);
        if ((stamp.downMask() & exponentMask) == exponentMask && (stamp.downMask() & significandMask) != 0L) {
            return new FloatStamp(bits, Double.NaN, Double.NaN, false);
        }
        if (stamp.upperBound() < negativeInfinity) {
            upperBound = stamp.lowerBound() > negativeZero ? -minPositive : -0.0;
        } else if (stamp.upperBound() < 0L) {
            if (stamp.lowerBound() > negativeInfinity) {
                return new FloatStamp(bits, Double.NaN, Double.NaN, false);
            }
            upperBound = stamp.lowerBound() == negativeInfinity ? Double.NEGATIVE_INFINITY : (stamp.lowerBound() > negativeZero ? -minPositive : -0.0);
        } else {
            upperBound = stamp.upperBound() == 0L ? 0.0 : (stamp.upperBound() < positiveInfinity ? maxPositive : Double.POSITIVE_INFINITY);
        }
        if (stamp.lowerBound() > positiveInfinity) {
            return new FloatStamp(bits, Double.NaN, Double.NaN, false);
        }
        double lowerBound = stamp.lowerBound() == positiveInfinity ? Double.POSITIVE_INFINITY : (stamp.lowerBound() > 0L ? minPositive : (stamp.lowerBound() > negativeInfinity ? 0.0 : Double.NEGATIVE_INFINITY));
        if ((stamp.upMask() & exponentMask) != exponentMask) {
            nonNaN = true;
        } else {
            boolean negativeNaNBlock = stamp.lowerBound() < 0L && stamp.upperBound() > negativeInfinity;
            boolean positiveNaNBlock = stamp.upperBound() > positiveInfinity;
            nonNaN = !negativeNaNBlock && !positiveNaNBlock;
        }
        return new FloatStamp(bits, lowerBound, upperBound, nonNaN);
    }
}

