/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.amd64;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.asm.AbstractAddress;
import org.graalvm.compiler.core.common.Stride;

public final class AMD64Address
extends AbstractAddress {
    private final Register base;
    private final Register index;
    private final Stride stride;
    private final int displacement;
    private final Object displacementAnnotation;
    final int instructionStartPosition;

    public AMD64Address(Register base) {
        this(base, Register.None, Stride.S1, 0);
    }

    public AMD64Address(Register base, int displacement) {
        this(base, Register.None, Stride.S1, displacement);
    }

    public AMD64Address(Register base, Register index, Stride stride) {
        this(base, index, stride, 0, null, -1);
    }

    public AMD64Address(Register base, Register index, Stride stride, int displacement) {
        this(base, index, stride, displacement, null, -1);
    }

    public AMD64Address(Register base, Register index, Stride stride, int displacement, Object displacementAnnotation) {
        this(base, index, stride, displacement, displacementAnnotation, -1);
    }

    AMD64Address(Register base, Register index, Stride stride, int displacement, Object displacementAnnotation, int instructionStartPosition) {
        this.base = base;
        this.index = index;
        this.stride = stride;
        this.displacement = displacement;
        this.displacementAnnotation = displacementAnnotation;
        this.instructionStartPosition = instructionStartPosition;
        assert (stride != null);
    }

    public static boolean isScaleSupported(int scale) {
        return CodeUtil.isPowerOf2((int)scale) && scale <= 8;
    }

    public static boolean isScaleShiftSupported(int shift) {
        return shift >= 0 && shift <= 3;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        String sep = "";
        if (!this.getBase().equals((Object)Register.None)) {
            s.append(this.getBase());
            sep = " + ";
        }
        if (!this.getIndex().equals((Object)Register.None)) {
            s.append(sep).append(this.getIndex()).append(" * ").append(this.getScale().value);
            sep = " + ";
        }
        if (this.getDisplacement() < 0) {
            s.append(" - ").append(-this.getDisplacement());
        } else if (this.getDisplacement() > 0) {
            s.append(sep).append(this.getDisplacement());
        }
        if (this.displacementAnnotation != null) {
            s.append(" + ").append(this.displacementAnnotation);
        }
        s.append("]");
        return s.toString();
    }

    public Register getBase() {
        return this.base;
    }

    public Register getIndex() {
        return this.index;
    }

    public Stride getScale() {
        return this.stride;
    }

    public int getDisplacement() {
        return this.displacement;
    }

    public Object getDisplacementAnnotation() {
        return this.displacementAnnotation;
    }

    boolean isPlaceholder() {
        return this.instructionStartPosition >= 0;
    }
}

