/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.Objects;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstantScope;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.hotspot.CompilationContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HotSpotGraalServices {
    public static CompilationContext enterGlobalCompilationContext() {
        HotSpotObjectConstantScope impl = HotSpotObjectConstantScope.enterGlobalScope();
        return impl == null ? null : new CompilationContext((AutoCloseable)impl);
    }

    public static CompilationContext openLocalCompilationContext(Object description) {
        HotSpotObjectConstantScope impl = HotSpotObjectConstantScope.openLocalScope((Object)Objects.requireNonNull(description));
        return impl == null ? null : new CompilationContext((AutoCloseable)impl);
    }

    public static void exit(int status, HotSpotJVMCIRuntime runtime) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            runtime.exitHotSpot(status);
        } else {
            System.exit(status);
        }
    }

    public static SpeculationLog newHotSpotSpeculationLog(long cachedFailedSpeculationsAddress) {
        return new HotSpotSpeculationLog(cachedFailedSpeculationsAddress);
    }
}

