/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopElement;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopVertexProperty;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class HadoopVertex
extends HadoopElement
implements Vertex,
WrappedVertex<Vertex> {
    protected HadoopVertex() {
    }

    public HadoopVertex(Vertex vertex, HadoopGraph graph) {
        super((Element)vertex, graph);
    }

    public <V> VertexProperty<V> property(String key) {
        VertexProperty vertexProperty = this.getBaseVertex().property(key);
        return vertexProperty.isPresent() ? new HadoopVertexProperty(((Vertex)this.baseElement).property(key), this) : VertexProperty.empty();
    }

    public <V> VertexProperty<V> property(String key, V value) {
        throw Element.Exceptions.propertyAdditionNotSupported();
    }

    public <V> VertexProperty<V> property(String key, V value, Object ... keyValues) {
        throw Element.Exceptions.propertyAdditionNotSupported();
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        throw Element.Exceptions.propertyAdditionNotSupported();
    }

    public Edge addEdge(String label, Vertex inVertex, Object ... keyValues) {
        throw Vertex.Exceptions.edgeAdditionsNotSupported();
    }

    public Vertex getBaseVertex() {
        return (Vertex)this.baseElement;
    }

    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        return IteratorUtils.map((Iterator)this.getBaseVertex().vertices(direction, edgeLabels), vertex -> this.graph.vertices(vertex.id()).next());
    }

    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        return IteratorUtils.map((Iterator)this.getBaseVertex().edges(direction, edgeLabels), edge -> this.graph.edges(edge.id()).next());
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        return IteratorUtils.map((Iterator)this.getBaseVertex().properties(propertyKeys), property -> new HadoopVertexProperty(property, this));
    }
}

