/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonWriter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class JSONBean {
    private static final Logger LOG = LoggerFactory.getLogger(JSONBean.class);
    private static final Gson GSON = GsonUtil.createGson().create();

    public Writer open(final PrintWriter writer) throws IOException {
        final JsonWriter jsonWriter = GSON.newJsonWriter(new java.io.Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                writer.write(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
                writer.flush();
            }

            @Override
            public void close() throws IOException {
            }
        });
        jsonWriter.setIndent("  ");
        jsonWriter.beginObject();
        return new Writer(){

            @Override
            public void flush() throws IOException {
                jsonWriter.flush();
            }

            @Override
            public void close() throws IOException {
                jsonWriter.endObject();
                jsonWriter.close();
            }

            @Override
            public void write(String key, String value) throws IOException {
                jsonWriter.name(key).value(value);
            }

            @Override
            public int write(MBeanServer mBeanServer, ObjectName qry, String attribute, boolean description) throws IOException {
                return JSONBean.write(jsonWriter, mBeanServer, qry, attribute, description);
            }
        };
    }

    private static int write(JsonWriter writer, MBeanServer mBeanServer, ObjectName qry, String attribute, boolean description) throws IOException {
        LOG.trace("Listing beans for " + qry);
        Set<ObjectName> names = null;
        names = mBeanServer.queryNames(qry, null);
        writer.name("beans").beginArray();
        for (ObjectName oname : names) {
            MBeanInfo minfo;
            Object attributeinfo;
            String descriptionStr;
            String code;
            block21: {
                code = "";
                descriptionStr = null;
                attributeinfo = null;
                try {
                    minfo = mBeanServer.getMBeanInfo(oname);
                    code = minfo.getClassName();
                    if (description) {
                        descriptionStr = minfo.getDescription();
                    }
                    String prs = "";
                    try {
                        if ("org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                            prs = "modelerType";
                            code = (String)mBeanServer.getAttribute(oname, prs);
                        }
                        if (attribute == null) break block21;
                        prs = attribute;
                        attributeinfo = mBeanServer.getAttribute(oname, prs);
                    }
                    catch (RuntimeMBeanException e) {
                        if (e.getCause() instanceof UnsupportedOperationException) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Getting attribute " + prs + " of " + oname + " threw " + e);
                            }
                        } else {
                            LOG.error("Getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)e);
                        }
                        return 0;
                    }
                    catch (AttributeNotFoundException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)e);
                    }
                    catch (MBeanException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)e);
                    }
                    catch (RuntimeException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)e);
                    }
                    catch (ReflectionException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)e);
                    }
                }
                catch (InstanceNotFoundException e) {
                    continue;
                }
                catch (IntrospectionException e) {
                    LOG.error("Problem while trying to process JMX query: " + qry + " with MBean " + oname, (Throwable)e);
                    continue;
                }
                catch (ReflectionException e) {
                    LOG.error("Problem while trying to process JMX query: " + qry + " with MBean " + oname, (Throwable)e);
                    continue;
                }
            }
            writer.beginObject();
            writer.name("name").value(oname.toString());
            if (description && descriptionStr != null && descriptionStr.length() > 0) {
                writer.name("description").value(descriptionStr);
            }
            writer.name("modelerType").value(code);
            if (attribute != null && attributeinfo == null) {
                writer.name("result").value("ERROR");
                writer.name("message").value("No attribute with name " + attribute + " was found.");
                writer.endObject();
                writer.endArray();
                writer.close();
                return -1;
            }
            if (attribute != null) {
                JSONBean.writeAttribute(writer, attribute, descriptionStr, attributeinfo);
            } else {
                MBeanAttributeInfo[] attrs = minfo.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    JSONBean.writeAttribute(writer, mBeanServer, oname, description, attrs[i]);
                }
            }
            writer.endObject();
        }
        writer.endArray();
        return 0;
    }

    private static void writeAttribute(JsonWriter writer, MBeanServer mBeanServer, ObjectName oname, boolean description, MBeanAttributeInfo attr) throws IOException {
        if (!attr.isReadable()) {
            return;
        }
        String attName = attr.getName();
        if ("modelerType".equals(attName)) {
            return;
        }
        if (attName.indexOf("=") >= 0 || attName.indexOf(":") >= 0 || attName.indexOf(" ") >= 0) {
            return;
        }
        String descriptionStr = description ? attr.getDescription() : null;
        Object value = null;
        try {
            value = mBeanServer.getAttribute(oname, attName);
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Getting attribute " + attName + " of " + oname + " threw " + e);
                }
            } else {
                LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)e);
            }
            return;
        }
        catch (RuntimeErrorException e) {
            LOG.debug("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)e);
            return;
        }
        catch (AttributeNotFoundException e) {
            return;
        }
        catch (MBeanException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)e);
            return;
        }
        catch (RuntimeException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)e);
            return;
        }
        catch (ReflectionException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)e);
            return;
        }
        catch (InstanceNotFoundException e) {
            return;
        }
        JSONBean.writeAttribute(writer, attName, descriptionStr, value);
    }

    private static void writeAttribute(JsonWriter writer, String attName, String descriptionStr, Object value) throws IOException {
        if (descriptionStr != null && descriptionStr.length() > 0 && !attName.equals(descriptionStr)) {
            writer.name(attName);
            writer.beginObject();
            writer.name("description").value(descriptionStr);
            writer.name("value");
            JSONBean.writeObject(writer, value);
            writer.endObject();
        } else {
            writer.name(attName);
            JSONBean.writeObject(writer, value);
        }
    }

    private static void writeObject(JsonWriter writer, Object value) throws IOException {
        if (value == null) {
            writer.nullValue();
        } else {
            Class<?> c = value.getClass();
            if (c.isArray()) {
                writer.beginArray();
                int len = Array.getLength(value);
                for (int j = 0; j < len; ++j) {
                    Object item = Array.get(value, j);
                    JSONBean.writeObject(writer, item);
                }
                writer.endArray();
            } else if (value instanceof Number) {
                Number n = (Number)value;
                if (Double.isFinite(n.doubleValue())) {
                    writer.value(n);
                } else {
                    writer.value(n.toString());
                }
            } else if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                writer.value(b);
            } else if (value instanceof CompositeData) {
                CompositeData cds = (CompositeData)value;
                CompositeType comp = cds.getCompositeType();
                Set<String> keys = comp.keySet();
                writer.beginObject();
                for (String key : keys) {
                    JSONBean.writeAttribute(writer, key, null, cds.get(key));
                }
                writer.endObject();
            } else if (value instanceof TabularData) {
                TabularData tds = (TabularData)value;
                writer.beginArray();
                for (Object entry : tds.values()) {
                    JSONBean.writeObject(writer, entry);
                }
                writer.endArray();
            } else {
                writer.value(value.toString());
            }
        }
    }

    public static void dumpAllBeans() throws IOException, MalformedObjectNameException {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));){
            JSONBean dumper = new JSONBean();
            try (Writer jsonBeanWriter = dumper.open(writer);){
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                jsonBeanWriter.write(mbeanServer, new ObjectName("*:*"), null, false);
            }
        }
    }

    public static interface Writer
    extends Closeable {
        public void write(String var1, String var2) throws IOException;

        public int write(MBeanServer var1, ObjectName var2, String var3, boolean var4) throws IOException;

        public void flush() throws IOException;
    }
}

