/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.procedure2.CompletedProcedureRetainer;
import org.apache.hadoop.hbase.procedure2.FailedProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureInMemoryChore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class CompletedProcedureCleaner<TEnvironment>
extends ProcedureInMemoryChore<TEnvironment> {
    private static final Logger LOG = LoggerFactory.getLogger(CompletedProcedureCleaner.class);
    static final String CLEANER_INTERVAL_CONF_KEY = "hbase.procedure.cleaner.interval";
    private static final int DEFAULT_CLEANER_INTERVAL = 30000;
    private static final String BATCH_SIZE_CONF_KEY = "hbase.procedure.cleaner.evict.batch.size";
    private static final int DEFAULT_BATCH_SIZE = 32;
    private final Map<Long, CompletedProcedureRetainer<TEnvironment>> completed;
    private final Map<NonceKey, Long> nonceKeysToProcIdsMap;
    private final ProcedureStore store;
    private final IdLock procExecutionLock;
    private Configuration conf;

    public CompletedProcedureCleaner(Configuration conf, ProcedureStore store, IdLock procExecutionLock, Map<Long, CompletedProcedureRetainer<TEnvironment>> completedMap, Map<NonceKey, Long> nonceKeysToProcIdsMap) {
        super(conf.getInt(CLEANER_INTERVAL_CONF_KEY, 30000));
        this.completed = completedMap;
        this.nonceKeysToProcIdsMap = nonceKeysToProcIdsMap;
        this.store = store;
        this.procExecutionLock = procExecutionLock;
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void periodicExecute(TEnvironment env) {
        if (this.completed.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No completed procedures to cleanup.");
            }
            return;
        }
        long evictTtl = this.conf.getInt("hbase.procedure.cleaner.evict.ttl", 900000);
        long evictAckTtl = this.conf.getInt("hbase.procedure.cleaner.acked.evict.ttl", 300000);
        int batchSize = this.conf.getInt(BATCH_SIZE_CONF_KEY, 32);
        long[] batchIds = new long[batchSize];
        int batchCount = 0;
        long now = EnvironmentEdgeManager.currentTime();
        Iterator<Map.Entry<Long, CompletedProcedureRetainer<TEnvironment>>> it = this.completed.entrySet().iterator();
        while (it.hasNext() && this.store.isRunning()) {
            IdLock.Entry lockEntry;
            Map.Entry<Long, CompletedProcedureRetainer<TEnvironment>> entry = it.next();
            CompletedProcedureRetainer<TEnvironment> retainer = entry.getValue();
            Procedure<TEnvironment> proc = retainer.getProcedure();
            try {
                lockEntry = this.procExecutionLock.getLockEntry(proc.getProcId());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            try {
                NonceKey nonceKey;
                if (!retainer.isExpired(now, evictTtl, evictAckTtl)) continue;
                if (!(proc instanceof FailedProcedure)) {
                    batchIds[batchCount++] = entry.getKey();
                    if (batchCount == batchIds.length) {
                        this.store.delete(batchIds, 0, batchCount);
                        batchCount = 0;
                    }
                }
                if ((nonceKey = proc.getNonceKey()) != null) {
                    this.nonceKeysToProcIdsMap.remove(nonceKey);
                }
                it.remove();
                LOG.trace("Evict completed {}", proc);
            }
            finally {
                this.procExecutionLock.releaseLockEntry(lockEntry);
            }
        }
        if (batchCount > 0) {
            this.store.delete(batchIds, 0, batchCount);
        }
    }
}

