/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DisabledTableSnapshotHandler
extends TakeSnapshotHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DisabledTableSnapshotHandler.class);

    public DisabledTableSnapshotHandler(SnapshotProtos.SnapshotDescription snapshot, MasterServices masterServices, SnapshotManager snapshotManager) throws IOException {
        super(snapshot, masterServices, snapshotManager);
    }

    @Override
    public DisabledTableSnapshotHandler prepare() throws Exception {
        return (DisabledTableSnapshotHandler)super.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snapshotRegions(List<Pair<RegionInfo, ServerName>> regionsAndLocations) throws IOException, KeeperException {
        try {
            HashSet<RegionInfo> regions = new HashSet<RegionInfo>();
            for (Pair<RegionInfo, ServerName> p : regionsAndLocations) {
                RegionInfo hri = p.getFirst();
                if (!RegionReplicaUtil.isDefaultReplica(hri)) continue;
                regions.add(hri);
            }
            boolean mobEnabled = MobUtils.hasMobColumns(this.htd);
            if (mobEnabled) {
                RegionInfo mobRegionInfo = MobUtils.getMobRegionInfo(this.htd.getTableName());
                regions.add(mobRegionInfo);
            }
            String msg = "Starting to write region info and WALs for regions for offline snapshot:" + ClientSnapshotDescriptionUtils.toString(this.snapshot);
            LOG.info(msg);
            this.status.setStatus(msg);
            ThreadPoolExecutor exec = SnapshotManifest.createExecutor(this.conf, "DisabledTableSnapshot");
            try {
                ModifyRegionUtils.editRegions(exec, regions, new ModifyRegionUtils.RegionEditTask(){

                    @Override
                    public void editRegion(RegionInfo regionInfo) throws IOException {
                        DisabledTableSnapshotHandler.this.snapshotManifest.addRegion(FSUtils.getTableDir(DisabledTableSnapshotHandler.this.rootDir, DisabledTableSnapshotHandler.this.snapshotTable), regionInfo);
                    }
                });
            }
            finally {
                exec.shutdown();
            }
        }
        catch (Exception e) {
            String reason = "Failed snapshot " + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " due to exception:" + e.getMessage();
            ForeignException ee = new ForeignException(reason, e);
            this.monitor.receive(ee);
            this.status.abort("Snapshot of table: " + this.snapshotTable + " failed because " + e.getMessage());
        }
        finally {
            LOG.debug("Marking snapshot" + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " as finished.");
        }
    }

    @Override
    protected boolean downgradeToSharedTableLock() {
        return false;
    }
}

