/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TruncateTableProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.TruncateTableState> {
    private static final Logger LOG = LoggerFactory.getLogger(TruncateTableProcedure.class);
    private boolean preserveSplits;
    private List<RegionInfo> regions;
    private TableDescriptor tableDescriptor;
    private TableName tableName;

    public TruncateTableProcedure() {
    }

    public TruncateTableProcedure(MasterProcedureEnv env, TableName tableName, boolean preserveSplits) throws HBaseIOException {
        this(env, tableName, preserveSplits, null);
    }

    public TruncateTableProcedure(MasterProcedureEnv env, TableName tableName, boolean preserveSplits, ProcedurePrepareLatch latch) throws HBaseIOException {
        super(env, latch);
        this.tableName = tableName;
        this.preflightChecks(env, false);
        this.preserveSplits = preserveSplits;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.TruncateTableState state) throws InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " execute state=" + state);
        }
        try {
            switch (state) {
                case TRUNCATE_TABLE_PRE_OPERATION: {
                    if (!this.prepareTruncate(env)) {
                        assert (this.isFailed()) : "the truncate should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    LOG.debug("waiting for '" + this.getTableName() + "' regions in transition");
                    this.regions = env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.getTableName());
                    RegionReplicaUtil.removeNonDefaultRegions(this.regions);
                    assert (this.regions != null && !this.regions.isEmpty()) : "unexpected 0 regions";
                    ProcedureSyncWait.waitRegionInTransition(env, this.regions);
                    this.preTruncate(env);
                    this.tableDescriptor = env.getMasterServices().getTableDescriptors().get(this.tableName);
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_CLEAR_FS_LAYOUT);
                    break;
                }
                case TRUNCATE_TABLE_CLEAR_FS_LAYOUT: {
                    DeleteTableProcedure.deleteFromFs(env, this.getTableName(), this.regions, true);
                    this.regions = !this.preserveSplits ? Arrays.asList(ModifyRegionUtils.createRegionInfos(this.tableDescriptor, null)) : TruncateTableProcedure.recreateRegionInfo(this.regions);
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_REMOVE_FROM_META);
                    break;
                }
                case TRUNCATE_TABLE_REMOVE_FROM_META: {
                    List<RegionInfo> originalRegions = env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.getTableName());
                    DeleteTableProcedure.deleteFromMeta(env, this.getTableName(), originalRegions);
                    DeleteTableProcedure.deleteAssignmentState(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_CREATE_FS_LAYOUT);
                    break;
                }
                case TRUNCATE_TABLE_CREATE_FS_LAYOUT: {
                    DeleteTableProcedure.deleteFromFs(env, this.getTableName(), this.regions, true);
                    this.regions = CreateTableProcedure.createFsLayout(env, this.tableDescriptor, this.regions);
                    CreateTableProcedure.updateTableDescCache(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_ADD_TO_META);
                    break;
                }
                case TRUNCATE_TABLE_ADD_TO_META: {
                    this.regions = CreateTableProcedure.addTableToMeta(env, this.tableDescriptor, this.regions);
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_ASSIGN_REGIONS);
                    break;
                }
                case TRUNCATE_TABLE_ASSIGN_REGIONS: {
                    CreateTableProcedure.setEnablingState(env, this.getTableName());
                    this.addChildProcedure(env.getAssignmentManager().createRoundRobinAssignProcedures(this.regions));
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_POST_OPERATION);
                    this.tableDescriptor = null;
                    this.regions = null;
                    break;
                }
                case TRUNCATE_TABLE_POST_OPERATION: {
                    CreateTableProcedure.setEnabledState(env, this.getTableName());
                    this.postTruncate(env);
                    LOG.debug("truncate '" + this.getTableName() + "' completed");
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-truncate-table", e);
            }
            LOG.warn("Retriable error trying to truncate table=" + this.getTableName() + " state=" + state, (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.TruncateTableState state) {
        if (state == MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_PRE_OPERATION) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected void completionCleanup(MasterProcedureEnv env) {
        this.releaseSyncLatch();
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.TruncateTableState state) {
        switch (state) {
            case TRUNCATE_TABLE_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected MasterProcedureProtos.TruncateTableState getState(int stateId) {
        return MasterProcedureProtos.TruncateTableState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.TruncateTableState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.TruncateTableState getInitialState() {
        return MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_PRE_OPERATION;
    }

    @Override
    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.getTableName());
        sb.append(" preserveSplits=");
        sb.append(this.preserveSplits);
        sb.append(")");
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.TruncateTableStateData.Builder state = MasterProcedureProtos.TruncateTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setPreserveSplits(this.preserveSplits);
        if (this.tableDescriptor != null) {
            state.setTableSchema(ProtobufUtil.toTableSchema(this.tableDescriptor));
        } else {
            state.setTableName(ProtobufUtil.toProtoTableName(this.tableName));
        }
        if (this.regions != null) {
            for (RegionInfo hri : this.regions) {
                state.addRegionInfo(ProtobufUtil.toRegionInfo(hri));
            }
        }
        serializer.serialize(state.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.TruncateTableStateData state = serializer.deserialize(MasterProcedureProtos.TruncateTableStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(state.getUserInfo()));
        if (state.hasTableSchema()) {
            this.tableDescriptor = ProtobufUtil.toTableDescriptor(state.getTableSchema());
            this.tableName = this.tableDescriptor.getTableName();
        } else {
            this.tableName = ProtobufUtil.toTableName(state.getTableName());
        }
        this.preserveSplits = state.getPreserveSplits();
        if (state.getRegionInfoCount() == 0) {
            this.regions = null;
        } else {
            this.regions = new ArrayList<RegionInfo>(state.getRegionInfoCount());
            for (HBaseProtos.RegionInfo hri : state.getRegionInfoList()) {
                this.regions.add(ProtobufUtil.toRegionInfo(hri));
            }
        }
    }

    private static List<RegionInfo> recreateRegionInfo(List<RegionInfo> regions) {
        ArrayList<RegionInfo> newRegions = new ArrayList<RegionInfo>(regions.size());
        for (RegionInfo hri : regions) {
            newRegions.add(RegionInfoBuilder.newBuilder(hri.getTable()).setStartKey(hri.getStartKey()).setEndKey(hri.getEndKey()).build());
        }
        return newRegions;
    }

    private boolean prepareTruncate(MasterProcedureEnv env) throws IOException {
        try {
            env.getMasterServices().checkTableModifiable(this.getTableName());
        }
        catch (TableNotDisabledException | TableNotFoundException e) {
            this.setFailure("master-truncate-table", e);
            return false;
        }
        return true;
    }

    private boolean preTruncate(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            TableName tableName = this.getTableName();
            cpHost.preTruncateTableAction(tableName, this.getUser());
        }
        return true;
    }

    private void postTruncate(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            TableName tableName = this.getTableName();
            cpHost.postCompletedTruncateTableAction(tableName, this.getUser());
        }
    }

    @VisibleForTesting
    RegionInfo getFirstRegionInfo() {
        if (this.regions == null || this.regions.isEmpty()) {
            return null;
        }
        return this.regions.get(0);
    }
}

