/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MergeNormalizationPlan
implements NormalizationPlan {
    private static final Logger LOG = LoggerFactory.getLogger((String)MergeNormalizationPlan.class.getName());
    private final RegionInfo firstRegion;
    private final RegionInfo secondRegion;

    public MergeNormalizationPlan(RegionInfo firstRegion, RegionInfo secondRegion) {
        this.firstRegion = firstRegion;
        this.secondRegion = secondRegion;
    }

    @Override
    public NormalizationPlan.PlanType getType() {
        return NormalizationPlan.PlanType.MERGE;
    }

    RegionInfo getFirstRegion() {
        return this.firstRegion;
    }

    RegionInfo getSecondRegion() {
        return this.secondRegion;
    }

    public String toString() {
        return "MergeNormalizationPlan{firstRegion=" + this.firstRegion + ", secondRegion=" + this.secondRegion + '}';
    }

    @Override
    public void execute(Admin admin) {
        LOG.info("Executing merging normalization plan: " + this);
        try {
            admin.mergeRegionsAsync(this.firstRegion.getEncodedNameAsBytes(), this.secondRegion.getEncodedNameAsBytes(), true);
        }
        catch (IOException ex) {
            LOG.error("Error during region merge: ", (Throwable)ex);
        }
    }
}

