/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class TimeToLiveHFileCleaner
extends BaseHFileCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger((String)TimeToLiveHFileCleaner.class.getName());
    public static final String TTL_CONF_KEY = "hbase.master.hfilecleaner.ttl";
    public static final long DEFAULT_TTL = 300000L;
    private long ttl;

    @Override
    public void setConf(Configuration conf) {
        this.ttl = conf.getLong(TTL_CONF_KEY, 300000L);
        super.setConf(conf);
    }

    @Override
    public boolean isFileDeletable(FileStatus fStat) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        long time = fStat.getModificationTime();
        long life = currentTime - time;
        if (LOG.isTraceEnabled()) {
            LOG.trace("HFile life:" + life + ", ttl:" + this.ttl + ", current:" + currentTime + ", from: " + time);
        }
        if (life < 0L) {
            LOG.warn("Found a hfile (" + fStat.getPath() + ") newer than current time (" + currentTime + " < " + time + "), probably a clock skew");
            return false;
        }
        return life > this.ttl;
    }
}

