/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.util.HashMap;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.hbase.http.HttpRequestLogAppender;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.server.NCSARequestLog;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.server.RequestLog;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.Log4jLoggerAdapter;

@InterfaceAudience.Private
public final class HttpRequestLog {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestLog.class);
    private static final HashMap<String, String> serverToComponent = new HashMap();

    private static org.apache.log4j.Logger getLog4jLogger(String loggerName) {
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (logger instanceof Log4JLogger) {
            Log4JLogger httpLog4JLog = (Log4JLogger)logger;
            return httpLog4JLog.getLogger();
        }
        if (logger instanceof Log4jLoggerAdapter) {
            return LogManager.getLogger((String)loggerName);
        }
        return null;
    }

    public static RequestLog getRequestLog(String name) {
        String lookup = serverToComponent.get(name);
        if (lookup != null) {
            name = lookup;
        }
        String loggerName = "http.requests." + name;
        String appenderName = name + "requestlog";
        org.apache.log4j.Logger httpLogger = HttpRequestLog.getLog4jLogger(loggerName);
        if (httpLogger == null) {
            LOG.warn("Jetty request log can only be enabled using Log4j");
            return null;
        }
        Appender appender = null;
        try {
            appender = httpLogger.getAppender(appenderName);
        }
        catch (LogConfigurationException e) {
            LOG.warn("Http request log for " + loggerName + " could not be created");
            throw e;
        }
        if (appender == null) {
            LOG.info("Http request log for " + loggerName + " is not defined");
            return null;
        }
        if (appender instanceof HttpRequestLogAppender) {
            HttpRequestLogAppender requestLogAppender = (HttpRequestLogAppender)appender;
            NCSARequestLog requestLog = new NCSARequestLog();
            requestLog.setFilename(requestLogAppender.getFilename());
            requestLog.setRetainDays(requestLogAppender.getRetainDays());
            return requestLog;
        }
        LOG.warn("Jetty request log for " + loggerName + " was of the wrong class");
        return null;
    }

    private HttpRequestLog() {
    }

    static {
        serverToComponent.put("master", "master");
        serverToComponent.put("region", "regionserver");
    }
}

