/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.janusgraph.hadoop.HadoopStoreManager;
import org.janusgraph.hadoop.formats.cql.CqlBinaryInputFormat;

public class CqlHadoopStoreManager
implements HadoopStoreManager {
    private CqlSession session;

    public CqlHadoopStoreManager(CqlSession session) {
        this.session = session;
    }

    public String getPartitioner() {
        return ((TokenMap)this.session.getMetadata().getTokenMap().get()).getPartitionerName();
    }

    public Class<? extends InputFormat> getInputFormat(Configuration hadoopConf) {
        hadoopConf.set("cassandra.input.partitioner.class", this.getPartitioner());
        return CqlBinaryInputFormat.class;
    }
}

