/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.function.mutate;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import io.vavr.concurrent.Future;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.function.ConsumerWithBackendException;
import org.janusgraph.diskstorage.cql.function.mutate.AbstractCQLMutateManyLoggedFunction;
import org.janusgraph.diskstorage.util.time.TimestampProvider;

public class CQLExecutorServiceMutateManyLoggedFunction
extends AbstractCQLMutateManyLoggedFunction {
    private final CqlSession session;
    private final ExecutorService executorService;

    public CQLExecutorServiceMutateManyLoggedFunction(TimestampProvider times, boolean assignTimestamp, Map<String, CQLKeyColumnValueStore> openStores, CqlSession session, ExecutorService executorService, ConsumerWithBackendException<DistributedStoreManager.MaskedTimestamp> sleepAfterWriteFunction) {
        super(times, assignTimestamp, openStores, sleepAfterWriteFunction);
        this.session = session;
        this.executorService = executorService;
    }

    @Override
    protected void execute(BatchStatement batchStatement) throws BackendException {
        Future result = Future.fromJavaFuture((Executor)this.executorService, this.session.executeAsync((Statement)batchStatement).toCompletableFuture());
        result.await();
        if (result.isFailure()) {
            throw CQLKeyColumnValueStore.EXCEPTION_MAPPER.apply((Throwable)result.getCause().get());
        }
    }
}

