/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotManifestV1;
import org.apache.hadoop.hbase.snapshot.SnapshotManifestV2;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class SnapshotManifest {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotManifest.class);
    public static final String SNAPSHOT_MANIFEST_SIZE_LIMIT_CONF_KEY = "snapshot.manifest.size.limit";
    public static final String DATA_MANIFEST_NAME = "data.manifest";
    private List<SnapshotProtos.SnapshotRegionManifest> regionManifests;
    private SnapshotProtos.SnapshotDescription desc;
    private TableDescriptor htd;
    private final ForeignExceptionSnare monitor;
    private final Configuration conf;
    private final Path workingDir;
    private final FileSystem rootFs;
    private final FileSystem workingDirFs;
    private int manifestSizeLimit;
    private final MonitoredTask statusTask;

    private SnapshotManifest(Configuration conf, FileSystem rootFs, Path workingDir, SnapshotProtos.SnapshotDescription desc, ForeignExceptionSnare monitor, MonitoredTask statusTask) throws IOException {
        this.monitor = monitor;
        this.desc = desc;
        this.workingDir = workingDir;
        this.conf = conf;
        this.rootFs = rootFs;
        this.statusTask = statusTask;
        this.workingDirFs = this.workingDir.getFileSystem(this.conf);
        this.manifestSizeLimit = conf.getInt(SNAPSHOT_MANIFEST_SIZE_LIMIT_CONF_KEY, 0x4000000);
    }

    public static SnapshotManifest create(Configuration conf, FileSystem fs, Path workingDir, SnapshotProtos.SnapshotDescription desc, ForeignExceptionSnare monitor) throws IOException {
        return SnapshotManifest.create(conf, fs, workingDir, desc, monitor, null);
    }

    public static SnapshotManifest create(Configuration conf, FileSystem fs, Path workingDir, SnapshotProtos.SnapshotDescription desc, ForeignExceptionSnare monitor, MonitoredTask statusTask) throws IOException {
        return new SnapshotManifest(conf, fs, workingDir, desc, monitor, statusTask);
    }

    public static SnapshotManifest open(Configuration conf, FileSystem fs, Path workingDir, SnapshotProtos.SnapshotDescription desc) throws IOException {
        SnapshotManifest manifest = new SnapshotManifest(conf, fs, workingDir, desc, null, null);
        manifest.load();
        return manifest;
    }

    public void addTableDescriptor(TableDescriptor htd) throws IOException {
        this.htd = htd;
    }

    private RegionVisitor createRegionVisitor(SnapshotProtos.SnapshotDescription desc) throws IOException {
        switch (SnapshotManifest.getSnapshotFormat(desc)) {
            case 0: {
                return new SnapshotManifestV1.ManifestBuilder(this.conf, this.rootFs, this.workingDir);
            }
            case 2: {
                return new SnapshotManifestV2.ManifestBuilder(this.conf, this.rootFs, this.workingDir);
            }
        }
        throw new CorruptedSnapshotException("Invalid Snapshot version: " + desc.getVersion(), ProtobufUtil.createSnapshotDesc(desc));
    }

    public void addMobRegion(RegionInfo regionInfo) throws IOException {
        RegionVisitor visitor = this.createRegionVisitor(this.desc);
        this.addMobRegion(regionInfo, visitor);
    }

    @VisibleForTesting
    protected void addMobRegion(RegionInfo regionInfo, RegionVisitor visitor) throws IOException {
        String snapshotName = this.desc.getName();
        LOG.debug("Storing mob region '" + regionInfo + "' region-info for snapshot=" + snapshotName);
        Object regionData = visitor.regionOpen(regionInfo);
        this.monitor.rethrowException();
        LOG.debug("Creating references for mob files");
        Path mobRegionPath = MobUtils.getMobRegionPath(this.conf, regionInfo.getTable());
        for (ColumnFamilyDescriptor hcd : this.htd.getColumnFamilies()) {
            if (!hcd.isMobEnabled()) continue;
            Object familyData = visitor.familyOpen(regionData, hcd.getName());
            this.monitor.rethrowException();
            Path storePath = MobUtils.getMobFamilyPath(mobRegionPath, hcd.getNameAsString());
            List<StoreFileInfo> storeFiles = this.getStoreFiles(storePath);
            if (storeFiles == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("No mob files under family: " + hcd.getNameAsString());
                continue;
            }
            this.addReferenceFiles(visitor, regionData, familyData, storeFiles, true);
            visitor.familyClose(regionData, familyData);
        }
        visitor.regionClose(regionData);
    }

    public void addRegion(HRegion region) throws IOException {
        RegionVisitor visitor = this.createRegionVisitor(this.desc);
        this.addRegion(region, visitor);
    }

    @VisibleForTesting
    protected void addRegion(HRegion region, RegionVisitor visitor) throws IOException {
        String snapshotName = this.desc.getName();
        LOG.debug("Storing '" + region + "' region-info for snapshot=" + snapshotName);
        Object regionData = visitor.regionOpen(region.getRegionInfo());
        this.monitor.rethrowException();
        LOG.debug("Creating references for hfiles");
        for (HStore store : region.getStores()) {
            Object familyData = visitor.familyOpen(regionData, store.getColumnFamilyDescriptor().getName());
            this.monitor.rethrowException();
            ArrayList<HStoreFile> storeFiles = new ArrayList<HStoreFile>(store.getStorefiles());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding snapshot references for " + storeFiles + " hfiles");
            }
            int sz = storeFiles.size();
            for (int i = 0; i < sz; ++i) {
                HStoreFile storeFile = (HStoreFile)storeFiles.get(i);
                this.monitor.rethrowException();
                LOG.debug("Adding reference for file (" + (i + 1) + "/" + sz + "): " + storeFile.getPath() + " for snapshot=" + snapshotName);
                visitor.storeFile(regionData, familyData, storeFile.getFileInfo());
            }
            visitor.familyClose(regionData, familyData);
        }
        visitor.regionClose(regionData);
    }

    public void addRegion(Path tableDir, RegionInfo regionInfo) throws IOException {
        RegionVisitor visitor = this.createRegionVisitor(this.desc);
        this.addRegion(tableDir, regionInfo, visitor);
    }

    @VisibleForTesting
    protected void addRegion(Path tableDir, RegionInfo regionInfo, RegionVisitor visitor) throws IOException {
        block6: {
            boolean isMobRegion = MobUtils.isMobRegionInfo(regionInfo);
            try {
                Path baseDir = tableDir;
                if (isMobRegion) {
                    baseDir = FSUtils.getTableDir(MobUtils.getMobHome(this.conf), regionInfo.getTable());
                }
                HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(this.conf, this.rootFs, baseDir, regionInfo, true);
                this.monitor.rethrowException();
                LOG.debug("Storing region-info for snapshot.");
                Object regionData = visitor.regionOpen(regionInfo);
                this.monitor.rethrowException();
                LOG.debug("Creating references for hfiles");
                Collection<String> familyNames = regionFs.getFamilies();
                if (familyNames != null) {
                    for (String familyName : familyNames) {
                        Object familyData = visitor.familyOpen(regionData, Bytes.toBytes(familyName));
                        this.monitor.rethrowException();
                        Collection<StoreFileInfo> storeFiles = regionFs.getStoreFiles(familyName);
                        if (storeFiles == null) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("No files under family: " + familyName);
                            continue;
                        }
                        this.addReferenceFiles(visitor, regionData, familyData, storeFiles, false);
                        visitor.familyClose(regionData, familyData);
                    }
                }
                visitor.regionClose(regionData);
            }
            catch (IOException e) {
                if (isMobRegion) break block6;
                throw e;
            }
        }
    }

    private List<StoreFileInfo> getStoreFiles(Path storeDir) throws IOException {
        FileStatus[] stats = FSUtils.listStatus(this.rootFs, storeDir);
        if (stats == null) {
            return null;
        }
        ArrayList<StoreFileInfo> storeFiles = new ArrayList<StoreFileInfo>(stats.length);
        for (int i = 0; i < stats.length; ++i) {
            storeFiles.add(new StoreFileInfo(this.conf, this.rootFs, stats[i]));
        }
        return storeFiles;
    }

    private void addReferenceFiles(RegionVisitor visitor, Object regionData, Object familyData, Collection<StoreFileInfo> storeFiles, boolean isMob) throws IOException {
        String fileType;
        String string = fileType = isMob ? "mob file" : "hfile";
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Adding snapshot references for %s %ss", storeFiles, fileType));
        }
        int i = 0;
        int sz = storeFiles.size();
        for (StoreFileInfo storeFile : storeFiles) {
            this.monitor.rethrowException();
            LOG.debug(String.format("Adding reference for %s (%d/%d): %s", fileType, ++i, sz, storeFile.getPath()));
            visitor.storeFile(regionData, familyData, storeFile);
        }
    }

    private void load() throws IOException {
        switch (SnapshotManifest.getSnapshotFormat(this.desc)) {
            case 0: {
                this.htd = FSTableDescriptors.getTableDescriptorFromFs(this.workingDirFs, this.workingDir);
                ThreadPoolExecutor tpool = this.createExecutor("SnapshotManifestLoader");
                try {
                    this.regionManifests = SnapshotManifestV1.loadRegionManifests(this.conf, tpool, this.rootFs, this.workingDir, this.desc);
                    break;
                }
                finally {
                    tpool.shutdown();
                }
            }
            case 2: {
                List<SnapshotProtos.SnapshotRegionManifest> v2Regions;
                List<SnapshotProtos.SnapshotRegionManifest> v1Regions;
                SnapshotProtos.SnapshotDataManifest dataManifest = this.readDataManifest();
                if (dataManifest != null) {
                    this.htd = ProtobufUtil.toTableDescriptor(dataManifest.getTableSchema());
                    this.regionManifests = dataManifest.getRegionManifestsList();
                    break;
                }
                ThreadPoolExecutor tpool = this.createExecutor("SnapshotManifestLoader");
                try {
                    v1Regions = SnapshotManifestV1.loadRegionManifests(this.conf, tpool, this.rootFs, this.workingDir, this.desc);
                    v2Regions = SnapshotManifestV2.loadRegionManifests(this.conf, tpool, this.rootFs, this.workingDir, this.desc, this.manifestSizeLimit);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new CorruptedSnapshotException("unable to parse region manifest " + e.getMessage(), e);
                }
                finally {
                    tpool.shutdown();
                }
                if (v1Regions != null && v2Regions != null) {
                    this.regionManifests = new ArrayList<SnapshotProtos.SnapshotRegionManifest>(v1Regions.size() + v2Regions.size());
                    this.regionManifests.addAll(v1Regions);
                    this.regionManifests.addAll(v2Regions);
                    break;
                }
                if (v1Regions != null) {
                    this.regionManifests = v1Regions;
                    break;
                }
                this.regionManifests = v2Regions;
                break;
            }
            default: {
                throw new CorruptedSnapshotException("Invalid Snapshot version: " + this.desc.getVersion(), ProtobufUtil.createSnapshotDesc(this.desc));
            }
        }
    }

    public Path getSnapshotDir() {
        return this.workingDir;
    }

    public SnapshotProtos.SnapshotDescription getSnapshotDescription() {
        return this.desc;
    }

    public TableDescriptor getTableDescriptor() {
        return this.htd;
    }

    public List<SnapshotProtos.SnapshotRegionManifest> getRegionManifests() {
        return this.regionManifests;
    }

    private void setStatusMsg(String msg) {
        if (this.statusTask != null) {
            this.statusTask.setStatus(msg);
        }
    }

    public Map<String, SnapshotProtos.SnapshotRegionManifest> getRegionManifestsMap() {
        if (this.regionManifests == null || this.regionManifests.isEmpty()) {
            return null;
        }
        HashMap<String, SnapshotProtos.SnapshotRegionManifest> regionsMap = new HashMap<String, SnapshotProtos.SnapshotRegionManifest>(this.regionManifests.size());
        for (SnapshotProtos.SnapshotRegionManifest manifest : this.regionManifests) {
            String regionName = SnapshotManifest.getRegionNameFromManifest(manifest);
            regionsMap.put(regionName, manifest);
        }
        return regionsMap;
    }

    public void consolidate() throws IOException {
        if (SnapshotManifest.getSnapshotFormat(this.desc) == 0) {
            Path rootDir = FSUtils.getRootDir(this.conf);
            LOG.info("Using old Snapshot Format");
            new FSTableDescriptors(this.conf, this.workingDirFs, rootDir).createTableDescriptorForTableDirectory(this.workingDir, this.htd, false);
        } else {
            LOG.debug("Convert to Single Snapshot Manifest for {}", (Object)this.desc.getName());
            this.convertToV2SingleManifest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToV2SingleManifest() throws IOException {
        ThreadPoolExecutor tpool = this.createExecutor("SnapshotManifestLoader");
        this.setStatusMsg("Loading Region manifests for " + this.desc.getName());
        try {
            List<SnapshotProtos.SnapshotRegionManifest> v1Regions = SnapshotManifestV1.loadRegionManifests(this.conf, tpool, this.workingDirFs, this.workingDir, this.desc);
            List<SnapshotProtos.SnapshotRegionManifest> v2Regions = SnapshotManifestV2.loadRegionManifests(this.conf, tpool, this.workingDirFs, this.workingDir, this.desc, this.manifestSizeLimit);
            SnapshotProtos.SnapshotDataManifest.Builder dataManifestBuilder = SnapshotProtos.SnapshotDataManifest.newBuilder();
            dataManifestBuilder.setTableSchema(ProtobufUtil.toTableSchema(this.htd));
            if (v1Regions != null && v1Regions.size() > 0) {
                dataManifestBuilder.addAllRegionManifests(v1Regions);
            }
            if (v2Regions != null && v2Regions.size() > 0) {
                dataManifestBuilder.addAllRegionManifests(v2Regions);
            }
            this.setStatusMsg("Writing data manifest for " + this.desc.getName());
            SnapshotProtos.SnapshotDataManifest dataManifest = dataManifestBuilder.build();
            this.writeDataManifest(dataManifest);
            this.regionManifests = dataManifest.getRegionManifestsList();
            int totalDeletes = 0;
            ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(tpool);
            if (v1Regions != null) {
                for (SnapshotProtos.SnapshotRegionManifest regionManifest : v1Regions) {
                    ++totalDeletes;
                    completionService.submit(() -> {
                        SnapshotManifestV1.deleteRegionManifest(this.workingDirFs, this.workingDir, regionManifest);
                        return null;
                    });
                }
            }
            if (v2Regions != null) {
                for (SnapshotProtos.SnapshotRegionManifest regionManifest : v2Regions) {
                    ++totalDeletes;
                    completionService.submit(() -> {
                        SnapshotManifestV2.deleteRegionManifest(this.workingDirFs, this.workingDir, regionManifest);
                        return null;
                    });
                }
            }
            for (int i = 0; i < totalDeletes; ++i) {
                try {
                    completionService.take().get();
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new InterruptedIOException(ie.getMessage());
                }
                catch (ExecutionException e) {
                    throw new IOException("Error deleting region manifests", e.getCause());
                }
            }
        }
        finally {
            tpool.shutdown();
        }
    }

    private void writeDataManifest(SnapshotProtos.SnapshotDataManifest manifest) throws IOException {
        try (FSDataOutputStream stream = this.workingDirFs.create(new Path(this.workingDir, DATA_MANIFEST_NAME));){
            manifest.writeTo((OutputStream)stream);
        }
    }

    private SnapshotProtos.SnapshotDataManifest readDataManifest() throws IOException {
        try (FSDataInputStream in = null;){
            in = this.workingDirFs.open(new Path(this.workingDir, DATA_MANIFEST_NAME));
            CodedInputStream cin = CodedInputStream.newInstance((InputStream)in);
            cin.setSizeLimit(this.manifestSizeLimit);
            SnapshotProtos.SnapshotDataManifest snapshotDataManifest = SnapshotProtos.SnapshotDataManifest.parseFrom(cin);
            return snapshotDataManifest;
        }
    }

    private ThreadPoolExecutor createExecutor(String name) {
        return SnapshotManifest.createExecutor(this.conf, name);
    }

    public static ThreadPoolExecutor createExecutor(Configuration conf, String name) {
        int maxThreads = conf.getInt("hbase.snapshot.thread.pool.max", 8);
        return Threads.getBoundedCachedThreadPool(maxThreads, 30L, TimeUnit.SECONDS, Threads.newDaemonThreadFactory(name));
    }

    static String getRegionNameFromManifest(SnapshotProtos.SnapshotRegionManifest manifest) {
        byte[] regionName = RegionInfo.createRegionName(ProtobufUtil.toTableName(manifest.getRegionInfo().getTableName()), manifest.getRegionInfo().getStartKey().toByteArray(), manifest.getRegionInfo().getRegionId(), true);
        return RegionInfo.encodeRegionName(regionName);
    }

    private static int getSnapshotFormat(SnapshotProtos.SnapshotDescription desc) {
        return desc.hasVersion() ? desc.getVersion() : 0;
    }

    static interface RegionVisitor<TRegion, TFamily> {
        public TRegion regionOpen(RegionInfo var1) throws IOException;

        public void regionClose(TRegion var1) throws IOException;

        public TFamily familyOpen(TRegion var1, byte[] var2) throws IOException;

        public void familyClose(TRegion var1, TFamily var2) throws IOException;

        public void storeFile(TRegion var1, TFamily var2, StoreFileInfo var3) throws IOException;
    }
}

