/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.random;

import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.random.CryptoRandom;
import org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.random.JavaCryptoRandom;
import org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.random.OpenSslCryptoRandom;
import org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.random.OsCryptoRandom;
import org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.utils.ReflectionUtils;
import org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.utils.Utils;

public class CryptoRandomFactory {
    public static final String DEVICE_FILE_PATH_KEY = "commons.crypto.secure.random.device.file.path";
    public static final String DEVICE_FILE_PATH_DEFAULT = "/dev/urandom";
    public static final String JAVA_ALGORITHM_KEY = "commons.crypto.secure.random.java.algorithm";
    public static final String JAVA_ALGORITHM_DEFAULT = "SHA1PRNG";
    public static final String CLASSES_KEY = "commons.crypto.secure.random.classes";
    private static final String CLASSES_DEFAULT = RandomProvider.OPENSSL.getClassName().concat(",").concat(RandomProvider.JAVA.getClassName());

    private CryptoRandomFactory() {
    }

    public static CryptoRandom getCryptoRandom() throws GeneralSecurityException {
        Properties properties = new Properties();
        return CryptoRandomFactory.getCryptoRandom(properties);
    }

    public static CryptoRandom getCryptoRandom(Properties props) throws GeneralSecurityException {
        List<String> names = Utils.splitClassNames(CryptoRandomFactory.getRandomClassString(props), ",");
        if (names.size() == 0) {
            throw new IllegalArgumentException("No classname(s) provided");
        }
        StringBuilder errorMessage = new StringBuilder();
        CryptoRandom random = null;
        Exception lastException = null;
        for (String klassName : names) {
            try {
                Class<?> klass = ReflectionUtils.getClassByName(klassName);
                random = (CryptoRandom)ReflectionUtils.newInstance(klass, props);
                if (random == null) continue;
                break;
            }
            catch (ClassCastException e) {
                lastException = e;
                errorMessage.append("Class: [" + klassName + "] is not a CryptoRandom.");
            }
            catch (ClassNotFoundException e) {
                lastException = e;
                errorMessage.append("CryptoRandom: [" + klassName + "] not found.");
            }
            catch (Exception e) {
                lastException = e;
                errorMessage.append("CryptoRandom: [" + klassName + "] failed with " + e.getMessage());
            }
        }
        if (random != null) {
            return random;
        }
        throw new GeneralSecurityException(errorMessage.toString(), lastException);
    }

    private static String getRandomClassString(Properties props) {
        String randomClassString = props.getProperty(CLASSES_KEY, CLASSES_DEFAULT);
        if (randomClassString.isEmpty()) {
            randomClassString = CLASSES_DEFAULT;
        }
        return randomClassString;
    }

    public static enum RandomProvider {
        OPENSSL(OpenSslCryptoRandom.class),
        JAVA(JavaCryptoRandom.class),
        OS(OsCryptoRandom.class);

        private final Class<? extends CryptoRandom> klass;
        private final String className;

        private RandomProvider(Class<? extends CryptoRandom> klass) {
            this.klass = klass;
            this.className = klass.getName();
        }

        public String getClassName() {
            return this.className;
        }

        public Class<? extends CryptoRandom> getImplClass() {
            return this.klass;
        }
    }
}

