/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.procedure2.LockStatus;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureDeque;
import org.apache.hadoop.hbase.procedure2.ProcedureScheduler;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class LockAndQueue
implements LockStatus {
    private final Function<Long, Procedure<?>> procedureRetriever;
    private final ProcedureDeque queue = new ProcedureDeque();
    private Procedure<?> exclusiveLockOwnerProcedure = null;
    private int sharedLock = 0;

    public LockAndQueue(Function<Long, Procedure<?>> procedureRetriever) {
        this.procedureRetriever = procedureRetriever;
    }

    @Override
    public boolean hasExclusiveLock() {
        return this.exclusiveLockOwnerProcedure != null;
    }

    @Override
    public boolean hasLockAccess(Procedure<?> proc) {
        if (this.exclusiveLockOwnerProcedure == null) {
            return false;
        }
        long lockOwnerId = this.exclusiveLockOwnerProcedure.getProcId();
        if (proc.getProcId() == lockOwnerId) {
            return true;
        }
        if (!proc.hasParent()) {
            return false;
        }
        if (proc.getRootProcId() == lockOwnerId) {
            return true;
        }
        Procedure<?> p = proc;
        do {
            if (p.getParentProcId() != lockOwnerId) continue;
            return true;
        } while ((p = this.procedureRetriever.apply(p.getParentProcId())) != null && p.hasParent());
        return false;
    }

    @Override
    public Procedure<?> getExclusiveLockOwnerProcedure() {
        return this.exclusiveLockOwnerProcedure;
    }

    @Override
    public int getSharedLockCount() {
        return this.sharedLock;
    }

    public boolean trySharedLock(Procedure<?> proc) {
        if (this.hasExclusiveLock() && !this.hasLockAccess(proc)) {
            return false;
        }
        ++this.sharedLock;
        return true;
    }

    public boolean releaseSharedLock() {
        return --this.sharedLock == 0 && !this.hasExclusiveLock();
    }

    public boolean tryExclusiveLock(Procedure<?> proc) {
        if (this.isLocked()) {
            return this.hasLockAccess(proc);
        }
        this.exclusiveLockOwnerProcedure = proc;
        return true;
    }

    public boolean releaseExclusiveLock(Procedure<?> proc) {
        if (this.exclusiveLockOwnerProcedure == null || this.exclusiveLockOwnerProcedure.getProcId() != proc.getProcId()) {
            return false;
        }
        this.exclusiveLockOwnerProcedure = null;
        return this.sharedLock == 0;
    }

    public boolean isWaitingQueueEmpty() {
        return this.queue.isEmpty();
    }

    public Procedure<?> removeFirst() {
        return (Procedure)this.queue.removeFirst();
    }

    public void addLast(Procedure<?> proc) {
        this.queue.addLast(proc);
    }

    public int wakeWaitingProcedures(ProcedureScheduler scheduler) {
        int count = this.queue.size();
        scheduler.addFront(this.queue.descendingIterator());
        this.queue.clear();
        return count;
    }

    public Stream<Procedure> filterWaitingQueue(Predicate<Procedure> predicate) {
        return this.queue.stream().filter(predicate);
    }

    public String toString() {
        return "exclusiveLockOwner=" + (this.hasExclusiveLock() ? Long.valueOf(this.getExclusiveLockProcIdOwner()) : "NONE") + ", sharedLockCount=" + this.getSharedLockCount() + ", waitingProcCount=" + this.queue.size();
    }
}

