/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class MasterSnapshotVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(MasterSnapshotVerifier.class);
    private SnapshotProtos.SnapshotDescription snapshot;
    private FileSystem workingDirFs;
    private TableName tableName;
    private MasterServices services;

    public MasterSnapshotVerifier(MasterServices services, SnapshotProtos.SnapshotDescription snapshot, FileSystem workingDirFs) {
        this.workingDirFs = workingDirFs;
        this.services = services;
        this.snapshot = snapshot;
        this.tableName = TableName.valueOf(snapshot.getTable());
    }

    public void verifySnapshot(Path snapshotDir, Set<String> snapshotServers) throws CorruptedSnapshotException, IOException {
        SnapshotManifest manifest = SnapshotManifest.open(this.services.getConfiguration(), this.workingDirFs, snapshotDir, this.snapshot);
        this.verifySnapshotDescription(snapshotDir);
        this.verifyTableInfo(manifest);
        this.verifyRegions(manifest);
    }

    private void verifySnapshotDescription(Path snapshotDir) throws CorruptedSnapshotException {
        SnapshotProtos.SnapshotDescription found = SnapshotDescriptionUtils.readSnapshotInfo(this.workingDirFs, snapshotDir);
        if (!this.snapshot.equals(found)) {
            throw new CorruptedSnapshotException("Snapshot read (" + found + ") doesn't equal snapshot we ran (" + this.snapshot + ").", ProtobufUtil.createSnapshotDesc(this.snapshot));
        }
    }

    private void verifyTableInfo(SnapshotManifest manifest) throws IOException {
        TableDescriptor htd = manifest.getTableDescriptor();
        if (htd == null) {
            throw new CorruptedSnapshotException("Missing Table Descriptor", ProtobufUtil.createSnapshotDesc(this.snapshot));
        }
        if (!htd.getTableName().getNameAsString().equals(this.snapshot.getTable())) {
            throw new CorruptedSnapshotException("Invalid Table Descriptor. Expected " + this.snapshot.getTable() + " name, got " + htd.getTableName().getNameAsString(), ProtobufUtil.createSnapshotDesc(this.snapshot));
        }
    }

    private void verifyRegions(SnapshotManifest manifest) throws IOException {
        int realRegionCount;
        List<RegionInfo> regions = TableName.META_TABLE_NAME.equals(this.tableName) ? MetaTableLocator.getMetaRegions(this.services.getZooKeeper()) : MetaTableAccessor.getTableRegions(this.services.getConnection(), this.tableName);
        RegionReplicaUtil.removeNonDefaultRegions(regions);
        Map<String, SnapshotProtos.SnapshotRegionManifest> regionManifests = manifest.getRegionManifestsMap();
        if (regionManifests == null) {
            String msg = "Snapshot " + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " looks empty";
            LOG.error(msg);
            throw new CorruptedSnapshotException(msg);
        }
        String errorMsg = "";
        boolean hasMobStore = false;
        if (regionManifests.get(MobUtils.getMobRegionInfo(this.tableName).getEncodedName()) != null) {
            hasMobStore = true;
        }
        int n = realRegionCount = hasMobStore ? regionManifests.size() - 1 : regionManifests.size();
        if (realRegionCount != regions.size()) {
            errorMsg = "Regions moved during the snapshot '" + ClientSnapshotDescriptionUtils.toString(this.snapshot) + "'. expected=" + regions.size() + " snapshotted=" + realRegionCount + ".";
            LOG.error(errorMsg);
        }
        for (RegionInfo region : regions) {
            SnapshotProtos.SnapshotRegionManifest regionManifest = regionManifests.get(region.getEncodedName());
            if (regionManifest == null) {
                String mesg = " No snapshot region directory found for region:" + region;
                if (errorMsg.isEmpty()) {
                    errorMsg = mesg;
                }
                LOG.error(mesg);
                continue;
            }
            this.verifyRegionInfo(region, regionManifest);
        }
        if (!errorMsg.isEmpty()) {
            throw new CorruptedSnapshotException(errorMsg);
        }
        SnapshotReferenceUtil.verifySnapshot(this.services.getConfiguration(), FSUtils.getRootDirFileSystem(this.services.getConfiguration()), manifest);
    }

    private void verifyRegionInfo(RegionInfo region, SnapshotProtos.SnapshotRegionManifest manifest) throws IOException {
        RegionInfo manifestRegionInfo = ProtobufUtil.toRegionInfo(manifest.getRegionInfo());
        if (RegionInfo.COMPARATOR.compare(region, manifestRegionInfo) != 0) {
            String msg = "Manifest region info " + manifestRegionInfo + "doesn't match expected region:" + region;
            throw new CorruptedSnapshotException(msg, ProtobufUtil.createSnapshotDesc(this.snapshot));
        }
    }
}

