/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;
import org.janusgraph.graphdb.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ConcurrentLRUCache<V> {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentLRUCache.class);
    private final NonBlockingHashMapLong<CacheEntry<Long, V>> map;
    private final int upperWaterMark;
    private final int lowerWaterMark;
    private final ReentrantLock markAndSweepLock = new ReentrantLock(true);
    private boolean isCleaning = false;
    private final boolean newThreadForCleanup;
    private volatile boolean isAlive = true;
    private final Stats stats = new Stats();
    private final int acceptableWaterMark;
    private long oldestEntry = 0L;
    private final EvictionListener<V> evictionListener;
    private CleanupThread cleanupThread;
    private boolean isDestroyed = false;

    public ConcurrentLRUCache(int upperWaterMark, int lowerWaterMark, int acceptableWatermark, int initialSize, boolean runCleanupThread, boolean runNewThreadForCleanup, EvictionListener<V> evictionListener) {
        if (upperWaterMark < 1) {
            throw new IllegalArgumentException("upperWaterMark must be > 0");
        }
        if (lowerWaterMark >= upperWaterMark) {
            throw new IllegalArgumentException("lowerWaterMark must be  < upperWaterMark");
        }
        this.map = new NonBlockingHashMapLong(initialSize);
        this.newThreadForCleanup = runNewThreadForCleanup;
        this.upperWaterMark = upperWaterMark;
        this.lowerWaterMark = lowerWaterMark;
        this.acceptableWaterMark = acceptableWatermark;
        this.evictionListener = evictionListener;
        if (runCleanupThread) {
            this.cleanupThread = new CleanupThread(this);
            this.cleanupThread.start();
        }
    }

    public ConcurrentLRUCache(int size, int lowerWatermark) {
        this(size, lowerWatermark, (int)Math.floor((lowerWatermark + size) / 2), (int)Math.ceil(0.75 * (double)size), false, false, null);
    }

    public void setAlive(boolean live) {
        this.isAlive = live;
    }

    public V get(Long key) {
        CacheEntry e = (CacheEntry)this.map.get((Object)key);
        if (e == null) {
            if (this.isAlive) {
                this.stats.missCounter.incrementAndGet();
            }
            return null;
        }
        if (this.isAlive) {
            e.lastAccessed = this.stats.accessCounter.incrementAndGet();
        }
        return e.value;
    }

    public boolean containsKey(Long key) {
        return this.map.containsKey((Object)key);
    }

    public V remove(Long key) {
        CacheEntry cacheEntry = (CacheEntry)this.map.remove((Object)key);
        if (cacheEntry != null) {
            this.stats.size.decrementAndGet();
            return cacheEntry.value;
        }
        return null;
    }

    public V putIfAbsent(Long key, V val) {
        if (val == null) {
            return null;
        }
        CacheEntry<Long, V> e = new CacheEntry<Long, V>(key, val, this.stats.accessCounter.incrementAndGet());
        CacheEntry oldCacheEntry = (CacheEntry)this.map.putIfAbsent(key, e);
        if (oldCacheEntry == null) {
            this.doCacheMaintenanceOnPut(oldCacheEntry);
        }
        return oldCacheEntry == null ? null : (V)oldCacheEntry.value;
    }

    public V put(Long key, V val) {
        if (val == null) {
            return null;
        }
        CacheEntry<Long, V> e = new CacheEntry<Long, V>(key, val, this.stats.accessCounter.incrementAndGet());
        CacheEntry oldCacheEntry = (CacheEntry)this.map.put(key, e);
        this.doCacheMaintenanceOnPut(oldCacheEntry);
        return oldCacheEntry == null ? null : (V)oldCacheEntry.value;
    }

    private void doCacheMaintenanceOnPut(CacheEntry<Long, V> oldCacheEntry) {
        int currentSize = oldCacheEntry == null ? this.stats.size.incrementAndGet() : this.stats.size.get();
        if (this.isAlive) {
            this.stats.putCounter.incrementAndGet();
        } else {
            this.stats.nonLivePutCounter.incrementAndGet();
        }
        if (currentSize > this.upperWaterMark && !this.isCleaning) {
            if (this.newThreadForCleanup) {
                new Thread(this::markAndSweep).start();
            } else if (this.cleanupThread != null) {
                this.cleanupThread.wakeThread();
            } else {
                this.markAndSweep();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAndSweep() {
        if (!this.markAndSweepLock.tryLock()) {
            return;
        }
        try {
            long oldestEntry = this.oldestEntry;
            this.isCleaning = true;
            this.oldestEntry = oldestEntry;
            long timeCurrent = this.stats.accessCounter.get();
            int sz = this.stats.size.get();
            int numRemoved = 0;
            int numLongept = 0;
            long newestEntry = timeCurrent;
            long newNewestEntry = -1L;
            long newOldestEntry = Long.MAX_VALUE;
            int wantToLongeep = this.lowerWaterMark;
            int wantToRemove = sz - this.lowerWaterMark;
            CacheEntry[] entrySet = new CacheEntry[sz];
            int eSize = 0;
            for (CacheEntry ce : this.map.values()) {
                ce.lastAccessedCopy = ce.lastAccessed;
                long thisEntry = ce.lastAccessedCopy;
                if (thisEntry > newestEntry - (long)wantToLongeep) {
                    ++numLongept;
                    newOldestEntry = Math.min(thisEntry, newOldestEntry);
                    continue;
                }
                if (thisEntry < oldestEntry + (long)wantToRemove) {
                    this.evictEntry((Long)ce.key);
                    ++numRemoved;
                    continue;
                }
                if (eSize >= entrySet.length - 1) continue;
                entrySet[eSize++] = ce;
                newNewestEntry = Math.max(thisEntry, newNewestEntry);
                newOldestEntry = Math.min(thisEntry, newOldestEntry);
            }
            int numPasses = 1;
            while (sz - numRemoved > this.acceptableWaterMark && --numPasses >= 0) {
                oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
                newOldestEntry = Long.MAX_VALUE;
                newestEntry = newNewestEntry;
                newNewestEntry = -1L;
                wantToLongeep = this.lowerWaterMark - numLongept;
                wantToRemove = sz - this.lowerWaterMark - numRemoved;
                for (int i = eSize - 1; i >= 0; --i) {
                    CacheEntry ce = entrySet[i];
                    long thisEntry = ce.lastAccessedCopy;
                    if (thisEntry > newestEntry - (long)wantToLongeep) {
                        ++numLongept;
                        entrySet[i] = entrySet[eSize - 1];
                        --eSize;
                        newOldestEntry = Math.min(thisEntry, newOldestEntry);
                        continue;
                    }
                    if (thisEntry < oldestEntry + (long)wantToRemove) {
                        this.evictEntry((Long)ce.key);
                        ++numRemoved;
                        entrySet[i] = entrySet[eSize - 1];
                        --eSize;
                        continue;
                    }
                    newNewestEntry = Math.max(thisEntry, newNewestEntry);
                    newOldestEntry = Math.min(thisEntry, newOldestEntry);
                }
            }
            if (sz - numRemoved > this.acceptableWaterMark) {
                oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
                newOldestEntry = Long.MAX_VALUE;
                newestEntry = newNewestEntry;
                wantToLongeep = this.lowerWaterMark - numLongept;
                wantToRemove = sz - this.lowerWaterMark - numRemoved;
                PQueue queue = new PQueue(wantToRemove);
                for (int i = eSize - 1; i >= 0; --i) {
                    CacheEntry ce = entrySet[i];
                    long thisEntry = ce.lastAccessedCopy;
                    if (thisEntry > newestEntry - (long)wantToLongeep) {
                        ++numLongept;
                        newOldestEntry = Math.min(thisEntry, newOldestEntry);
                        continue;
                    }
                    if (thisEntry < oldestEntry + (long)wantToRemove) {
                        this.evictEntry((Long)ce.key);
                        ++numRemoved;
                        continue;
                    }
                    queue.myMaxSize = sz - this.lowerWaterMark - numRemoved;
                    while (queue.size() > queue.myMaxSize && queue.size() > 0) {
                        CacheEntry otherEntry = (CacheEntry)queue.pop();
                        newOldestEntry = Math.min(otherEntry.lastAccessedCopy, newOldestEntry);
                    }
                    if (queue.myMaxSize <= 0) break;
                    CacheEntry o = queue.myInsertWithOverflow(ce);
                    if (o == null) continue;
                    newOldestEntry = Math.min(o.lastAccessedCopy, newOldestEntry);
                }
                for (CacheEntry ce : queue.getValues()) {
                    if (ce == null) continue;
                    this.evictEntry((Long)ce.key);
                    ++numRemoved;
                }
            }
            this.oldestEntry = oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
        }
        finally {
            this.isCleaning = false;
            this.markAndSweepLock.unlock();
        }
    }

    private void evictEntry(Long key) {
        CacheEntry o = (CacheEntry)this.map.remove((Object)key);
        if (o == null) {
            return;
        }
        this.stats.size.decrementAndGet();
        this.stats.evictionCounter.incrementAndGet();
        if (this.evictionListener != null) {
            this.evictionListener.evictedEntry((Long)o.key, o.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, V> getOldestAccessedItems(int n) {
        LinkedHashMap result = new LinkedHashMap();
        if (n <= 0) {
            return result;
        }
        TreeSet<CacheEntry> tree = new TreeSet<CacheEntry>();
        this.markAndSweepLock.lock();
        try {
            for (Map.Entry entry : this.map.entrySet()) {
                CacheEntry ce = (CacheEntry)entry.getValue();
                ce.lastAccessedCopy = ce.lastAccessed;
                if (tree.size() < n) {
                    tree.add(ce);
                    continue;
                }
                if (ce.lastAccessedCopy >= ((CacheEntry)tree.first()).lastAccessedCopy) continue;
                tree.remove(tree.first());
                tree.add(ce);
            }
        }
        finally {
            this.markAndSweepLock.unlock();
        }
        for (CacheEntry e : tree) {
            result.put(e.key, e.value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, V> getLatestAccessedItems(int n) {
        LinkedHashMap result = new LinkedHashMap();
        if (n <= 0) {
            return result;
        }
        TreeSet<CacheEntry> tree = new TreeSet<CacheEntry>();
        this.markAndSweepLock.lock();
        try {
            for (Map.Entry entry : this.map.entrySet()) {
                CacheEntry ce = (CacheEntry)entry.getValue();
                ce.lastAccessedCopy = ce.lastAccessed;
                if (tree.size() < n) {
                    tree.add(ce);
                    continue;
                }
                if (ce.lastAccessedCopy <= ((CacheEntry)tree.last()).lastAccessedCopy) continue;
                tree.remove(tree.last());
                tree.add(ce);
            }
        }
        finally {
            this.markAndSweepLock.unlock();
        }
        for (CacheEntry e : tree) {
            result.put(e.key, e.value);
        }
        return result;
    }

    public int size() {
        return this.stats.size.get();
    }

    public void clear() {
        this.map.clear();
    }

    public Map<Long, CacheEntry<Long, V>> getMap() {
        return this.map;
    }

    public void destroy() {
        try {
            if (this.cleanupThread != null) {
                this.cleanupThread.stopThread();
            }
        }
        finally {
            this.isDestroyed = true;
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isDestroyed) {
                log.error("ConcurrentLRUCache was not destroyed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.destroy();
            }
        }
        finally {
            super.finalize();
        }
    }

    private static class CleanupThread
    extends Thread {
        private final WeakReference<ConcurrentLRUCache> cache;
        private boolean stop = false;

        public CleanupThread(ConcurrentLRUCache c) {
            this.cache = new WeakReference<ConcurrentLRUCache>(c);
            this.setDaemon(true);
            this.setName("ConcurrentLRUCleaner-" + this.getId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ConcurrentLRUCache c;
                CleanupThread cleanupThread = this;
                synchronized (cleanupThread) {
                    if (this.stop) {
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.stop || (c = (ConcurrentLRUCache)this.cache.get()) == null) break;
                c.markAndSweep();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeThread() {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopThread() {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.stop = true;
                this.notify();
            }
        }
    }

    public static interface EvictionListener<V> {
        public void evictedEntry(Long var1, V var2);
    }

    public static class Stats {
        private final AtomicLong accessCounter = new AtomicLong(0L);
        private final AtomicLong putCounter = new AtomicLong(0L);
        private final AtomicLong nonLivePutCounter = new AtomicLong(0L);
        private final AtomicLong missCounter = new AtomicLong();
        private final AtomicInteger size = new AtomicInteger();
        private final AtomicLong evictionCounter = new AtomicLong();

        public long getCumulativeLookups() {
            return this.accessCounter.get() - this.putCounter.get() - this.nonLivePutCounter.get() + this.missCounter.get();
        }

        public long getCumulativeHits() {
            return this.accessCounter.get() - this.putCounter.get() - this.nonLivePutCounter.get();
        }

        public long getCumulativePuts() {
            return this.putCounter.get();
        }

        public long getCumulativeEvictions() {
            return this.evictionCounter.get();
        }

        public int getCurrentSize() {
            return this.size.get();
        }

        public long getCumulativeNonLivePuts() {
            return this.nonLivePutCounter.get();
        }

        public long getCumulativeMisses() {
            return this.missCounter.get();
        }

        public void add(Stats other) {
            this.accessCounter.addAndGet(other.accessCounter.get());
            this.putCounter.addAndGet(other.putCounter.get());
            this.nonLivePutCounter.addAndGet(other.nonLivePutCounter.get());
            this.missCounter.addAndGet(other.missCounter.get());
            this.evictionCounter.addAndGet(other.evictionCounter.get());
            this.size.set(Math.max(this.size.get(), other.size.get()));
        }
    }

    private static class CacheEntry<Long, V>
    implements Comparable<CacheEntry<Long, V>> {
        final Long key;
        final V value;
        volatile long lastAccessed;
        long lastAccessedCopy = 0L;

        public CacheEntry(Long key, V value, long lastAccessed) {
            this.key = key;
            this.value = value;
            this.lastAccessed = lastAccessed;
        }

        public void setLastAccessed(long lastAccessed) {
            this.lastAccessed = lastAccessed;
        }

        @Override
        public int compareTo(CacheEntry<Long, V> that) {
            if (this.lastAccessedCopy == that.lastAccessedCopy) {
                return 0;
            }
            return this.lastAccessedCopy < that.lastAccessedCopy ? 1 : -1;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public String toString() {
            return "key: " + this.key + " value: " + this.value + " lastAccessed:" + this.lastAccessed;
        }
    }

    private static class PQueue<Long, V>
    extends PriorityQueue<CacheEntry<Long, V>> {
        int myMaxSize;
        final Object[] heap = this.getHeapArray();

        PQueue(int maxSz) {
            super(maxSz);
            this.myMaxSize = maxSz;
        }

        Iterable<CacheEntry<Long, V>> getValues() {
            return Collections.unmodifiableCollection(Arrays.asList(this.heap));
        }

        @Override
        protected boolean lessThan(CacheEntry a, CacheEntry b) {
            return b.lastAccessedCopy < a.lastAccessedCopy;
        }

        public CacheEntry<Long, V> myInsertWithOverflow(CacheEntry<Long, V> element) {
            if (this.size() < this.myMaxSize) {
                this.add(element);
                return null;
            }
            if (this.size() > 0 && !this.lessThan(element, (CacheEntry)this.heap[1])) {
                CacheEntry ret = (CacheEntry)this.heap[1];
                this.heap[1] = element;
                this.updateTop();
                return ret;
            }
            return element;
        }
    }
}

