/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.indexcache;

import java.util.Collections;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.transaction.indexcache.IndexCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyIndexCache
implements IndexCache {
    private static final EmptyIndexCache INSTANCE = new EmptyIndexCache();
    private static final Logger log = LoggerFactory.getLogger(EmptyIndexCache.class);

    private EmptyIndexCache() {
    }

    public static EmptyIndexCache getInstance() {
        return INSTANCE;
    }

    private void logWarning() {
        log.warn("Index cache is already closed");
    }

    @Override
    public void add(JanusGraphVertexProperty property) {
        this.logWarning();
    }

    @Override
    public void remove(JanusGraphVertexProperty property) {
        this.logWarning();
    }

    @Override
    public Iterable<JanusGraphVertexProperty> get(Object value, PropertyKey key) {
        this.logWarning();
        return Collections.emptyList();
    }

    @Override
    public void close() {
    }
}

