/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NoneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IdStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.query.JanusGraphPredicateUtils;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.query.index.IndexSelectionUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.AdjacentVertexOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphLocalQueryOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphStepStrategy;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public class AdjacentVertexHasUniquePropertyOptimizerStrategy
extends AdjacentVertexOptimizerStrategy<HasStep<?>> {
    private static final AdjacentVertexHasUniquePropertyOptimizerStrategy INSTANCE = new AdjacentVertexHasUniquePropertyOptimizerStrategy();

    private AdjacentVertexHasUniquePropertyOptimizerStrategy() {
    }

    public static AdjacentVertexHasUniquePropertyOptimizerStrategy instance() {
        return INSTANCE;
    }

    @Override
    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPost() {
        HashSet<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> postStrategies = new HashSet<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>>();
        postStrategies.add(JanusGraphStepStrategy.class);
        postStrategies.add(JanusGraphLocalQueryOptimizerStrategy.class);
        return postStrategies;
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (TraversalHelper.onGraphComputer(traversal) || !traversal.getGraph().isPresent()) {
            return;
        }
        StandardJanusGraph janusGraph = JanusGraphTraversalUtil.getJanusGraph(traversal);
        if (janusGraph == null) {
            return;
        }
        if (!janusGraph.getConfiguration().optimizerBackendAccess()) {
            return;
        }
        TraversalHelper.getStepsOfClass(HasStep.class, traversal).forEach(this::optimizeStep);
    }

    @Override
    protected boolean isValidStep(HasStep<?> step) {
        StandardJanusGraphTx tx = (StandardJanusGraphTx)JanusGraphTraversalUtil.getTx(step.getTraversal());
        List givenKeys = step.getHasContainers().stream().map(HasContainer::getKey).collect(Collectors.toList());
        List constraints = step.getHasContainers().stream().filter(hc -> hc.getBiPredicate() == Compare.eq).map(hc -> new PredicateCondition(hc.getKey(), JanusGraphPredicateUtils.convert(hc.getBiPredicate()), hc.getValue())).filter(pc -> tx.validDataType(pc.getValue().getClass())).collect(Collectors.toList());
        And<JanusGraphElement> conditions = QueryUtil.constraints2QNF(tx, constraints);
        return IndexSelectionUtil.existsMatchingIndex(conditions, indexType -> indexType.isCompositeIndex() && ((CompositeIndexType)indexType).getCardinality() == Cardinality.SINGLE && IndexSelectionUtil.isIndexSatisfiedByGivenKeys(indexType, givenKeys));
    }

    private Traversal.Admin<?, Long> generateFilter(Traversal.Admin<?, ?> traversal, HasStep<?> originalStep) {
        GraphTraversal.Admin filterTraversal = new DefaultGraphTraversal((Graph)traversal.getGraph().get()).addStep((Step)new GraphStep(traversal, Vertex.class, true, new Object[0]));
        filterTraversal.addStep(originalStep);
        filterTraversal.addStep((Step)new IdStep((Traversal.Admin)filterTraversal));
        return filterTraversal;
    }

    @Override
    protected FilterStep<Edge> makeFilterByAdjacentIdStep(Traversal.Admin<?, ?> traversal, HasStep<?> originalStep) {
        Traversal.Admin<?, Long> filterTraversal = this.generateFilter(traversal, originalStep);
        if (filterTraversal.hasNext()) {
            HasContainer hc = new HasContainer(ImplicitKey.ADJACENT_ID.name(), P.eq((Object)filterTraversal.next()));
            return new HasStep(traversal, new HasContainer[]{hc});
        }
        return new NoneStep(traversal);
    }
}

