/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot;

import com.oracle.truffle.api.CompilerDirectives;
import java.lang.invoke.MethodHandle;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.truffle.runtime.GraalFastThreadLocal;
import org.graalvm.compiler.truffle.runtime.hotspot.AbstractHotSpotTruffleRuntime;

final class HotSpotFastThreadLocal
extends GraalFastThreadLocal {
    static final HotSpotFastThreadLocal SINGLETON = new HotSpotFastThreadLocal();
    static final MethodHandle FALLBACK_SET = AbstractHotSpotTruffleRuntime.getRuntime().getSetThreadLocalObject();
    static final MethodHandle FALLBACK_GET = AbstractHotSpotTruffleRuntime.getRuntime().getGetThreadLocalObject();
    private static final int DEBUG_STEPPING_DETECTION_THRESHOLD = 10;
    private static final ThreadLocal<MutableInt> fallbackThreadLocal = new ThreadLocal<MutableInt>(){

        @Override
        protected MutableInt initialValue() {
            return new MutableInt();
        }
    };

    HotSpotFastThreadLocal() {
    }

    @Override
    public void set(Object[] data) {
        HotSpotFastThreadLocal.setJVMCIReservedReference(data);
    }

    @Override
    public Object[] get() {
        return HotSpotFastThreadLocal.getJVMCIReservedReference();
    }

    static Object[] getJVMCIReservedReference() {
        boolean waitForInstall;
        boolean bl = waitForInstall = FALLBACK_GET == null;
        if (AbstractHotSpotTruffleRuntime.getRuntime().bypassedReservedOop(waitForInstall)) {
            if (waitForInstall) {
                return HotSpotFastThreadLocal.getJVMCIReservedReferenceNoFallback();
            }
            try {
                return (Object[])FALLBACK_GET.invokeExact(HotSpotJVMCIRuntime.runtime(), 0);
            }
            catch (Throwable e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return null;
    }

    private static Object[] getJVMCIReservedReferenceNoFallback() {
        MutableInt value = fallbackThreadLocal.get();
        if (value.value > 10) {
            throw HotSpotFastThreadLocal.failDebugStepping();
        }
        ++value.value;
        try {
            Object[] objectArray = SINGLETON.get();
            return objectArray;
        }
        finally {
            --value.value;
        }
    }

    static void setJVMCIReservedReference(Object[] v) {
        boolean waitForInstall;
        boolean bl = waitForInstall = FALLBACK_SET == null;
        if (AbstractHotSpotTruffleRuntime.getRuntime().bypassedReservedOop(waitForInstall)) {
            if (waitForInstall) {
                HotSpotFastThreadLocal.setJVMCIReservedReferenceNoFallback(v);
            } else {
                try {
                    FALLBACK_SET.invokeExact(HotSpotJVMCIRuntime.runtime(), 0, v);
                }
                catch (Throwable e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
        } else {
            throw CompilerDirectives.shouldNotReachHere((String)"Bypassed reserved oop without compiler initialization triggered.");
        }
    }

    private static void setJVMCIReservedReferenceNoFallback(Object[] v) {
        MutableInt invocations = fallbackThreadLocal.get();
        if (invocations.value > 10) {
            throw HotSpotFastThreadLocal.failDebugStepping();
        }
        ++invocations.value;
        try {
            SINGLETON.set(v);
        }
        finally {
            --invocations.value;
        }
    }

    private static RuntimeException failDebugStepping() {
        throw new UnsupportedOperationException("Cannot step through the fast thread local with the debugger without JVMCI API fallback methods. Make sure the JVMCI version is up-to-date or switch to a runtime without Truffle compilation for debugging to resolve this. Use -Dtruffle.TruffleRuntime=com.oracle.truffle.api.impl.DefaultTruffleRuntime to switch to a runtime without compilation. Remember to remove this option again after debugging.");
    }

    static final class MutableInt {
        int value;

        MutableInt() {
        }
    }
}

