/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.VectorizedMismatchForeignCalls;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public class VectorizedMismatchNode
extends PureFunctionStubIntrinsicNode {
    public static final NodeClass<VectorizedMismatchNode> TYPE = NodeClass.create(VectorizedMismatchNode.class);
    @Node.Input
    protected ValueNode arrayA;
    @Node.Input
    protected ValueNode arrayB;
    @Node.Input
    protected ValueNode length;
    @Node.Input
    protected ValueNode stride;

    public VectorizedMismatchNode(ValueNode arrayA, ValueNode arrayB, ValueNode length, ValueNode stride) {
        this(TYPE, arrayA, arrayB, length, stride, null);
    }

    public VectorizedMismatchNode(ValueNode arrayA, ValueNode arrayB, ValueNode length, ValueNode stride, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(TYPE, arrayA, arrayB, length, stride, runtimeCheckedCPUFeatures);
    }

    protected VectorizedMismatchNode(NodeClass<? extends VectorizedMismatchNode> c, ValueNode arrayA, ValueNode arrayB, ValueNode length, ValueNode stride, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(c, StampFactory.forKind(JavaKind.Int), runtimeCheckedCPUFeatures, LocationIdentity.ANY_LOCATION);
        this.arrayA = arrayA;
        this.arrayB = arrayB;
        this.length = length;
        this.stride = stride;
    }

    @Node.NodeIntrinsic
    @GenerateStub
    public static native int vectorizedMismatch(Pointer var0, Pointer var1, int var2, int var3);

    @Node.NodeIntrinsic
    public static native int vectorizedMismatch(Pointer var0, Pointer var1, int var2, int var3, @Node.ConstantNodeParameter EnumSet<?> var4);

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return VectorizedMismatchForeignCalls.STUB;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.arrayA, this.arrayB, this.length, this.stride};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitVectorizedMismatch(this.getRuntimeCheckedCPUFeatures(), gen.operand(this.arrayA), gen.operand(this.arrayB), gen.operand(this.length), gen.operand(this.stride)));
    }
}

