/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(nameTemplate="MathIntrinsic#{p#operation/s}", cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_1)
public final class UnaryMathIntrinsicNode
extends UnaryNode
implements ArithmeticLIRLowerable,
Lowerable {
    public static final NodeClass<UnaryMathIntrinsicNode> TYPE = NodeClass.create(UnaryMathIntrinsicNode.class);
    protected final UnaryOperation operation;

    public UnaryOperation getOperation() {
        return this.operation;
    }

    public static ValueNode create(ValueNode value, UnaryOperation op) {
        ValueNode c = UnaryMathIntrinsicNode.tryConstantFold(value, op);
        if (c != null) {
            return c;
        }
        return new UnaryMathIntrinsicNode(value, op);
    }

    protected static ValueNode tryConstantFold(ValueNode value, UnaryOperation op) {
        if (value.isConstant()) {
            return ConstantNode.forDouble(op.compute(value.asJavaConstant().asDouble()));
        }
        return null;
    }

    protected UnaryMathIntrinsicNode(ValueNode value, UnaryOperation op) {
        super(TYPE, op.computeStamp(value.stamp(NodeView.DEFAULT)), value);
        assert (value.stamp(NodeView.DEFAULT) instanceof FloatStamp && PrimitiveStamp.getBits(value.stamp(NodeView.DEFAULT)) == 64);
        this.operation = op;
    }

    @Override
    public Stamp foldStamp(Stamp valueStamp) {
        return this.getOperation().computeStamp(valueStamp);
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        Value result;
        Value input = nodeValueMap.operand(this.getValue());
        switch (this.getOperation()) {
            case LOG: {
                result = gen.emitMathLog(input, false);
                break;
            }
            case LOG10: {
                result = gen.emitMathLog(input, true);
                break;
            }
            case EXP: {
                result = gen.emitMathExp(input);
                break;
            }
            case SIN: {
                result = gen.emitMathSin(input);
                break;
            }
            case COS: {
                result = gen.emitMathCos(input);
                break;
            }
            case TAN: {
                result = gen.emitMathTan(input);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        nodeValueMap.setResult(this, result);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode c = UnaryMathIntrinsicNode.tryConstantFold(forValue, this.getOperation());
        if (c != null) {
            return c;
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native double compute(double var0, @Node.ConstantNodeParameter UnaryOperation var2);

    public static enum UnaryOperation {
        LOG(new ForeignCallSignature("arithmeticLog", Double.TYPE, Double.TYPE)),
        LOG10(new ForeignCallSignature("arithmeticLog10", Double.TYPE, Double.TYPE)),
        SIN(new ForeignCallSignature("arithmeticSin", Double.TYPE, Double.TYPE)),
        COS(new ForeignCallSignature("arithmeticCos", Double.TYPE, Double.TYPE)),
        TAN(new ForeignCallSignature("arithmeticTan", Double.TYPE, Double.TYPE)),
        EXP(new ForeignCallSignature("arithmeticExp", Double.TYPE, Double.TYPE));

        public final ForeignCallSignature foreignCallSignature;

        private UnaryOperation(ForeignCallSignature foreignCallSignature) {
            this.foreignCallSignature = foreignCallSignature;
        }

        public double compute(double value) {
            switch (this) {
                case LOG: {
                    return Math.log(value);
                }
                case LOG10: {
                    return Math.log10(value);
                }
                case EXP: {
                    return Math.exp(value);
                }
                case SIN: {
                    return Math.sin(value);
                }
                case COS: {
                    return Math.cos(value);
                }
                case TAN: {
                    return Math.tan(value);
                }
            }
            throw new GraalError("unknown op %s", new Object[]{this});
        }

        public Stamp computeStamp(Stamp valueStamp) {
            if (valueStamp instanceof FloatStamp) {
                FloatStamp floatStamp = (FloatStamp)valueStamp;
                switch (this) {
                    case SIN: 
                    case COS: {
                        boolean nonNaN = floatStamp.lowerBound() != Double.NEGATIVE_INFINITY && floatStamp.upperBound() != Double.POSITIVE_INFINITY && floatStamp.isNonNaN();
                        return StampFactory.forFloat(JavaKind.Double, -1.0, 1.0, nonNaN);
                    }
                    case TAN: {
                        boolean nonNaN = floatStamp.lowerBound() != Double.NEGATIVE_INFINITY && floatStamp.upperBound() != Double.POSITIVE_INFINITY && floatStamp.isNonNaN();
                        return StampFactory.forFloat(JavaKind.Double, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, nonNaN);
                    }
                    case LOG: 
                    case LOG10: {
                        double lowerBound = this.compute(floatStamp.lowerBound());
                        double upperBound = this.compute(floatStamp.upperBound());
                        if (floatStamp.contains(0.0)) {
                            lowerBound = Double.NEGATIVE_INFINITY;
                        }
                        boolean nonNaN = floatStamp.lowerBound() >= 0.0 && floatStamp.isNonNaN();
                        return StampFactory.forFloat(JavaKind.Double, lowerBound, upperBound, nonNaN);
                    }
                    case EXP: {
                        double lowerBound = Math.exp(floatStamp.lowerBound());
                        double upperBound = Math.exp(floatStamp.upperBound());
                        boolean nonNaN = floatStamp.isNonNaN();
                        return StampFactory.forFloat(JavaKind.Double, lowerBound, upperBound, nonNaN);
                    }
                }
            }
            return StampFactory.forKind(JavaKind.Double);
        }
    }
}

