/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.BitSet;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;

public class NonNullParameterPlugin
implements ParameterPlugin {
    private final BitSet nonNullParameters;

    public NonNullParameterPlugin(BitSet nonNullParameters) {
        this.nonNullParameters = nonNullParameters;
    }

    @Override
    public FloatingNode interceptParameter(GraphBuilderTool b, int index, StampPair stamp) {
        if (!this.nonNullParameters.get(index)) {
            return null;
        }
        Stamp trusted = stamp.getTrustedStamp();
        assert (trusted != null);
        Stamp improvedTrusted = trusted.tryImproveWith(StampFactory.objectNonNull());
        if (improvedTrusted == trusted || improvedTrusted == null) {
            GraalError.guarantee(improvedTrusted != null, "Non-Object parameter annotated with @NonNullParameter?");
            return null;
        }
        Stamp uncheckedStamp = stamp.getUncheckedStamp();
        Stamp improvedUntrusted = uncheckedStamp == null ? null : uncheckedStamp.improveWith(StampFactory.objectNonNull());
        return new ParameterNode(index, StampPair.create(improvedTrusted, improvedUntrusted));
    }
}

