/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.util;

import org.graalvm.compiler.nodes.AbstractMergeNode;

public class BlockWorkList {
    AbstractMergeNode[] workList;
    int[] workListNumbers;
    int workListIndex;

    public void add(AbstractMergeNode block) {
        if (this.workList == null) {
            this.allocate();
        } else if (this.workListIndex == this.workList.length) {
            this.grow();
        }
        this.workList[this.workListIndex++] = block;
    }

    public void addSorted(AbstractMergeNode block, int number) {
        int n;
        if (this.workList == null) {
            this.allocate();
        } else if (this.workListIndex == this.workList.length) {
            this.grow();
        }
        this.workList[this.workListIndex] = block;
        this.workListNumbers[this.workListIndex] = number;
        ++this.workListIndex;
        for (int i = this.workListIndex - 2; i >= 0 && (n = this.workListNumbers[i]) < number; --i) {
            this.workList[i + 1] = this.workList[i];
            this.workList[i] = block;
            this.workListNumbers[i + 1] = n;
            this.workListNumbers[i] = number;
        }
    }

    public AbstractMergeNode removeFromWorkList() {
        if (this.workListIndex != 0) {
            return this.workList[--this.workListIndex];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.workListIndex == 0;
    }

    private void allocate() {
        this.workList = new AbstractMergeNode[5];
        this.workListNumbers = new int[5];
    }

    private void grow() {
        int prevLength = this.workList.length;
        AbstractMergeNode[] nworkList = new AbstractMergeNode[prevLength * 3];
        System.arraycopy(this.workList, 0, nworkList, 0, prevLength);
        this.workList = nworkList;
        int[] nworkListNumbers = new int[prevLength * 3];
        System.arraycopy(this.workListNumbers, 0, nworkListNumbers, 0, prevLength);
        this.workListNumbers = nworkListNumbers;
    }
}

